Rem drv: <create type="pkgdefs" pos="template_pkgdef.sql+"/>
Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/template/template_ui_pkgdef.sql /st_emcore_10.2.0.4.2db11.2/1 2008/09/21 22:56:55 paachary Exp $
Rem
Rem template_ui_pkgdef.sql
Rem
Rem Copyright (c) 2008, Oracle and/or its affiliates. All rights reserved.
Rem
Rem    NAME
Rem      template_ui_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    paachary    07/16/08 - Adding new SDK APIs
Rem    paachary    04/11/08 - creating a new package for 10g codeline
Rem    paachary    04/11/08 - Created
Rem

CREATE OR REPLACE PACKAGE mgmt_template_ui
AS

    -- Public API - modify_purge_policy
    -- IN Parameters 
    --        p_policy_name
    --        p_policy_type
    --        p_purge_proc_name
    --        p_retention_days
    -- OUT Parameters
    --        none
    -- Description
    --      This API modifies the purge policy for template/ stds history tables.
    PROCEDURE modify_purge_policy(  p_policy_name       IN VARCHAR2 DEFAULT 'MGMT_TARGET_UPDATE_HISTORY',
                                    p_policy_type       IN NUMBER   DEFAULT EM_PURGE.G_POLICY_TYPE_SYSTEM,
                                    p_purge_proc_name   IN VARCHAR2 DEFAULT 'MGMT_TARGET_UPDATE.PURGE',
                                    p_retention_days    IN NUMBER   DEFAULT 180,
                                    p_policy_desc       IN VARCHAR2 DEFAULT 'Purge policy for target update history.');

    -- Public API - create_template
    -- IN Parameters 
    --        p_target_type
    --        p_source_target_name
    --        p_template_name
    --        p_description
    --        p_is_out_of_box
    -- OUT Parameters
    --        p_message_array
    --        p_return_status -  1 => success
    --                           0 => failure
    -- Description
    --      This API copies all the metric settings of the source target and creates a monitoring std
    --      with the name provided.
    PROCEDURE create_template( p_target_type           IN VARCHAR2,
                               p_source_target_name    IN VARCHAR2,
                               p_template_name         IN VARCHAR2,
                               p_description           IN VARCHAR2 DEFAULT '',
                               p_is_out_of_box         IN NUMBER DEFAULT 0,
                               p_message_array         OUT SMP_EMD_STRING_ARRAY,
                               p_return_status         OUT NUMBER);

    -- Public API - apply_template
    -- IN Parameters 
    --        p_target_type
    --        p_template_name
    --        p_apply_option
    --        p_dest_targets_list
    --        p_udm_cred_array
    -- OUT Parameters
    --        p_message_array
    --        p_return_status -  1 => success
    --                           0 => failure
    -- Description
    --      This API applies the monitoring std to the list of valid targets from the list of targets
    --      specified by the user.
     PROCEDURE apply_template( p_template_name       IN VARCHAR2, 
                               p_target_type         IN VARCHAR2,
                               p_apply_option        IN NUMBER := 2,
                               p_dest_targets_list   IN MGMT_TARGET_ARRAY,
                               p_udm_cred_array      IN UDM_CRED_ARRAY DEFAULT NULL,
                               p_message_array       OUT SMP_EMD_STRING_ARRAY,
                               p_return_status       OUT NUMBER);


    -- Public API - delete_monitoring_std
    -- IN Parameters 
    --        p_target_type
    --        p_template_name
    -- OUT Parameters
    --        p_message
    --        p_return_status -  1 => success
    --                           0 => failure
    -- Description
    --      This API deletes the specified monitoring std.
    PROCEDURE delete_template(    p_target_type           IN VARCHAR2,
                                  p_template_name         IN VARCHAR2,
                                  p_message               OUT VARCHAR2,
                                  p_return_status         OUT NUMBER);
END mgmt_template_ui;
/
