Rem
Rem $Header: test_metadata_debug.sql 10-sep-2004.16:41:54 afontana Exp $
Rem
Rem test_metadata_debug.sql
Rem
Rem Copyright (c) 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      test_metadata_debug.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    afontana    09/10/04 - afontana_test_meta_repos
Rem    afontana    08/10/04 - Created
Rem

DROP TABLE MGMT_TEST_DEFAULT_THRESHOLDS;
DROP TABLE MGMT_TEST_DEFAULT_PROMOTION;
DROP TABLE MGMT_TEST_PROP_CHOICES;
DROP TABLE MGMT_TEST_PROP;
DROP TABLE MGMT_TEST_PROP_UIGROUP;
DROP TABLE MGMT_TEST_MCOLUMNS;
DROP TABLE MGMT_TEST_METRICS;
DROP TABLE MGMT_TEST;

DECLARE
  mytype mgmt_test_metadata_obj;
  mymetric mgmt_test_metric_obj;
  myprop1 mgmt_test_prop_obj;
  mychoice1 mgmt_test_choice_obj;
  myprop2 mgmt_test_prop_obj;
  mychoice2 mgmt_test_choice_obj;
  mychoice3 mgmt_test_choice_obj; 
  
  mygroup1 mgmt_test_prop_group_obj;
  mygroup2 mgmt_test_prop_group_obj;

  mymetric_arr mgmt_test_metric_arr;
  mychoice_arr mgmt_test_choice_arr;
  myprop_arr mgmt_test_prop_arr;
  mygroup_arr mgmt_test_prop_group_arr;
  
  result INTEGER := 0;
  err_desc VARCHAR2(512) := ' ';
BEGIN
  mytype := mgmt_test_metadata_obj(
      'Alex Test', 'Alex Test Label', 'Alex Test nlsid', 'Alex Test CG',
      '1.0', '1.0', 'N', 'http_response', 'status', NULL, NULL, NULL,
      NULL, NULL);
  
  mymetric := mgmt_test_metric_obj('http_response', 0, 'N');
  mymetric_arr := mgmt_test_metric_arr(mymetric);
  
  
  mygroup1 := mgmt_test_prop_group_obj(
    'Alex Test Group 1', 0, 'Alex Test Group 1 label', 'Alex Test Group 1 nls'
  );
  
  mygroup2 := mgmt_test_prop_group_obj(
    'Alex Test Group 2', 0, 'Alex Test Group 2 label', 'Alex Test Group 2 nls'
  );
  
  mygroup_arr := mgmt_test_prop_group_arr(mygroup1, mygroup2);
  
  myprop1 := mgmt_test_prop_obj(
     'Alex Test Prop 1', 'http_response', 'Alex Test Group 1', 0, 'Alex Test Prop 1',
     'Alex Test Prop 1', 3, NULL, NULL, 1000, 0,
     'N', 'Y', 'N', 3, 'Y'
   );
   myprop2 := mgmt_test_prop_obj(
     'Alex Test Prop 2', 'http_response', 'Alex Test Group 2', 0, 'Alex Test Prop 2',
     'Alex Test Prop 2', 3, NULL, 'Default String Value', 1000, 0,
     'N', 'Y', 'N', 3, 'N'
   );
  
  myprop_arr := mgmt_test_prop_arr(
   myprop1, myprop2
  );
  
  mychoice1 := mgmt_test_choice_obj(
      'Alex Test Prop 1', 'Choice 1', 'Choice 1 label', 'Choice 1 nlsid', 0
    );
  mychoice2 := mgmt_test_choice_obj(
      'Alex Test Prop 1', 'Choice 2', 'Choice 2 label', 'Choice 2 nlsid', 1
    );
  mychoice3 := mgmt_test_choice_obj(
      'Alex Test Prop 2', 'Choice 1', 'Choice 1 label', 'Choice 1 nlsid', 0
    );
  mychoice_arr := mgmt_test_choice_arr(
    mychoice1, mychoice2, mychoice3
  );

  MGMT_TEST_METADATA_EDIT.INSERT_COMPLETE_TEST(
					       mytype, mygroup_arr, myprop_arr, mychoice_arr,
                 mymetric_arr, NULL, NULL, NULL,
					       result, err_desc);
    dbms_output.put_line('ERROR : ' || result || ' ' || err_desc);

END;

DECLARE
  result NUMBER;
  err_desc VARCHAR2(512);
BEGIN
  MGMT_TEST_METADATA_EDIT.DELETE_TEST('Alex Test', result, err_desc);
  dbms_output.put_line('ERROR : ' || result || ' ' || err_desc);
END;

DECLARE
  v_display mgmt_test_display_arr;
  v_result NUMBER;
  v_err_desc VARCHAR2(64);
BEGIN
  MGMT_TEST_METADATA_READ.READ_TEST_LIST (
	  v_display,
	  v_result,
	  v_err_desc);
  dbms_output.put_line('ERROR : ' || v_result || ' ' || v_err_desc);
  dbms_output.put_line('v_display.count: ' || v_display.count);
END;

DECLARE
  v_prop mgmt_test_prop_arr;
  v_choice mgmt_test_choice_arr;
  v_result NUMBER;
  v_err_desc VARCHAR2(2048);
BEGIN
  MGMT_TEST_METADATA_READ.READ_TEST_PROPERTIES_NOGROUPS (
	  'Alex Test', NULL, NULL, v_prop, v_choice, v_result, v_err_desc
  );

  dbms_output.put_line('ERROR : ' || v_result || ' ' || v_err_desc);
  dbms_output.put_line('v_prop.count: ' || v_prop.count);
  dbms_output.put_line('v_choice.count: ' || v_choice.count);
  
  MGMT_TEST_METADATA_READ.READ_TEST_PROPERTIES_NOGROUPS (
	  'Alex Test', NULL, 'Y', v_prop, v_choice, v_result, v_err_desc
  );

  dbms_output.put_line('ERROR : ' || v_result || ' ' || v_err_desc);
  dbms_output.put_line('v_prop.count: ' || v_prop.count);
  dbms_output.put_line('v_choice.count: ' || v_choice.count);
END;

DECLARE
  v_prop mgmt_test_prop_arr;
  v_choice mgmt_test_choice_arr;
  v_group mgmt_test_prop_group_arr;
  v_result NUMBER;
  v_err_desc VARCHAR2(2048);
BEGIN
  MGMT_TEST_METADATA_READ.READ_TEST_PROPERTIES_ALL (
	  'Alex Test', NULL, NULL, v_group, v_prop, v_choice, v_result, v_err_desc
  );

  dbms_output.put_line('ERROR : ' || v_result || ' ' || v_err_desc);
  dbms_output.put_line('v_group.count: ' || v_group.count);
  dbms_output.put_line('v_prop.count: ' || v_prop.count);
  dbms_output.put_line('v_choice.count: ' || v_choice.count);
  
  MGMT_TEST_METADATA_READ.READ_TEST_PROPERTIES_ALL (
	  'Alex Test', NULL, 'Y', v_group, v_prop, v_choice, v_result, v_err_desc
  );

  dbms_output.put_line('ERROR : ' || v_result || ' ' || v_err_desc);
  dbms_output.put_line('v_group.count: ' || v_group.count);
  dbms_output.put_line('v_prop.count: ' || v_prop.count);
  dbms_output.put_line('v_choice.count: ' || v_choice.count);
END;


DECLARE
  result NUMBER;
  err_desc VARCHAR2(512);
BEGIN
  
  MGMT_TEST_METADATA_EDIT.ENABLE_TEST_FOR_TARGET (
	                                                'Alex Test',
	                                               	'oracle_emrep',
	                                               	'2.0',
	                                                'oracle_beacon',
	                                               	result,
	                                               	err_desc
	                                                 );
END;
/


