Rem
Rem $Header: test_metadata_edit_pkgdef.sql 15-jun-2005.16:16:32 afontana Exp $
Rem
Rem test_metadata_edit_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      test_metadata_edit_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Package for managing test metadata
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    afontana    06/15/05 - add new_beacon_metric_handler 
Rem    afontana    02/28/05 - use em_metric.copy_metric 
Rem    afontana    11/16/04 - test metadata enhancements 
Rem    afontana    11/11/04 - remove commits 
Rem    afontana    10/06/04 - add encrypt to metric property 
Rem    afontana    09/10/04 - afontana_test_meta_repos
Rem    afontana    08/30/04 - add levels 
Rem    afontana    08/09/04 - Created
Rem

-- Test Metadata Package ------------------------------------------------------


CREATE OR REPLACE PACKAGE MGMT_TEST_METADATA_EDIT AS


-- ----------------------------------------------------------------------------
--  Public Procedures/Functions
-- ----------------------------------------------------------------------------

--
-- PROCEDURE INSERT_COMPLETE_TEST
--
-- Inserts a complete test specification to all tables.
--
PROCEDURE INSERT_COMPLETE_TEST (
  v_test              IN mgmt_test_metadata_obj,
  v_test_qualifiers   IN mgmt_test_qualifier_arr,
  v_groups            IN mgmt_test_prop_group_arr,
  v_properties        IN mgmt_test_prop_arr,
  v_prop_qualifiers   IN mgmt_test_prop_qualifier_arr,
  v_levels            IN mgmt_test_prop_level_arr,
  v_choices           IN mgmt_test_choice_arr,
  v_metrics           IN mgmt_test_metric_arr,
  v_mcolumns          IN mgmt_test_mcolumn_in_arr,
  v_def_promotion     IN mgmt_test_promotion_arr,
  v_def_thresholds    IN mgmt_test_thresholds_arr,
  v_result            OUT INTEGER,
  v_err_desc          OUT VARCHAR2
);

--
-- PROCEDURE UPGRADE_COMPLETE_TEST
--
-- Replaces a test definition with a new definition.
--
-- This procedure will check that the test exists, and that
-- the version is being increased.
--
-- This procedure will NOT allow test properties to be --oved.
--
PROCEDURE UPGRADE_TEST (
  v_test            IN mgmt_test_metadata_obj,
  v_test_qualifiers IN mgmt_test_qualifier_arr,
  v_groups          IN mgmt_test_prop_group_arr,
  v_properties      IN mgmt_test_prop_arr,
  v_prop_qualifiers IN mgmt_test_prop_qualifier_arr,
  v_levels          IN mgmt_test_prop_level_arr,
  v_choices         IN mgmt_test_choice_arr,
  v_metrics         IN mgmt_test_metric_arr,
  v_mcolumns        IN mgmt_test_mcolumn_in_arr,
  v_def_promotion   IN mgmt_test_promotion_arr,
  v_def_thresholds  IN mgmt_test_thresholds_arr,
  v_result          OUT INTEGER,
  v_err_desc        OUT VARCHAR2
);

--
-- PROCEDURE ENABLE_TEST_FOR_TARGET
--
-- This procedure will verify that all of the metrics
-- associated with the test exist for the given target.
-- If those metrics do not exist, then they will be created
-- in the repository for the target_type:version.
-- If the version supplied is NULL, then all versions
-- of the target_type will be affected.
--
PROCEDURE ENABLE_TEST_FOR_TARGET (
  v_test            IN VARCHAR2,
  v_target_type     IN VARCHAR2,
  v_target_ver      IN VARCHAR2,
  v_cat_prop1       IN VARCHAR2,
  v_cat_prop2       IN VARCHAR2,  
  v_cat_prop3       IN VARCHAR2,
  v_cat_prop4       IN VARCHAR2,  
  v_cat_prop5       IN VARCHAR2,  
  v_monitoring_type IN VARCHAR2 DEFAULT mgmt_global.G_BEACON_TARGET_TYPE,
  v_result          OUT INTEGER,
  v_err_desc        OUT VARCHAR2
);

--
-- PROCEDURE DELETE_TEST
--
-- Deletes a test from all tables.
--
PROCEDURE DELETE_TEST (
  v_test_type    IN VARCHAR2,
  v_result       OUT INTEGER,
  v_err_desc     OUT VARCHAR2
);

--
-- PROCEDURE DEPRECATE_TEST
-- 
-- Takes a test_id and deprecates that test.
--
-- On success, returns 0.
-- On failure, returns < 0 with err_desc filled.
--
PROCEDURE DEPRECATE_TEST (
  v_test_type    IN VARCHAR2,
  v_result       OUT INTEGER,
  v_err_desc     OUT VARCHAR2
);

--
-- gen_metric_property_guid
--
-- Generates a guid for a metric property.
--
FUNCTION GEN_METRIC_PROPERTY_GUID(v_target_type   IN VARCHAR2,
                                  v_metric_name   IN VARCHAR2,
                                  v_property_name IN VARCHAR2) 
         RETURN RAW;
         
--
-- add_metric_property
--
-- Adds a metric property to the query descriptor table.
--
PROCEDURE ADD_METRIC_PROPERTY(v_target_type     IN VARCHAR2,
                              v_type_meta_ver   IN VARCHAR2,
                              v_metric_name     IN VARCHAR2,
                              v_property_name   IN VARCHAR2,
                              v_scope           IN VARCHAR2,
                              v_optional        IN CHAR,
                              v_encrypt         IN CHAR,
                              v_result          OUT INTEGER,
                              v_err_desc        OUT VARCHAR2);

PROCEDURE INSERT_PROPERTIES(v_props  IN mgmt_test_mprop_ver_arr,
                            v_result          OUT INTEGER,
                            v_err_desc        OUT VARCHAR2);


-- ------------------------------------------------------------------------
-- Internal Package Types
-- ------------------------------------------------------------------------

-- ------------------------------------------------------------------------
-- Package Error Codes
-- ------------------------------------------------------------------------

p_success                       CONSTANT INTEGER := 0;

p_unknown_sql_error             CONSTANT INTEGER := -100;

p_test_insert_sql_error         CONSTANT INTEGER := -110;
p_groups_insert_sql_error       CONSTANT INTEGER := -111;
p_properties_insert_sql_error   CONSTANT INTEGER := -112;
p_choices_insert_sql_error      CONSTANT INTEGER := -113;

p_metrics_insert_sql_error      CONSTANT INTEGER := -114;
p_mcolumns_insert_sql_error     CONSTANT INTEGER := -115;
p_promotion_insert_sql_error    CONSTANT INTEGER := -116;

p_thresholds_insert_sql_error   CONSTANT INTEGER := -117;

p_test_qual_insert_sql_error    CONSTANT INTEGER := -118;
p_prop_qual_insert_sql_error    CONSTANT INTEGER := -119;

p_test_not_found_error          CONSTANT INTEGER := -120;


p_key_column_conflict           CONSTANT INTEGER := -200;

p_max_err_size                  CONSTANT INTEGER := 2048;


-- ------------------------------------------------------------------------
-- Globals / Constants
-- ------------------------------------------------------------------------


END MGMT_TEST_METADATA_EDIT;
/
-- ------------------------------------------------------------------------
show errors;

