Rem
Rem $Header: test_metadata_metrics_pkgbody.sql 04-oct-2005.18:28:00 afontana Exp $
Rem
Rem test_metadata_metrics_pkgbody.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      test_metadata_metrics_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    afontana    10/04/05 - add debug logging 
Rem    afontana    10/04/05 - add logging for failure 
Rem    afontana    10/04/05 - remove reference to rownum 
Rem    afontana    10/03/05 - do not update when older beacon is inserted 
Rem    afontana    09/13/05 - update metrics during test registration if 
Rem                           needed 
Rem    afontana    09/12/05 - update existing metrics on name change 
Rem    afontana    07/26/05 - afontana_metric_versioning
Rem    afontana    07/25/05 - reinsert logging 
Rem    afontana    07/15/05 - remove logging on copy metric
Rem    afontana    07/05/05 - catch exceptions on insert 
Rem    afontana    07/01/05 - do not use triggers approach 
Rem    afontana    06/16/05 - Created
Rem

CREATE OR REPLACE PACKAGE BODY MGMT_TEST_METADATA_METRICS AS

--
-- Handles all new metrics, copying to service targets.
--
PROCEDURE HANDLE_NEW_METRICS(v_target_type IN VARCHAR2,
                             v_type_meta_ver IN VARCHAR2)
IS
  l_max_type_meta_ver mgmt_target_types.max_type_meta_ver%TYPE;
BEGIN

  SELECT max_type_meta_ver
    INTO l_max_type_meta_ver
    FROM mgmt_target_types
   WHERE target_type = v_target_type;

  --verify that we are not handling an old type_meta_ver
  IF (em_target.compare_type_meta_vers(l_max_type_meta_ver, 
                                       v_type_meta_ver) > 0) THEN
    RETURN;
  END IF;

  FOR rec IN
  (SELECT 
          -- Given the tgttype (oracle_beacon) and ver, get all metrics
          metr.metric_name metric_name,
          metr.metric_column metric_column,
          metr.category_prop_1 src_category_prop1,
          metr.category_prop_2 src_category_prop2,
          metr.category_prop_3 src_category_prop3,
          metr.category_prop_4 src_category_prop4,
          metr.category_prop_5 src_category_prop5,

          -- Get the service target types that use these metrics
          map.target_type dst_target_type,
          version.type_meta_ver dst_type_meta_ver,
          map.cat_prop1 dst_category_prop1,
          map.cat_prop2 dst_category_prop2,
          map.cat_prop3 dst_category_prop3,
          map.cat_prop4 dst_category_prop4,
          map.cat_prop5 dst_category_prop5

     FROM mgmt_metrics metr,
          mgmt_test_target_map map,
          mgmt_target_type_versions version,
          mgmt_test_metrics test_metrics

    WHERE 
      -- get all the remote metrics for the given beacon version
          metr.target_type = v_target_type
      AND metr.type_meta_ver = v_type_meta_ver
      AND metr.remote = 1

      -- get all test types that use these metrics
      AND metr.metric_name = test_metrics.metric_name

      -- given the test type, get the mapping to service target types
      AND test_metrics.test_type = map.test_type
      AND map.target_type <> v_target_type

      -- get all relevant service type_meta_vers
      AND map.target_type = version.target_type
      AND (map.target_meta_ver IS NULL OR
           em_target.compare_type_meta_vers(map.target_meta_ver, 
                                            version.type_meta_ver) <= 0)

      -- avoid updating self
      AND map.target_type <> v_target_type)

  LOOP
    BEGIN
      COPY_METRIC(
                  -- from here
                  v_target_type,
                  rec.metric_name,
                  rec.metric_column,
                  v_type_meta_ver,
                  rec.src_category_prop1,
                  rec.src_category_prop2,
                  rec.src_category_prop3,
                  rec.src_category_prop4,
                  rec.src_category_prop5,
                  -- to here
                  rec.dst_target_type,
                  rec.metric_name,
                  rec.metric_column,
                  rec.dst_type_meta_ver,
                  rec.dst_category_prop1,
                  rec.dst_category_prop2,
                  rec.dst_category_prop3,
                  rec.dst_category_prop4,
                  rec.dst_category_prop5);
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
        UPDATE_METRIC(
                  -- from here
                  v_target_type,
                  rec.metric_name,
                  rec.metric_column,
                  v_type_meta_ver,
                  rec.src_category_prop1,
                  rec.src_category_prop2,
                  rec.src_category_prop3,
                  rec.src_category_prop4,
                  rec.src_category_prop5,
                  -- to here
                  rec.dst_target_type,
                  rec.metric_name,
                  rec.metric_column,
                  rec.dst_type_meta_ver,
                  rec.dst_category_prop1,
                  rec.dst_category_prop2,
                  rec.dst_category_prop3,
                  rec.dst_category_prop4,
                  rec.dst_category_prop5);

      WHEN OTHERS THEN
        MGMT_LOG.LOG_ERROR('TEST_METADATA', null,
                           'COPY_METRIC: ' || 
                           rec.dst_target_type || ' ' ||
                           rec.metric_name || ' ' ||
                           rec.metric_column || ' ' ||
                           SUBSTR(SQLERRM, 1, 800));

    END;
  END LOOP;

END HANDLE_NEW_METRICS;

--
-- Copies a given row in mgmt_metrics from one key to another
--
PROCEDURE COPY_METRIC(v_from_target_type    IN VARCHAR2,
                      v_from_metric_name    IN VARCHAR2,
                      v_from_metric_column  IN VARCHAR2,
                      v_from_type_meta_ver  IN VARCHAR2,
                      v_from_cat_prop_1     IN VARCHAR2,
                      v_from_cat_prop_2     IN VARCHAR2,
                      v_from_cat_prop_3     IN VARCHAR2,
                      v_from_cat_prop_4     IN VARCHAR2,
                      v_from_cat_prop_5     IN VARCHAR2,
                      v_to_target_type      IN VARCHAR2,
                      v_to_metric_name      IN VARCHAR2,
                      v_to_metric_column    IN VARCHAR2,
                      v_to_type_meta_ver    IN VARCHAR2,
                      v_to_cat_prop_1       IN VARCHAR2,
                      v_to_cat_prop_2       IN VARCHAR2,
                      v_to_cat_prop_3       IN VARCHAR2,
                      v_to_cat_prop_4       IN VARCHAR2,
                      v_to_cat_prop_5       IN VARCHAR2)
IS
  l_exists MGMT_METRICS.METRIC_GUID%TYPE;
BEGIN

  --NB. This loop only gets executed once since we
  --query a PK.  The loop is purely for syntax convenience.

  BEGIN
    SELECT metric_guid INTO l_exists
      FROM MGMT_METRICS
     WHERE TARGET_TYPE = v_to_target_type
       AND METRIC_NAME = v_to_metric_name
       AND METRIC_COLUMN =  v_to_metric_column
       AND TYPE_META_VER = v_to_type_meta_ver
       AND CATEGORY_PROP_1 = v_to_cat_prop_1
       AND CATEGORY_PROP_2 = v_to_cat_prop_2
       AND CATEGORY_PROP_3 = v_to_cat_prop_3
       AND CATEGORY_PROP_4 = v_to_cat_prop_4
       AND CATEGORY_PROP_5 = v_to_cat_prop_5;
  EXCEPTION WHEN NO_DATA_FOUND THEN
    FOR l_metric IN
    (
    SELECT *
      FROM MGMT_METRICS
     WHERE TARGET_TYPE = v_from_target_type
       AND METRIC_NAME = v_from_metric_name
       AND METRIC_COLUMN =  v_from_metric_column
       AND TYPE_META_VER = type_meta_ver
       AND CATEGORY_PROP_1 = v_from_cat_prop_1
       AND CATEGORY_PROP_2 = v_from_cat_prop_2
       AND CATEGORY_PROP_3 = v_from_cat_prop_3
       AND CATEGORY_PROP_4 = v_from_cat_prop_4
       AND CATEGORY_PROP_5 = v_from_cat_prop_5
    )
    LOOP
  
      l_metric.TARGET_TYPE     := v_to_target_type;
      l_metric.METRIC_NAME     := v_to_metric_name;
      l_metric.METRIC_COLUMN   := v_to_metric_column;
      l_metric.TYPE_META_VER   := v_to_type_meta_ver;
      l_metric.CATEGORY_PROP_1 := v_to_cat_prop_1;
      l_metric.CATEGORY_PROP_2 := v_to_cat_prop_2;
      l_metric.CATEGORY_PROP_3 := v_to_cat_prop_3;
      l_metric.CATEGORY_PROP_4 := v_to_cat_prop_4;
      l_metric.CATEGORY_PROP_5 := v_to_cat_prop_5;
      l_metric.METRIC_GUID     := mgmt_metric.generate_metric_guid(
                                                   v_to_target_type,
                                                   v_to_metric_name,
                                                   v_to_metric_column);
  
  
      INSERT INTO MGMT_METRICS VALUES l_metric;
  
    END LOOP;
    RETURN;
  END;

  RAISE DUP_VAL_ON_INDEX;
 
END COPY_METRIC;



--
-- Updates display names of service metrics
--
PROCEDURE UPDATE_METRIC(v_from_target_type    IN VARCHAR2,
                        v_from_metric_name    IN VARCHAR2,
                        v_from_metric_column  IN VARCHAR2,
                        v_from_type_meta_ver  IN VARCHAR2,
                        v_from_cat_prop_1     IN VARCHAR2,
                        v_from_cat_prop_2     IN VARCHAR2,
                        v_from_cat_prop_3     IN VARCHAR2,
                        v_from_cat_prop_4     IN VARCHAR2,
                        v_from_cat_prop_5     IN VARCHAR2,
                        v_to_target_type      IN VARCHAR2,
                        v_to_metric_name      IN VARCHAR2,
                        v_to_metric_column    IN VARCHAR2,
                        v_to_type_meta_ver    IN VARCHAR2,
                        v_to_cat_prop_1       IN VARCHAR2,
                        v_to_cat_prop_2       IN VARCHAR2,
                        v_to_cat_prop_3       IN VARCHAR2,
                        v_to_cat_prop_4       IN VARCHAR2,
                        v_to_cat_prop_5       IN VARCHAR2)
IS
BEGIN
  FOR l_metric IN
  (
  SELECT COLUMN_LABEL,
         COLUMN_LABEL_NLSID,
         METRIC_LABEL,
         METRIC_LABEL_NLSID,
         DESCRIPTION,
         DESCRIPTION_NLSID,
         SHORT_NAME,
         SHORT_NAME_NLSID
    FROM MGMT_METRICS
   WHERE TARGET_TYPE = v_from_target_type
     AND METRIC_NAME = v_from_metric_name
     AND METRIC_COLUMN =  v_from_metric_column
     AND TYPE_META_VER = type_meta_ver
     AND CATEGORY_PROP_1 = v_from_cat_prop_1
     AND CATEGORY_PROP_2 = v_from_cat_prop_2
     AND CATEGORY_PROP_3 = v_from_cat_prop_3
     AND CATEGORY_PROP_4 = v_from_cat_prop_4
     AND CATEGORY_PROP_5 = v_from_cat_prop_5
  )
  LOOP

    UPDATE MGMT_METRICS
       SET COLUMN_LABEL = l_metric.COLUMN_LABEL,
           COLUMN_LABEL_NLSID = l_metric.COLUMN_LABEL_NLSID,
           METRIC_LABEL = l_metric.METRIC_LABEL,
           METRIC_LABEL_NLSID = l_metric.METRIC_LABEL_NLSID,
           DESCRIPTION = l_metric.DESCRIPTION,
           DESCRIPTION_NLSID = l_metric.DESCRIPTION_NLSID,
           SHORT_NAME = l_metric.SHORT_NAME,
           SHORT_NAME_NLSID = l_metric.SHORT_NAME_NLSID
     WHERE TARGET_TYPE = v_to_target_type
       AND METRIC_NAME = v_to_metric_name
       AND METRIC_COLUMN = v_to_metric_column
       AND TYPE_META_VER = v_to_type_meta_ver
       AND CATEGORY_PROP_1 = v_to_cat_prop_1
       AND CATEGORY_PROP_2 = v_to_cat_prop_2
       AND CATEGORY_PROP_3 = v_to_cat_prop_3
       AND CATEGORY_PROP_4 = v_to_cat_prop_4
       AND CATEGORY_PROP_5 = v_to_cat_prop_5;

        MGMT_LOG.LOG_ERROR(v_module_name_in => 'TEST_METADATA',
                           v_error_code_in => NULL,
                           v_error_msg_in => 'COPY_METRIC: ' || 
                                             v_to_target_type || ' ' ||
                                             v_to_metric_name || ' ' ||
                                             v_to_metric_column || ' ' ||
                                             SUBSTR(SQLERRM, 1, 800),
                           v_log_level_in => MGMT_GLOBAL.G_INFO);

  END LOOP;

END UPDATE_METRIC;

END MGMT_TEST_METADATA_METRICS;
/
-- ------------------------------------------------------------------------
show errors;

