Rem
Rem $Header: test_metadata_read_pkgdef.sql 20-may-2005.12:30:09 rmarripa Exp $
Rem
Rem test_metadata_read_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      test_metadata_read_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      API to read test metadata
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rmarripa    05/20/05 - move READ_TEST_METADATA to package definition 
Rem    afontana    04/26/05 - add default promotions to TestTargetMetrics 
Rem    rmarripa    11/23/04 - add proc to get avail metric 
Rem    afontana    11/16/04 - test metadata enhancements 
Rem    afontana    09/27/04 - read testMetadata with test properties 
Rem    afontana    09/10/04 - afontana_test_meta_repos
Rem    afontana    08/27/04 - fix indentations from jdev 
Rem    afontana    08/09/04 - Created
Rem




-- Test Metadata Package ------------------------------------------------------

CREATE OR REPLACE PACKAGE MGMT_TEST_METADATA_READ AS


-- ----------------------------------------------------------------------------
--  Public Procedures/Functions
-- ----------------------------------------------------------------------------

--
-- PROCEDURE READ_TEST_METADATA
-- 
-- Reads the entire list of tests that are not deprecated.
--
-- On success, returns 0.
-- On failure, returns < 0 with err_desc filled.
--
PROCEDURE READ_TEST_METADATA (
  v_test_type         IN VARCHAR2,
  v_metadata          OUT mgmt_test_metadata_obj,
  v_result            OUT INTEGER,
  v_err_desc          OUT VARCHAR2
);

--
-- PROCEDURE READ_TEST_LIST
-- 
-- Reads the entire list of tests that are not deprecated.
--
-- On success, returns 0.
-- On failure, returns < 0 with err_desc filled.
--
PROCEDURE READ_TEST_LIST (
  v_target_type     IN VARCHAR2,
  v_target_ver      IN VARCHAR2,
  v_cat_prop1       IN VARCHAR2,
  v_cat_prop2       IN VARCHAR2,
  v_cat_prop3       IN VARCHAR2,
  v_cat_prop4       IN VARCHAR2,
  v_cat_prop5       IN VARCHAR2,
  v_tests           OUT mgmt_test_display_arr,
  v_result          OUT INTEGER,
  v_err_desc        OUT VARCHAR2
);


--
-- PROCEDURE READ_COLLECTION_METADATA
-- 
-- Reads the entire list of metrics (in order)
-- and the collection generator.
--
-- On success, returns 0.
-- On failure, returns < 0 with err_desc filled.
--
PROCEDURE READ_COLLECTION_METADATA (
  v_test_type          IN VARCHAR2,
  v_test               OUT mgmt_test_metadata_obj,
  v_test_quals         OUT mgmt_test_qualifier_arr,
  v_metrics            OUT mgmt_test_metric_arr,
  v_valid_columns      OUT mgmt_test_mcolumn_ver_arr,
  v_valid_props        OUT mgmt_test_mprop_ver_arr,
  v_result             OUT INTEGER,
  v_err_desc           OUT VARCHAR2
);


--
-- PROCEDURE READ_TEST_PROPERTIES_ALL
--
-- Read a list of properties, choices and UI groups 
-- for a given test id and a given scope.
-- The input scope will be used as a filter.
-- If scope is NULL, all properties will be returned.
--
-- On success, returns 0.
-- On failure, returns < 0 with err_desc filled.
--
PROCEDURE READ_TEST_PROPERTIES_ALL (
  v_test_type          IN VARCHAR2,
  v_test               OUT mgmt_test_metadata_obj,
  v_test_quals         OUT mgmt_test_qualifier_arr,
  v_groups             OUT mgmt_test_prop_group_arr,
  v_properties         OUT mgmt_test_prop_arr,
  v_prop_quals         OUT mgmt_test_prop_qualifier_arr,
  v_choices            OUT mgmt_test_choice_arr,
  v_levels             OUT mgmt_test_prop_level_arr,
  v_result             OUT INTEGER,
  v_err_desc           OUT VARCHAR2
);

--
-- PROCEDURE READ_TEST_METRIC_COLUMNS
-- 
-- Reads the metric columns for a given test_type and metric.
-- If metric_number is NULL, then all metric columns will be read.
--
-- This function will search MGMT_METRICS for metric columns that exist
-- but are not listed in the test.  This allows a generic UI to absorb
-- new metric columns that are added whenever a beacon is upgraded.
--
-- On success, returns 0.
-- On failure, returns < 0 with err_desc filled.
--
PROCEDURE READ_TEST_METRIC_COLUMNS (
  v_test_type            IN  VARCHAR2,   
  v_target_type          IN  VARCHAR2,
  v_target_version       IN  VARCHAR2,
  v_metric_name          IN  VARCHAR2,
  v_test                 OUT mgmt_test_metadata_obj,
  v_test_quals           OUT mgmt_test_qualifier_arr,
  v_metrics              OUT mgmt_test_metric_out_arr,
  v_metric_columns       OUT mgmt_test_mcolumn_out_arr,
  v_test_promos          OUT mgmt_test_promotion_arr,
  v_result               OUT INTEGER,
  v_err_desc             OUT VARCHAR2
);

--
-- PROCEDURE READ_DEFAULT_PROMOTIONS
--
-- Given a test type, read in all the default promotions.
--
PROCEDURE READ_DEFAULT_PROMOTIONS (
  v_test_type            IN VARCHAR2,
  v_promotions           OUT mgmt_test_promotion_arr,
  v_result               OUT INTEGER,
  v_err_desc             OUT VARCHAR2
);

--
-- PROCEDURE READ_DEFAULT_THRESHOLDS
--
-- Given a test type, read the default beacon thresholds.
--
PROCEDURE READ_DEFAULT_THRESHOLDS (
  v_test_type            IN VARCHAR2,
  v_thresholds           OUT mgmt_test_thresholds_arr,
  v_result               OUT INTEGER,
  v_err_desc             OUT VARCHAR2
);

--
-- PROCEDURE GET_AVAIL_METRIC
--
-- Given a test type, read the availability metric
--
PROCEDURE GET_AVAIL_METRIC (
  v_test_type            IN VARCHAR2,
  v_metric_name          OUT VARCHAR2,
  v_metric_column        OUT VARCHAR2
);


-- ------------------------------------------------------------------------
-- Internal Package Types
-- ------------------------------------------------------------------------

-- ------------------------------------------------------------------------
-- Package Error Codes
-- ------------------------------------------------------------------------

p_success                      CONSTANT INTEGER := 0;

p_unknown_sql_err              CONSTANT INTEGER := -100;

-- ------------------------------------------------------------------------
-- Globals / Constants
-- ------------------------------------------------------------------------

p_max_err_size                 CONSTANT INTEGER := 2048;

END MGMT_TEST_METADATA_READ;
/
-- ------------------------------------------------------------------------
show errors;
