Rem drv: <create type="types" pos="chronos/chronos_types.sql+"/>
Rem
Rem $Header: test_metadata_types.sql 29-jun-2005.01:47:08 gsbhatia Exp $
Rem
Rem test_metadata_types.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      test_metadata_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Types defined for test metadata used by remotely monitored services
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    afontana    01/12/05 - add short names 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    afontana    11/18/04 - add is_for_summary 
Rem    afontana    11/16/04 - test metadata enhancements 
Rem    afontana    11/11/04 - add operator and num occurrences to thresholds 
Rem    afontana    10/05/04 - add encrypt field to MGMT_TEST_METRIC_PROPS 
Rem    afontana    09/10/04 - afontana_test_meta_repos
Rem    afontana    09/09/04 - add password attribute to properties 
Rem    afontana    08/30/04 - add levels 
Rem    afontana    08/09/04 - Created
Rem


Rem
Rem
Rem   Test Metadata objects
Rem
Rem

CREATE OR REPLACE TYPE mgmt_test_display_obj AS OBJECT 
  (
    test_type          VARCHAR2(64),
    label              VARCHAR2(64),
    nlsid              VARCHAR2(64),
    resource_bundle    VARCHAR2(4000)
  );
/

CREATE OR REPLACE TYPE mgmt_test_display_arr AS
	TABLE OF mgmt_test_display_obj;
/


CREATE OR REPLACE TYPE mgmt_test_metadata_obj AS OBJECT 
  (
    test_type                 VARCHAR2(64),
    label                     VARCHAR2(64),
    nlsid                     VARCHAR2(64),
    resource_bundle           VARCHAR2(4000),
    collection_generator      VARCHAR2(4000),
    min_beacon_ver            VARCHAR2(8),
    test_version              VARCHAR2(8),
    deprecated                CHAR(1),
    avail_metric              VARCHAR2(64),
    avail_mcolumn             VARCHAR2(64),
    help_id                   VARCHAR2(256),
    tip_text                  VARCHAR2(4000),
    tip_text_nlsid            VARCHAR2(64),
    validator                 VARCHAR2(4000)
  );
/


Rem
Rem
Rem   Test properties UI groups
Rem
Rem

CREATE OR REPLACE TYPE mgmt_test_prop_group_obj AS OBJECT 
  (
    group_name              VARCHAR2(64),
    display_order           NUMBER,
    label                   VARCHAR2(64),
    nlsid                   VARCHAR2(64),
    tip_text                VARCHAR2(64),
    tip_text_nlsid          VARCHAR2(64)
  );
/

CREATE OR REPLACE TYPE mgmt_test_prop_group_arr AS
	TABLE OF mgmt_test_prop_group_obj;
/



Rem
Rem
Rem   Test properties
Rem
Rem

CREATE OR REPLACE TYPE mgmt_test_prop_obj AS OBJECT 
  (
    property_name             VARCHAR2(64),
    group_name                VARCHAR2(64),
    display_order             NUMBER,
    label                     VARCHAR2(64),
    nlsid                     VARCHAR2(64),
    property_type             NUMBER,
    default_numeric_value     NUMBER,
    default_string_value      VARCHAR2(64),
    maximum_value             NUMBER,
    minimum_value             NUMBER,
    hidden                    CHAR(1),
    encrypt                   CHAR(1),
    password                  CHAR(1),
    varies_per_beacon         CHAR(1),
    tip_text                  VARCHAR2(4000),
    tip_text_nlsid            VARCHAR2(64),
    validator                 VARCHAR2(4000)
  );
/

CREATE OR REPLACE TYPE mgmt_test_prop_arr AS
	TABLE OF mgmt_test_prop_obj;
/

CREATE OR REPLACE TYPE mgmt_test_mprop_ver_obj AS OBJECT
  (
    TARGET_TYPE             VARCHAR2(64),
    TYPE_META_VER           VARCHAR2(8),
    METRIC_NAME             VARCHAR2(64),
    PROPERTY_NAME           VARCHAR2(64),
    SCOPE                   VARCHAR2(64),
    OPTIONAL                CHAR(1),
    ENCRYPT                 CHAR(1)
  );
/

CREATE OR REPLACE TYPE mgmt_test_mprop_ver_arr AS
  TABLE OF mgmt_test_mprop_ver_obj;
/

Rem
Rem
Rem   Test property choices
Rem
Rem
CREATE OR REPLACE TYPE mgmt_test_choice_obj AS OBJECT 
  (
    property_name     VARCHAR2(64),
    choice_name       VARCHAR2(64),
    label             VARCHAR2(64),
    nlsid             VARCHAR2(64),
    choice_order      NUMBER
  );
/

CREATE OR REPLACE TYPE mgmt_test_choice_arr AS
	TABLE OF mgmt_test_choice_obj;
/


Rem
Rem
Rem   Test property levels
Rem
Rem
CREATE OR REPLACE TYPE mgmt_test_prop_level_obj AS OBJECT 
  (
    property     VARCHAR2(64),
    level_name   VARCHAR2(64),
    optional     CHAR(1)
  );
/

CREATE OR REPLACE TYPE mgmt_test_prop_level_arr AS
	TABLE OF mgmt_test_prop_level_obj;
/


Rem
Rem
Rem   Associated metric and metric columns
Rem
Rem
CREATE OR REPLACE TYPE mgmt_test_metric_obj AS OBJECT 
  (
    metric_name       VARCHAR2(64),
    metric_number     NUMBER,
    interactive       CHAR(1),
    level_name        VARCHAR2(64)
  );
/

CREATE OR REPLACE TYPE mgmt_test_metric_arr AS
	TABLE OF mgmt_test_metric_obj;
/

CREATE OR REPLACE TYPE mgmt_test_metric_out_obj AS OBJECT 
  (
    metric_name        VARCHAR2(64),
    label              VARCHAR2(64),
    nlsid              VARCHAR2(64),
    metric_number      NUMBER,
    interactive        CHAR(1),
    level_name         VARCHAR2(64)
  );
/

CREATE OR REPLACE TYPE mgmt_test_metric_out_arr AS
	TABLE OF mgmt_test_metric_out_obj;
/


CREATE OR REPLACE TYPE mgmt_test_mcolumn_in_obj AS OBJECT 
  (
    metric_name        VARCHAR2(64),
    metric_column      VARCHAR2(64),
    display_order      NUMBER	
  );
/

CREATE OR REPLACE TYPE mgmt_test_mcolumn_in_arr AS
	TABLE OF mgmt_test_mcolumn_in_obj;
/

CREATE OR REPLACE TYPE mgmt_test_mcolumn_out_obj AS OBJECT 
  (
    metric_guid       VARCHAR2(32),
    metric_name       VARCHAR2(64),
    metric_column     VARCHAR2(64),
    display_order     NUMBER,
    label             VARCHAR2(64),
    nlsid             VARCHAR2(64),
    metric_type       NUMBER,
    is_for_summary    NUMBER,
    short_name        VARCHAR2(64),
    short_nlsid       VARCHAR2(64)
  );
/

CREATE OR REPLACE TYPE mgmt_test_mcolumn_out_arr AS
	TABLE OF mgmt_test_mcolumn_out_obj;
/

CREATE OR REPLACE TYPE mgmt_test_mcolumn_ver_obj AS OBJECT 
  (
    metric_name       VARCHAR2(64),
    metric_column     VARCHAR2(64),
    beacon_version    VARCHAR2(8)
  );
/

CREATE OR REPLACE TYPE mgmt_test_mcolumn_ver_arr AS
	TABLE OF mgmt_test_mcolumn_ver_obj;
/



Rem
Rem
Rem   Default metric promotion
Rem
Rem
CREATE OR REPLACE TYPE mgmt_test_promotion_obj AS OBJECT 
  (
    src_metric_name             VARCHAR2(64),
    src_metric_column           VARCHAR2(64),
    src_metric_key1_value       VARCHAR2(64),
    src_metric_key2_value       VARCHAR2(64),
    src_metric_key3_value       VARCHAR2(64),
    src_metric_key4_value       VARCHAR2(64),
    src_metric_key5_value       VARCHAR2(64),
    eval_func                   VARCHAR2(256),
    critical                    NUMBER,
    warning                     NUMBER,
    operator                    VARCHAR2(16),
    num_occurrences             NUMBER,
    dest_metric_name            VARCHAR2(64),
    dest_metric_column          VARCHAR2(64),
    dest_metric_key1_value      VARCHAR2(64),
    dest_metric_key2_value      VARCHAR2(64),
    dest_metric_key3_value      VARCHAR2(64),
    dest_metric_key4_value      VARCHAR2(64),
    dest_metric_key5_value      VARCHAR2(64),
    default_chart               CHAR(1)
  );
/

CREATE OR REPLACE TYPE mgmt_test_promotion_arr AS
	TABLE OF mgmt_test_promotion_obj;
/



Rem
Rem
Rem   Default thresholds
Rem
Rem
CREATE OR REPLACE TYPE mgmt_test_thresholds_obj AS OBJECT 
  (
    metric_name             VARCHAR2(64),
    metric_column           VARCHAR2(64),
    metric_key1_value       VARCHAR2(64),
    metric_key2_value       VARCHAR2(64),
    metric_key3_value       VARCHAR2(64),
    metric_key4_value       VARCHAR2(64),
    metric_key5_value       VARCHAR2(64),
    critical                NUMBER,
    warning                 NUMBER,
    operator                VARCHAR2(16),
    num_occurrences         NUMBER
  );
/

CREATE OR REPLACE TYPE mgmt_test_thresholds_arr AS
	TABLE OF mgmt_test_thresholds_obj;
/


Rem
Rem
Rem      Test Qualifiers
Rem
Rem
CREATE OR REPLACE TYPE mgmt_test_qualifier_obj AS OBJECT
  (
    qualifier             VARCHAR2(64),
    text_value            VARCHAR2(4000),
    numeric_value         NUMBER
  );
/

CREATE OR REPLACE TYPE mgmt_test_qualifier_arr AS
        TABLE OF mgmt_test_qualifier_obj;
/


Rem
Rem
Rem      Test Property Qualifiers
Rem
Rem
CREATE OR REPLACE TYPE mgmt_test_prop_qualifier_obj AS OBJECT
  (
    property              VARCHAR2(64),
    qualifier             VARCHAR2(64),
    text_value            VARCHAR2(4000),
    numeric_value         NUMBER
  );
/

CREATE OR REPLACE TYPE mgmt_test_prop_qualifier_arr AS
        TABLE OF mgmt_test_prop_qualifier_obj;
/
