Rem drv: <create type="pkgbodys" pos="ip/dashboard_service/dashboard_service_pkgbody.sql+"/>
Rem
Rem $Header: topology_pkgbody.sql 01-jul-2005.21:27:19 gsbhatia Exp $
Rem
Rem topology_pkgbody.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      topology_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    nigupta     01/06/05 - add update procedures 
Rem    nigupta     01/04/05 - nigupta_fixed_coords
Rem    nigupta     12/23/04 - Created
Rem

CREATE OR REPLACE PACKAGE BODY em_topology AS

  G_TRUE CONSTANT INTEGER := 1;
  G_FALSE CONSTANT INTEGER := 0;

  PROCEDURE get_background_image
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE,
     image_data_out OUT cursorType)
  IS 
  BEGIN
    OPEN image_data_out FOR 
    SELECT image_name, image_data 
    FROM mgmt_topo_page_bg_image
    WHERE topo_page_type = topo_page_type_in 
      AND page_instance_id = page_instance_id_in; 
  END get_background_image;


  PROCEDURE get_graph_properties
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE,
     graph_properties_out OUT cursorType)
  IS
  BEGIN
    OPEN graph_properties_out FOR
      SELECT preference_name, preference_value
      FROM mgmt_topo_page_pref
      WHERE topo_page_type = topo_page_type_in
        AND page_instance_id = page_instance_id_in;
  END get_graph_properties;


  PROCEDURE get_node_positions
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE,
     node_positions_out OUT cursorType)
  IS 
  BEGIN
    OPEN node_positions_out FOR
      SELECT node_id, x, y
      FROM mgmt_topo_page_obj_pos
      WHERE topo_page_type = topo_page_type_in
        AND page_instance_id = page_instance_id_in;
  END get_node_positions;

  
  PROCEDURE update_background_image 
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE,
     edit_mode_in IN INTEGER,
     image_name_in IN mgmt_topo_page_bg_image.image_name%TYPE,
     image_data_in IN mgmt_topo_page_bg_image.image_data%TYPE) 
  IS
  BEGIN
    IF (edit_mode_in = G_TRUE)
    THEN
      -- delete the previous image 
      DELETE
        FROM mgmt_topo_page_bg_image
        WHERE topo_page_type = topo_page_type_in
          AND page_instance_id = page_instance_id_in;
    END IF;

    -- save the new image 
    IF (image_name_in IS NOT NULL AND image_data_in IS NOT NULL)
    THEN 
      INSERT INTO mgmt_topo_page_bg_image
        (topo_page_type, page_instance_id, image_name, image_data) 
      VALUES (topo_page_type_in, page_instance_id_in, image_name_in, 
              image_data_in);
    END IF;
  END update_background_image;

  PROCEDURE update_graph_properties 
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE,
     edit_mode_in IN INTEGER,
     graph_properties_in IN SMP_EMD_NVPAIR_ARRAY) 
  IS
  BEGIN
    IF (edit_mode_in = G_TRUE)
    THEN
      -- delete the previous properties
      DELETE
        FROM mgmt_topo_page_pref
        WHERE topo_page_type = topo_page_type_in
          AND page_instance_id = page_instance_id_in
          AND preference_name IN
              (SELECT name
               FROM TABLE(CAST(graph_properties_in AS SMP_EMD_NVPAIR_ARRAY)));
    END IF;

    -- save the new values
    IF (graph_properties_in IS NOT NULL AND graph_properties_in.COUNT > 0)
    THEN 
      INSERT INTO mgmt_topo_page_pref
        (topo_page_type, page_instance_id, preference_name, preference_value)
      SELECT topo_page_type_in, page_instance_id_in, t.name, t.value
        FROM TABLE(CAST(graph_properties_in AS SMP_EMD_NVPAIR_ARRAY)) t;
    END IF;
  END update_graph_properties;

  PROCEDURE update_node_positions 
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE,
     edit_mode_in IN INTEGER,
     node_positions_in IN TOPO_NODE_POS_ARRAY) 
  IS
  BEGIN
    IF (edit_mode_in = G_TRUE)
    THEN
      -- delete the previous positions
      DELETE
        FROM mgmt_topo_page_obj_pos
        WHERE topo_page_type = topo_page_type_in
          AND page_instance_id = page_instance_id_in
          AND node_id IN
              (SELECT node_id  
               FROM TABLE(CAST(node_positions_in AS TOPO_NODE_POS_ARRAY)));
    END IF;

    -- save the new values
    IF (node_positions_in IS NOT NULL AND node_positions_in.COUNT > 0)
    THEN 
      INSERT INTO mgmt_topo_page_obj_pos
        (topo_page_type, page_instance_id, node_id, x, y)
      SELECT topo_page_type_in, page_instance_id_in, t.node_id, t.x, t.y
        FROM TABLE(CAST(node_positions_in AS TOPO_NODE_POS_ARRAY)) t;
    END IF;
  END update_node_positions;

  
  PROCEDURE clean_topology_tables 
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE
     )
  IS
  BEGIN
    DELETE FROM mgmt_topo_page_bg_image
    WHERE topo_page_type = topo_page_type_in 
      AND page_instance_id = page_instance_id_in;

    DELETE FROM mgmt_topo_page_pref
    WHERE topo_page_type = topo_page_type_in 
      AND page_instance_id = page_instance_id_in;

    DELETE FROM mgmt_topo_page_obj_pos
    WHERE topo_page_type = topo_page_type_in 
      AND page_instance_id = page_instance_id_in;
  END clean_topology_tables;

END em_topology;
/

show errors;

