Rem drv: <create type="pkgdefs" pos="ip/dashboard_service/dashboard_service_pkgdef.sql+"/>
Rem
Rem $Header: topology_pkgdef.sql 01-jul-2005.17:29:08 gsbhatia Exp $
Rem
Rem topology_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      topology_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    nigupta     01/06/05 - add update procedures 
Rem    nigupta     01/04/05 - nigupta_fixed_coords
Rem    nigupta     12/23/04 - Created
Rem

CREATE OR REPLACE PACKAGE em_topology AS 

  TYPE cursorType IS REF CURSOR;
 
  -- 
  -- PROCEDURE: get_background_image
  -- 
  -- PURPOSE:
  --   Returns the background image for a particular topoology graph.
  --
  -- IN Parameters:
  --   topo_page_type_in: mgmt_topo_bg_image.topo_page_type%TYPE The 
  --     for the type of topology page. For eg. for the System Topology page, 
  --     whose background image does not vary from instance to instance of of 
  --     the page, this parameter is sufficient to uniquely identify the 
  --     background image.
  --   page_instance_id_in: mgmt_topo_bg_image.page_instance_id%TYPE The 
  --     identifier for a page instance. For eg. System Topology page has 
  --     different background images for different systems, which are 
  --     identified by system's GUID. Here, page type and page instance id 
  --     together uniquely identify the background image.
  --
  -- OUT Parameters:
  --   image_data_out: cursorType A cursor containing:
  --     image_name: mgmt_topo_page_bg_image.image_name%TYPE the name of the 
  --       background image..
  --     image_data: mgmt_topo_page_bg_image.image_data%TYPE the data for the 
  --       background image
  PROCEDURE get_background_image
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE,
     image_data_out OUT cursorType);


  -- 
  -- PROCEDURE: get_graph_properties
  -- 
  -- PURPOSE:
  --   Returns the graph properties for a particular topology graph.
  --
  -- IN Parameters:
  --   topo_page_type_in: mgmt_topo_bg_image.topo_page_type%TYPE The 
  --     for the type of topology page. 
  --   page_instance_id_in: mgmt_topo_bg_image.page_instance_id%TYPE The 
  --     identifier for a page instance. 
  --
  -- OUT Parameters:
  --   graph_properties_out: cursorType A cursor with rows containing:
  --     preference_name: mgmt_topo_page_pref.preference_name%TYPE The name 
  --       of the graph property.
  --     preference_value: mgmt_topo_page_pref.preference_value%TYPE The value
  --       of the graph property.
  --
  PROCEDURE get_graph_properties
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE,
     graph_properties_out OUT cursorType);


  -- 
  -- PROCEDURE: get_node_positions
  -- 
  -- PURPOSE:
  --   Returns the node positions for a particular graph
  --
  -- IN Parameters:
  --   topo_page_type_in: mgmt_topo_bg_image.topo_page_type%TYPE The 
  --     for the type of topology page. 
  --   page_instance_id_in: mgmt_topo_bg_image.page_instance_id%TYPE The 
  --     identifier for a page instance. 
  --
  -- OUT Parameters:
  --   node_positions_out: cursorType A cursor with rows containing:
  --     node_id: mgmt_topo_page_obj_pos.node_id%TYPE The id for the node 
  --       instance. It is the business id.
  --     x: mgmt_topo_page_obj_pos.x%TYPE The x coordinate for this node.
  --     y: mgmt_topo_page_obj_pos.y%TYPE The y coordinate for this node.
  --
  PROCEDURE get_node_positions
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE,
     node_positions_out OUT cursorType);
    

  -- 
  -- PROCEDURE: update_background_image
  -- 
  -- PURPOSE:
  --   Updates the background image for a graph. 
  --
  -- IN Parameters:
  --   topo_page_type_in: mgmt_topo_bg_image.topo_page_type%TYPE The 
  --     for the type of topology page. 
  --   page_instance_id_in: mgmt_topo_bg_image.page_instance_id%TYPE The 
  --     identifier for a page instance. 
  --   edit_mode_in: INTEGER whether it is edit or create mode
  --   image_name_in: mgmt_topo_page_bg_image.image_name%TYPE The name of the 
  --     background image for the graph
  --   image_data_in: mgmt_topo_page_bg_image.image_data%TYPE The background 
  --     image for the graph 
  PROCEDURE update_background_image
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE,
     edit_mode_in IN INTEGER,
     image_name_in IN mgmt_topo_page_bg_image.image_name%TYPE,
     image_data_in IN mgmt_topo_page_bg_image.image_data%TYPE);

  -- 
  -- PROCEDURE: update_graph_properties 
  -- 
  -- PURPOSE:
  --   Updates the properties for a graph. 
  --
  -- IN Parameters:
  --   topo_page_type_in: mgmt_topo_bg_image.topo_page_type%TYPE The 
  --     for the type of topology page. 
  --   page_instance_id_in: mgmt_topo_bg_image.page_instance_id%TYPE The 
  --     identifier for a page instance. 
  --   edit_mode_in: INTEGER whether it is edit or create mode
  --   graph_properties_in SMP_EMD_NVPAIR_ARRAY name value pair of the graph
  --     properties
  PROCEDURE update_graph_properties
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE,
     edit_mode_in IN INTEGER,
     graph_properties_in IN SMP_EMD_NVPAIR_ARRAY);

  -- 
  -- PROCEDURE: update_node_positions 
  -- 
  -- PURPOSE:
  --   Updates the node positions for a graph. 
  --
  -- IN Parameters:
  --   topo_page_type_in: mgmt_topo_bg_image.topo_page_type%TYPE The 
  --     for the type of topology page. 
  --   page_instance_id_in: mgmt_topo_bg_image.page_instance_id%TYPE The 
  --     identifier for a page instance. 
  --   edit_mode_in: INTEGER whether it is edit or create mode
  --   node_positions_in: TOPO_NODE_POS_ARRAY containing the node ids and their
  --      coordinates
  PROCEDURE update_node_positions
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE,
     edit_mode_in IN INTEGER,
     node_positions_in IN TOPO_NODE_POS_ARRAY);

  --
  -- PROCEDURE: clean_topology_tables 
  --
  -- PURPOSE: 
  --   Cleans the topology tables by removing all data for the given
  --   topo_page_type and page_instance_id.
  --
  -- IN Parameters:
  --   topo_page_type_in: mgmt_topo_page_bg_image.topo_page_type%TYPE The type
  --     for the topology page
  --   page_instance_id_in: mgmt_topo_page_bg_image.page_instance_id%TYPE The
  --     identifier for a page instance
  --
  PROCEDURE clean_topology_tables 
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE);

END em_topology;

/ 

show errors;

