Rem drv: <create type="pkgdefs" pos="template/template_pkgdef.sql+"/>
Rem
Rem $Header: trace_log_pkgdef.sql 03-aug-2006.23:01:00 sthiruna Exp $
Rem
Rem trace_log_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      trace_log_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem     This package contains the code for implementing logging/tracing 
Rem     PL/SQL Code.
Rem 
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sthiruna    07/31/06 - Copying 10.2.0.3 Config Standard changes from
Rem                           EMCORE_MAIN_LINUX
Rem    niramach    02/28/06 - Add get_context_type function to get the current 
Rem                           context type. 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    jsadras     03/04/05 - purge procedure 
Rem    jsadras     02/26/04 - jsadras_trace_create 
Rem    jsadras     02/26/04 - emdw_log pkg spec 
Rem    jsadras     02/26/04 - Created
Rem

CREATE OR REPLACE PACKAGE emdw_log
AS
--Record Type To Hold context Information. 
  TYPE contextrec IS RECORD
   ( context_type_id    emdw_trace_config.context_type_id%tYPE,
     context_type       emdw_trace_config.context_type%TYPE,
     trace_level        emdw_trace_config.trace_level%TYPE,
     context_identifier emdw_trace_data.context_identifier%TYPE,
     oms_host           emdw_trace_data.oms_host%TYPE
   );

--Record To Hold Current context Information. 
  p_ctx_arr contextrec ;

--Default context type if not initialized 
  p_default_context_type CONSTANT VARCHAR2(10) := 'DEFAULT' ;

-- context type of the tracer application
  p_tracer_context_Type CONSTANT VARCHAR2(10) := 'TRACER' ;

-- Module name for the Trace/Log package 
   p_module  VARCHAR2(15) := 'TRACE MODULE' ;

-- Refresh_Context is enabled by default ,it is  disabled if 
-- session level trace is set using set session_trace..
   p_refresh_enabled BOOLEAN := TRUE ;

 --CONSTANTs for Log Levels 
  LOFF           CONSTANT NUMBER := 0 ;
  LERROR         CONSTANT NUMBER := 1;
  LWARN          CONSTANT NUMBER := 2;
  LINFO          CONSTANT NUMBER := 3 ;
  LDEBUG         CONSTANT NUMBER := 4 ;

--BOOLEANs used for checking if a Particular Level is being logged 
  p_is_error_set   BOOLEAN := FALSE ;
  p_is_info_set    BOOLEAN := FALSE ;
  p_is_debug_set   BOOLEAN := FALSE ;
  p_is_warn_set    BOOLEAN := FALSE ;
  p_is_tracing_set BOOLEAN := FALSE ;

--Purpose   : Initializes the context
--            Sets the Package Variables based on Table Values for the context_type
--Parameters: context Type
--            context Identifier
--            OMS Host
 PROCEDURE set_context(v_context_Type IN VARCHAR2:= p_default_context_type, 
		       v_context_Identifier IN VARCHAR2 := null,
                       v_oms_Host IN VARCHAR2 := null 
                      ) ;


--Purpose    : Refreshes Information for currently Initialized context Type
 PROCEDURE refresh_context ;

--Purpose    : Creates the Context Type and sets the trace level
--Parameters : Context_Type : Name for the context type to be created
--                            Context type cannot contain spaces
--                            Will be stored in upper case in DB
--                            if it exists then the trace level is updated   
--              Trace Level : Trace level to be set for the context type
 PROCEDURE create_context(v_context_type IN VARCHAR2,
                          v_trace_level  IN NUMBER := LOFF
                         ) ;

--Purpose    : Delete the context
--Parameters : context type to be deleted
--             All trace Data for the context type will be deleted
--             The context type will be deleted from emdw_trace_config 
 PROCEDURE delete_context(v_context_type IN VARCHAR2
                         ) ;

--Purpose    : Log a error message, if current tracelevel is error
--Parameters : LogText , Module
 PROCEDURE error (v_log_message IN VARCHAR2,
                  v_module      IN VARCHAR2
                 ) ;

--Purpose    : Log a Debug message,if current tracelevel in error,info,warn,debug
--Parameters : LogText , Module
PROCEDURE debug (v_log_message IN VARCHAR2,
                 v_module      IN VARCHAR2) ;

--Purpose    : Log a warn message,if current tracelevel in error or warn
--Parameters : LogText, Module
PROCEDURE warn (v_log_message IN VARCHAR2,
                v_module      IN VARCHAR2) ;

--Purpose    : Log a Info message,if current tracelevel in error,info,warn
--Parameters : LogText, Module
PROCEDURE info (v_log_message IN VARCHAR2,
                v_module      IN VARCHAR2) ;


--Purpose    : To Purge all trace records created before the given date.
--Parameters :Context Type: Specific context type to be deleted, if not specified then
--                          All context types are selected 
--            Purge Date: The date before which all records will be deleted.
--                        if not specified then all purge dates are selected
--            if only context type is specified, then all records for context type are purged
--            if only purge date is specified, then all records less than purge date are purged
--            if both are not specified then all records are purged
--            if both are specified then only records for the context type before the purge date
--            are purged.
  PROCEDURE purge(v_context_Type IN VARCHAR2 := null,
                  v_purge_date   IN DATE := sysdate+1,
	          v_batch_size   IN NUMBER := 100000 ) ;
--
--Purpose  :  Background purge procedure called by Purge policy
--
  PROCEDURE purge(p_purge_params IN  OUT NOCOPY MGMT_PURGE_CALLBACK_PARAMS) ;
--
--Purpose    : To set the trace level for a context type
--Parameters : context Type (defaulted to ALL contexts), trace_level ( defaulted to 0)
  PROCEDURE  set_trace_level(v_context_type IN VARCHAR2 := NULL,
                             v_trace_level  IN NUMBER := LOFF
                            ) ;

--Purpose    : To set trace level for current context in current session only,
--             other sessions will continue to use the trace level defined for the
--             context type. 
--             emdw_trace_config.trace_level is ignored for current session
--             until the next set_session_trace_level call or set_context call.
--Parameters : Trace Level
PROCEDURE set_session_trace_level(v_trace_level in NUMBER) ;

--Purpose   : Returns the current context type.
FUNCTION get_context_type RETURN VARCHAR2;      

END ;
/
show errors
