Rem drv: <create type="views" pos="sdk/sdk_views.sql+"/>
Rem
Rem $Header: trace_views.sql 01-jul-2005.18:43:50 gsbhatia Exp $
Rem
Rem trace_views.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      trace_views.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    jsadras     02/26/04 - jsadras_trace_create 
Rem    jsadras     02/26/04 - TraceViews 
Rem    jsadras     02/26/04 - Created
Rem
Rem
Rem PURPOSE
Rem The  emdw$trace_data view joins emdw_trace_config and emdw_trace_data
Rem  to present all trace information in one view
Rem COLUMNS
Rem      See EMDW_TRACE_CONFIG and EMDW_TRACE_DATA
Rem      Additional Columns
Rem        log_level_desc : Derived column to display the description
Rem 

create or replace view emdw$trace_data
as
select  etd.Context_type_Id,
        etc.Context_type,
        etd.log_level,
        decode(etd.log_Level,1,'ERROR',
                            2,'WARNING',
                            3,'INFO',
                            4,'DEBUG','UNKNOWN') log_Level_Desc,
       etd.log_timestamp,
       etd.log_message,
       etd.module,
       etd.oms_host,
       etd.context_identifier
from emdw_trace_config etc,
     emdw_trace_data   etd
where etc.context_type_id = etd.context_type_id ;
