Rem
Rem $Header: user_login_assistant_pkgdef.sql 23-mar-2004.03:44:07 skini Exp $
Rem
Rem user_login_assistant_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2004, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      user_login_assistant_pkgdef.sql - The login assistant helper package
Rem
Rem    DESCRIPTION
Rem      Allows login assistants to be registered, deregistered
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED (MM/DD/YY)
Rem    skini     03/23/04 - Fix ARU authentication 
Rem    rpinnama  05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama  05/15/02 - Restructured.
Rem    skini     03/10/02 - skini_add_target_command
Rem    skini     03/04/02 - Created
Rem

CREATE OR REPLACE PACKAGE MGMT_LOGIN_ASSISTANT AS

ARU_LOC_PARAM constant VARCHAR2(20) := 'aru_location';

ARU_USERNAME_PARAM constant VARCHAR2(20) := 'ARU_USERNAME';
ARU_PASSWORD_PARAM constant VARCHAR2(20) := 'ARU_PASSWORD';

ARU_LOGIN_ASSISTANT constant VARCHAR2(20) := 'ARU_LOGIN_ASSISTANT';
REP_LOGIN_ASSISTANT constant VARCHAR2(20) := 'REP_LOGIN_ASSISTANT';

-- Register a new login assistant. The new assistant will be
-- registered at the end of the existing list.
PROCEDURE register_login_assistant(p_name IN VARCHAR2,
                                   p_classname IN VARCHAR2);

-- Specify which login assistants are enabled, and in what order.
-- p_names is an array of login assistant names. The assistants
-- will be tried in the same order as specified in the array.
-- Any assistants not in the array will be disabled.
--
PROCEDURE login_assistant_order(p_names IN SMP_EMD_STRING_ARRAY);

-- Configure ARU authentication. Required parameters are
-- the host, port and sid of the ARU database, and the username
-- and password required to access ARU. 
PROCEDURE configure_aru_authentication(p_aru_host VARCHAR2,
                                       p_aru_port NUMBER,
                                       p_aru_sid VARCHAR2,
                                       p_aru_username VARCHAR2,
                                       p_aru_password VARCHAR2);

-- Get ARU configuration information. The connect string is a string
-- of the form aruhost:port:sid. A NO_DATA_FOUND exception will be
-- thrown if ARU is not configured.
PROCEDURE get_aru_parameters(p_aru_connect_string_out OUT VARCHAR2,
                             p_aru_username_out OUT VARCHAR2,
                             p_aru_password_out OUT VARCHAR2);

END MGMT_LOGIN_ASSISTANT;
/

show errors;
