Rem drv: <create type="procs"/>
Rem
Rem $Header: user_model_procs.sql 05-jul-2005.06:30:14 kmanicka Exp $
Rem
Rem user_model_procs.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      user_model_procs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    kmanicka    07/05/05 - add param emkey
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Created
Rem

-- set the emkey as so that the SET_VIEW_USER_CONTEXT
-- can decrypt the view_user_pwd
-- remove the emkey from session after SET_VIEW_USER_CONTEXT
-- as the view user should not have 
-- access to encryption functions
 
CREATE OR REPLACE PROCEDURE SETEMVIEWUSERCONTEXT(em_client_in IN VARCHAR2,
                                                 op_in        IN INTEGER,
                                                 view_user    IN VARCHAR2,
                                                 view_pwd     IN VARCHAR2,
                                                 time_coff    IN VARCHAR2 DEFAULT NULL)
IS
BEGIN
 
 IF time_coff IS NOT NULL THEN
   MGMT_TIME_SYNC.setTimeCoff(time_coff);
 END IF;

 MGMT_VIEW_PRIV.SET_VIEW_USER_CONTEXT(em_client_in, op_in, view_user, view_pwd);
 
 IF time_coff IS NOT NULL THEN
   MGMT_TIME_SYNC.setTimeCoffNoCheck(null);
 END IF;

EXCEPTION 
  WHEN OTHERS THEN
       IF time_coff IS NOT NULL THEN
          MGMT_TIME_SYNC.setTimeCoffNoCheck(null);
       END IF;
       RAISE;
END;
/
show errors;


