Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/user_model/user_view_pkgdef.sql /st_emcore_10.2.0.4.2db11.2/1 2009/06/17 22:17:24 nmathuri Exp $
Rem
Rem user_view_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      user_view_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nmathuri    06/12/09 - Fix the bug 8564295
Rem    kmanicka    08/25/05 - add init_view_user_out_of_box
Rem    jsadras     06/01/05 - add api to change view user passwd 
Rem    rpinnama    02/27/03 - Remove password
Rem    rpinnama    01/21/03 - Provide an API to reset view user's password
Rem    dmshah      11/11/02 - Generating mgmt_view password based on input password
Rem    dmshah      10/29/02 - Ensuring mgmt_view pwd is always valid
Rem    dmshah      10/29/02 - Setting the size of the pwd constant correctly
Rem    dmshah      10/28/02 - Fixing bug 2480080.Hardcoded view pwd
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Restructured.
Rem    mbhoopat    04/18/02 - Fix bug 2330078..
Rem    rpinnama    04/16/02 - Add MGMT_VIEW user to created users.
Rem    mbhoopat    04/12/02 - mbhoopat_view_user_support
Rem    mbhoopat    04/09/02 - Created
Rem

CREATE OR REPLACE PACKAGE MGMT_VIEW_PRIV
AS

  MGMT_VIEW_USER CONSTANT VARCHAR2(256) := 'MGMT_VIEW';

  MGMT_VIEW_USER_KEY CONSTANT VARCHAR2(256) := 'MGMT_VIEW_USER';
  MGMT_VIEW_PWD_KEY CONSTANT VARCHAR2(256) := 'MGMT_VIEW_USER_PWD';
  G_SYS_USER CONSTANT VARCHAR2(256) := 'SYS';

--
-- PURPOSE
--
--  Sets the global application context for EM, calculates the security
--  predicate and stores it in the EM global context
--
-- PARAMETERS
--  
--  EM_CLIENT_IN - the name of the EMD user
--
--  OP_IN - the operation to perform
--
--   MGMT_USER.OP_SET_IDENTIFIER: Set the EM client name for this session
--      to em_client_in, creating the security predicate and target list
--      if necessary
--   MGMT_USER.OP_RECREATE_CONTEXT: Recompute the predicate function
--      for the specified user
--   MGMT_USER.OP_CLEAR_IDENTIFIER: Clear the EM client name for this 
--      session; no new identifier is set. The em_client_in value is 
--      ignored in this case.
--   MGMT_USER.OP_CLEAR_CONTEXT: Clear the predicate and target list for
--      em_client_in
--   MGMT_USER.OP_CLEAR_CONTEXTS: Clear all predicates and target lists for
--      all EM clients
--   MGMT_USER.OP_LOGOFF: Clear the EM_USERNAME from the user context and clear
--      all information from the global context if the session is the only 
--      session using the information
--
  PROCEDURE SET_VIEW_USER_CONTEXT(em_client_in IN VARCHAR2,
                                  op_in        IN INTEGER,
                                  view_user    IN VARCHAR2,
                                  view_pwd     IN VARCHAR2);

  PROCEDURE GET_VIEW_USER_CREDS(view_user    OUT VARCHAR2,
                                view_pwd     OUT VARCHAR2);

  PROCEDURE GET_VIEW_USER(view_user    OUT VARCHAR2);

  PROCEDURE SET_VIEW_USER_CREDS(v_secret IN VARCHAR2);
--
-- PURPOSE
--
-- To get a Random password from a given seed
--
  FUNCTION random_password(seed_in IN VARCHAR2) RETURN VARCHAR2 ;
--
-- PURPOSE
--
-- To change the password for mgmt_view user
--
-- PARAMETERS
--
-- view_pwd: The new password to be set
--
-- Exceptions:
--  MGMT_GLOBAL.INSUFFICIENT_PRIVS :Only REPOSITORY OWNER can change password
--  MGMT_GLOBAL.MODIFY_FAILED_ERR  :Changing password failed for some reason
--
--
-- Note: ** THERE IS A IMPLICIT COMMIT IN THIS PROCEDURE DUE TO
--          ALTER USER
--
  PROCEDURE change_view_user_password(view_pwd IN VARCHAR2) ;
  
-- PURPOSE
--
-- Called during out of box
-- It replaces the View user password in the seed db to a new random password.
--
-- PARAMETERS
--
-- Exceptions:
--  MGMT_GLOBAL.INSUFFICIENT_PRIVS :Only REPOSITORY OWNER can change password
--  MGMT_GLOBAL.MODIFY_FAILED_ERR  :Changing password failed for some reason
--
--
-- Note: ** THERE IS A IMPLICIT COMMIT IN THIS PROCEDURE DUE TO
--          ALTER USER
--
  PROCEDURE init_view_user_out_of_box;
  

END MGMT_VIEW_PRIV;
/
show errors;


