Rem
Rem $Header: util_lock_pkgdef.sql 21-apr-2005.22:33:33 jsadras Exp $
Rem
Rem util_lock_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      util_lock_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     04/21/05 - target type lock 
Rem    skini       03/21/05 - Add blackout_name_lock 
Rem    itarashc    10/04/04 - add release_on_commit 
Rem    kmanicka    08/17/04 - added JOB_NAME_LOCK bug-3489013 
Rem    jsadras     03/24/04 - jsadras_bug-3468233 
Rem    jsadras     03/18/04 - 
Rem    jsadras     03/17/04 - New Package to provide locking functionality 
Rem    jsadras     03/11/04 - Created
Rem

CREATE OR REPLACE PACKAGE mgmt_lock_util AS
-- Possible Lock Modes, Currently all are not supported
-- Only share and exclusive mode are supported
   NULL_MODE                 CONSTANT NUMBER := dbms_lock.nl_mode ;
   ROW_SHARE_MODE            CONSTANT NUMBER := dbms_lock.ss_mode ;
   ROW_EXCLUSIVE_MODE        CONSTANT NUMBER := dbms_lock.sx_mode ;
   SHARE_MODE                CONSTANT NUMBER := dbms_lock.s_mode ;
   SHARE_ROW_EXCLUSIVE_MODE  CONSTANT NUMBER := dbms_lock.ssx_mode ;
   EXCLUSIVE_MODE            CONSTANT NUMBER := dbms_lock.x_mode ;

   DEFAULT_TIMEOUT_SECS   CONSTANT number :=  60 ;
   
   LOCK_EXPIRATION_SECS CONSTANT number := 6000 ;

-- Common Locks, Just here so that it gets documented
-- We can have it defined in the package also.
  DROP_USER_LOCK CONSTANT VARCHAR2(30) := 'DROP_EM_USER' ;
  JOB_NAME_LOCK CONSTANT VARCHAR2(30) := 'JOB_NAME';
  BLACKOUT_NAME_LOCK CONSTANT VARCHAR2(30) := 'BLACKOUT_NAME';
  BLACKOUT_GUID_LOCK CONSTANT VARCHAR2(30) := 'BLACKOUT_GUID';
  -- Used by the target extensions system to serialize target type deployment
  EM_TE_LOCK CONSTANT VARCHAR2(30) := 'EM_TE_NAME' ;
  TARGET_TYPE_LOCK    VARCHAR2(30) := 'TARGET_TYPE' ;
  -- Defined here so that is the lock handle size is increased
  -- this is the only place to change
  SUBTYPE LOCK_HANDLE_TYPE IS VARCHAR2(128) ;
--Purpose
--Get a exclusive lock on the lock type and lock value
-- Parameters
--         Lock Type  ( Examples: DROP_USER_LOCK, TARGET_LOCK)
--         Lock Value ( Examples: for DROP_USER_LOCK it might be name of user,
--                                for target lock, it might be the target name)
--         Exception : The Custom exception to be raised if the lock cannot
--                      be acquired, if not between --2000 and -20999 then
--                      00054 - Resource Busy exception is raised
--
   FUNCTION get_exclusive_lock(p_lock_type     IN VARCHAR2,
                               p_lock_value    IN VARCHAR2,
                               p_timeout_secs  IN NUMBER   := DEFAULT_TIMEOUT_SECS,
                               p_exception_id  IN NUMBER   := NULL,
                               p_exception_msg IN VARCHAR2 := NULL,
                               p_release_on_commit IN  BOOLEAN := TRUE) 
   RETURN VARCHAR2;
--
-- Purpose
-- Get a share lock 
-- Parameters : Same as for exclusive lock
   FUNCTION     get_share_lock(p_lock_type     IN VARCHAR2,
                               p_lock_value    IN VARCHAR2,
                               p_timeout_secs  IN NUMBER   := DEFAULT_TIMEOUT_SECS,
                               p_exception_id  IN NUMBER   := NULL,
                               p_exception_msg IN VARCHAR2 := NULL,
                               p_release_on_commit IN  BOOLEAN := TRUE)
  RETURN VARCHAR2 ;
--
-- Purpose
-- Get a lock with the specified mode
-- Parameters : Same as above, except for lock_mode
--             lock_mode: between 1 and 6,  See starting for lock modes
--
   FUNCTION get_lock(p_lock_type     IN VARCHAR2,
                     p_lock_value    IN VARCHAR2,
                     p_lock_mode     IN NUMBER, 
                     p_timeout_secs  IN NUMBER   := DEFAULT_TIMEOUT_SECS,
                     p_exception_id  IN NUMBER   := NULL,
                     p_exception_msg IN VARCHAR2 := NULL,
                     p_release_on_commit IN  BOOLEAN := TRUE)
    RETURN VARCHAR2 ;

-- Release the lock
   FUNCTION  release_lock(p_lock_handle IN VARCHAR2) RETURN NUMBER ;

END ;
/
show err

