Rem drv: <create type="post_creation" pos="audit/audit_post_creation.sql+"/>
Rem
Rem $Header: website_post_creation.sql 23-jul-2007.12:37:51 shnavane Exp $
Rem
Rem website_post_creation.sql
Rem
Rem Copyright (c) 2005, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      website_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    shnavane    07/23/07 - Fix bug #5970781
Rem    shnavane    07/23/07 - Backport shnavane_bug-5970781 from main
Rem    yxie        11/21/06 - XbranchMerge yxie_bug5527422 from main
Rem    yxie        11/09/06 - XbranchMerge yxie_bug5567723 from main
Rem    yxie        11/21/06 - XbranchMerge yxie_bug5527422 from main
Rem    yxie        11/09/06 - XbranchMerge yxie_bug5567723 from main
Rem    yxie        07/11/05 - change 102010 to 102020
Rem    gsbhatia    07/03/05 - New repmgr header impl 
Rem    yxie        06/20/05 - yxie_bug-4390544
Rem    yxie        05/25/05 - Created
Rem

-- Add new supportsEUM and supportsE2E properties
BEGIN

  MGMT_TARGET.add_target_type_property(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE,
                                     MGMT_WEBSITE_TARGET.SUPPORTS_EUM_PROP, 1);
  MGMT_TARGET.add_target_type_property(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE,
                                     MGMT_WEBSITE_TARGET.SUPPORTS_E2E_PROP, 1);

  mgmt_log.register_logging_module ( MGMT_WEBSITE_TARGET.MODULE_NAME,
                                     'Website EUME2E Association Callbacks');
END;
/
show errors;

-- Register callbacks
BEGIN

  mgmt_assoc.add_assoc_deletion_callback(
    'MGMT_WEBSITE_TARGET.key_del_callback',
    MGMT_ASSOC.ASSOC_DEF_DEPENDS_ON,
    MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE);

  mgmt_assoc.add_assoc_deletion_callback(
    'MGMT_WEBSITE_TARGET.cluster_mem_del_callback',
    MGMT_ASSOC.ASSOC_DEF_CONTAINS,
    'oc4j_cluster');

  mgmt_assoc.add_assoc_addition_callback(
    'MGMT_WEBSITE_TARGET.cluster_mem_add_callback',
    MGMT_ASSOC.ASSOC_DEF_CONTAINS,
    'oc4j_cluster');

  mgmt_assoc.add_assoc_deletion_callback(
    'MGMT_WEBSITE_TARGET.cluster_mem_del_callback',
    MGMT_ASSOC.ASSOC_DEF_CONTAINS,
    'oracle_apache_cluster');

  mgmt_assoc.add_assoc_addition_callback(
    'MGMT_WEBSITE_TARGET.cluster_mem_add_callback',
    MGMT_ASSOC.ASSOC_DEF_CONTAINS,
    'oracle_apache_cluster');

  mgmt_assoc.add_assoc_deletion_callback(
    'MGMT_WEBSITE_TARGET.cluster_mem_del_callback',
    MGMT_ASSOC.ASSOC_DEF_CONTAINS,
    MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE);

  mgmt_assoc.add_assoc_addition_callback(
    'MGMT_WEBSITE_TARGET.cluster_mem_add_callback',
    MGMT_ASSOC.ASSOC_DEF_CONTAINS,
    MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE);

  em_target.add_tgt_pre_deletion_callback('MGMT_WEBSITE_TARGET.del_key_cluster_callback', ' ', 'oc4j_cluster', 0);

  em_target.add_tgt_pre_deletion_callback('MGMT_WEBSITE_TARGET.del_key_cluster_callback', ' ', 'oracle_apache_cluster', 0);

  em_target.add_tgt_pre_deletion_callback('MGMT_WEBSITE_TARGET.del_key_cluster_callback', ' ', MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE, 0);

END;
/
show error;
@&EM_SQL_ROOT/core/10.2.0.4/website/website_post_creation.sql

BEGIN

DELETE FROM EUME2E_ASSOCS_LOOKUP;

INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES(MGMT_GLOBAL.G_WEBCACHE_TARGET_TYPE, MGMT_WEBSITE_TARGET.supports_eum_on_guid, 0, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES(MGMT_GLOBAL.G_HTTP_SERVER_TARGET_TYPE, MGMT_WEBSITE_TARGET.supports_eum_on_guid, 0, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES('generic_apache', MGMT_WEBSITE_TARGET.supports_eum_on_guid, 0, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES('oracle_apache_cluster', MGMT_WEBSITE_TARGET.supports_eum_on_guid, 1, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES(MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE, MGMT_WEBSITE_TARGET.supports_eum_on_guid, 1, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES(MGMT_GLOBAL.G_OC4J_TARGET_TYPE, MGMT_WEBSITE_TARGET.supports_e2e_on_guid, 0, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES('oc4j_cluster', MGMT_WEBSITE_TARGET.supports_e2e_on_guid, 1, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES(MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE, MGMT_WEBSITE_TARGET.supports_e2e_on_guid, 1, 0);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID, IS_GROUP, EXPAND_GROUP) VALUES('oracle_forms', MGMT_WEBSITE_TARGET.supports_forms_on_guid, 0, 0);


END;
/
show errors;
