Rem
Rem $Header: website_target_pkgdef.sql 25-jul-2007.05:53:45 shnavane Exp $
Rem
Rem website_target_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      website_target_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED (MM/DD/YY)
Rem    shnavane  07/23/07 - Fix bug #5970781
Rem    yxie      11/21/06 - XbranchMerge yxie_bug5527422 from main
Rem    yxie      11/09/06 - XbranchMerge yxie_bug5567723 from main
Rem    yxie      05/27/05 - fix bug 4390544
Rem    rmarripa  04/02/03 - change getWebsite signature
Rem    rmarripa  03/19/03 - .
Rem    rmarripa  03/19/03 - change getEMDHostAndURLs
Rem    rmarripa  06/24/02 - add err code and description
Rem    rmarripa  06/14/02 - remove rep url and region thresholds
Rem    rpinnama  05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama  05/15/02 - Restructured.
Rem    dcawley   03/14/02 - New Collection APIs.
Rem    edemembe  01/11/02 - Putting check around metric definition.
Rem    rmarripa  01/08/02 - Create target_guid to insert into targets table.
Rem    edemembe  01/08/02 - Metrics are now target independent
Rem    edemembe  12/27/01 - Removing target name/type and metric name/column references
Rem    rmarripa  12/19/01 - Add procedure to get the emdHost and emdURL for selected targets.
Rem    rmarripa  12/14/01 - Add a procedure to get URL base.
Rem    rmarripa  11/06/01 - To add numofoccurences to MGMT_THRESHOLDS object.
Rem    rmarripa  10/30/01 - To filter out website target types in available targets.
Rem    rmarripa  10/23/01 - To change the store metric values to 'Y'/'N'.
Rem    rmarripa  09/25/01 - To change the metric name to Region Latency,.
Rem    rmarripa  09/17/01 - updateWebsite:Do not throw an exception for empty member target list in edit mode
Rem    asawant   09/07/01 - Time to timezone conversion.
Rem    lgloyd    09/06/01 - store emd url with target
Rem    asawant   08/28/01 - Fixing deleteCompTarget and checkForDeletion
Rem    asawant   08/24/01 - Updating with API changes and bug fixes.
Rem    lgloyd    08/16/01 - Creation.
Rem

CREATE OR REPLACE PACKAGE mgmt_website_target AS

MODULE_NAME constant VARCHAR2(20) := 'MGMT_WEBSITE_TARGET';

-- Association Types
ASSOC_TYPE_SUPPORTS_EUM_ON   CONSTANT VARCHAR2(22) := 'supports_eum_on';
ASSOC_TYPE_SUPPORTS_E2E_ON   CONSTANT VARCHAR2(22) := 'supports_e2e_on';
ASSOC_TYPE_SUPPORTS_FORMS_ON CONSTANT VARCHAR2(22) := 'supports_forms_on';

-- Association Defs
ASSOC_DEF_SUPPORTS_EUM_ON    CONSTANT VARCHAR2(22) := 'supports_eum_on';
ASSOC_DEF_SUPPORTS_E2E_ON    CONSTANT VARCHAR2(22) := 'supports_e2e_on';
ASSOC_DEF_SUPPORTS_FORMS_ON  CONSTANT VARCHAR2(22) := 'supports_forms_on';

-- Public variable declarations
supports_eum_on_guid         mgmt_target_assoc_defs.assoc_guid%TYPE;
supports_e2e_on_guid         mgmt_target_assoc_defs.assoc_guid%TYPE;
supports_forms_on_guid       mgmt_target_assoc_defs.assoc_guid%TYPE;

-- supports eum and e2e properties
SUPPORTS_EUM_PROP            CONSTANT VARCHAR2(22) := 'supportsEUM';
SUPPORTS_E2E_PROP            CONSTANT VARCHAR2(22) := 'supportsE2E';

-- PURPOSE
--   Procedure to update/create a website target
--
-- PARAMETERS
--
-- NOTES

PROCEDURE addWebsite
(
  v_target_name        IN  VARCHAR2,
  v_target_type        IN  VARCHAR2,
  v_monitoring_host    IN  VARCHAR2,
  v_monitoring_url     IN  VARCHAR2,
  v_member_targets     IN  SMP_EMD_NVPAIR_ARRAY,
  v_properties         IN  MGMT_TARGET_PROPERTY_LIST,
  v_result             OUT INTEGER,
  v_err_desc           OUT VARCHAR2
);

PROCEDURE getWebsiteData
(
  v_target_name        IN  VARCHAR2,
  v_target_type        IN  VARCHAR2,
  v_agent_tgt_name     OUT VARCHAR2,
  v_all_target_types   OUT SMP_EMD_NVPAIR_ARRAY,
  v_basic_info         OUT MGMT_TARGET.CURSOR_TYPE,
  v_properties         OUT MGMT_TARGET.CURSOR_TYPE,
  v_member_targets     OUT MGMT_TARGET.CURSOR_TYPE
);

PROCEDURE getURLBase
(
  v_target_guid        IN  VARCHAR2,
  v_urlbase            OUT VARCHAR2
); 
  
PROCEDURE getEMDHostAndURLs
(
  v_tgt_nametype_arr   IN  SMP_EMD_NVPAIR_ARRAY,
  v_emdHostURLArr      OUT SMP_EMD_NVPAIR_ARRAY
);

PROCEDURE testPack;
PROCEDURE testGetHostEMDURL;

--
-- PROCEDURE: key_del_callback
-- PURPOSE:
--   callback when a depends_on association between
--   a key component and website is deleted
--
PROCEDURE key_del_callback(p_assoc_def_name IN VARCHAR2,
                           p_source_target_name IN VARCHAR2,
                           p_source_target_type IN VARCHAR2,
                           p_assoc_target_name IN VARCHAR2,
                           p_assoc_target_type IN VARCHAR2,
                           p_scope_target_name IN VARCHAR2,
                           p_scope_target_type IN VARCHAR2);

--
-- PROCEDURE: cluster_mem_del_callback
-- PURPOSE:
--   callback when a contains association between
--   a cluster key component of a Web Application and 
--   the cluster member is deleted
--
PROCEDURE cluster_mem_del_callback(p_assoc_def_name IN VARCHAR2,
                                   p_source_target_name IN VARCHAR2,
                                   p_source_target_type IN VARCHAR2,
                                   p_assoc_target_name IN VARCHAR2,
                                   p_assoc_target_type IN VARCHAR2,
                                   p_scope_target_name IN VARCHAR2,
                                   p_scope_target_type IN VARCHAR2);

--
-- PROCEDURE: cluster_mem_add_callback
-- PURPOSE:
--   callback when a contains association between
--   a cluster key component of a Web Application and 
--   the cluster member is created
--
PROCEDURE cluster_mem_add_callback(p_assoc_def_name IN VARCHAR2,
                                   p_source_target_name IN VARCHAR2,
                                   p_source_target_type IN VARCHAR2,
                                   p_assoc_target_name IN VARCHAR2,
                                   p_assoc_target_type IN VARCHAR2,
                                   p_scope_target_name IN VARCHAR2,
                                   p_scope_target_type IN VARCHAR2);


--
-- PROCEDURE: del_key_cluster_callback
-- PURPOSE:
--   callback when a oc4j_cluster, oracle_apache_cluster
--   or webcache_cluster is deleted (right before the
--   cluster target is deleted)
--
PROCEDURE del_key_cluster_callback(p_cluster_name IN VARCHAR2,
                                   p_cluster_type IN VARCHAR2,
                                   p_cluster_guid IN RAW);



--
-- PROCEDURE: apps_key_del_callback
-- PURPOSE:
--   callback when a depends_on association between
--   a key component and website is deleted
--
PROCEDURE apps_key_del_callback(p_assoc_def_name IN VARCHAR2,
                                p_source_target_name IN VARCHAR2,
                                p_source_target_type IN VARCHAR2,
                                p_assoc_target_name IN VARCHAR2,
                                p_assoc_target_type IN VARCHAR2,
                                p_scope_target_name IN VARCHAR2,
                                p_scope_target_type IN VARCHAR2);

--
-- PROCEDURE: apps_cluster_mem_del_callback
-- PURPOSE:
--   callback when a contains association between
--   a cluster key component of a Web Application and 
--   the cluster member is deleted
--
PROCEDURE apps_cluster_mem_del_callback(p_assoc_def_name IN VARCHAR2,
                                        p_source_target_name IN VARCHAR2,
                                        p_source_target_type IN VARCHAR2,
                                        p_assoc_target_name IN VARCHAR2,
                                        p_assoc_target_type IN VARCHAR2,
                                        p_scope_target_name IN VARCHAR2,
                                        p_scope_target_type IN VARCHAR2);

--
-- PROCEDURE: apps_cluster_mem_add_callback
-- PURPOSE:
--   callback when a contains association between
--   a cluster key component of a Web Application and 
--   the cluster member is created
--
PROCEDURE apps_cluster_mem_add_callback(p_assoc_def_name IN VARCHAR2,
                                        p_source_target_name IN VARCHAR2,
                                        p_source_target_type IN VARCHAR2,
                                        p_assoc_target_name IN VARCHAR2,
                                        p_assoc_target_type IN VARCHAR2,
                                        p_scope_target_name IN VARCHAR2,
                                        p_scope_target_type IN VARCHAR2);


-- Callback method which removes the EM page customization for a website
--
--
PROCEDURE WEBSITE_EMCUSTOM_DEL_CALLBACK( p_target_name IN VARCHAR2,
                                                 p_target_type VARCHAR2,
                                                 p_target_guid RAW );

-- PROCEDURE: DEL_OLD_EUME2E_ASSOCS
--
-- PURPOSE
--   Remove old EUM/E2E associations
-- PARAMETERS
--    p_target_name : target name
--    p_target_type : type
--    p_assoc_def_name : supports_eum_on or supports_e2e_on association
--
PROCEDURE DEL_OLD_EUME2E_ASSOCS(p_target_name IN VARCHAR2,
                                p_target_type IN VARCHAR2,
                                p_assoc_def_name IN VARCHAR2);

-- PROCEDURE: ADD_EUME2E_ASSOCIATIONS
--
-- PURPOSE
--   Creates EUM/E2E associations
-- PARAMETERS
--    p_target_name    : target name
--    p_target_type    : type
--    p_assoc_def_name : supports_eum_on or supports_e2e_on association
--
PROCEDURE ADD_EUME2E_ASSOCIATIONS(p_target_name    IN VARCHAR2,
                                  p_target_type    IN VARCHAR2,
                                  p_assoc_def_name IN VARCHAR2);

--
-- FUNCTION: IS_EUME2E_SUPPORTED
-- PURPOSE:
--   Determines if the specified service type supports EUM/E2E associations
-- IN PARAMETERS
--   p_service_type:   Service type.
--   p_assoc_def_name: supports_eum_on or supports_e2e_on association
-- RETURN
--    TRUE if yes; FALSE otherwise
--
FUNCTION IS_EUME2E_SUPPORTED(p_service_type IN VARCHAR2,
                             p_assoc_def_name IN VARCHAR2)
                    RETURN BOOLEAN;

--
-- FUNCTION: supports_eume2e_assoc
-- PURPOSE:
--   check if a target type supports eum/e2e association
--   returns TRUE if it does, returns FALSE otherwise
--
FUNCTION SUPPORTS_EUME2E_ASSOC(p_target_type IN VARCHAR2,
                               p_assoc_def_name IN VARCHAR2)
                    RETURN BOOLEAN;


--
-- FUNCTION: IS_GROUP
-- PURPOSE:
--   Determines if the specified target type is a group, cluster, or aggregate
-- IN PARAMETERS
--   p_target_type: type of the target
-- RETURN
--    TRUE if yes; FALSE otherwise
--
FUNCTION IS_GROUP(p_target_type IN VARCHAR2)
                    RETURN BOOLEAN;


--
-- FUNCTION: IS_DIRECT_KEY
-- PURPOSE:
--   check if the associate target is a direct key component
--   of the source target
-- 
FUNCTION IS_DIRECT_KEY(p_source_target_guid IN RAW,
                       p_assoc_target_guid IN RAW)
                    RETURN BOOLEAN;


--
-- FUNCTION: IS_KEY_MEMBER
-- PURPOSE:
--   check if the associate target is a member of a direct key component
--   of the source target
-- 
FUNCTION IS_KEY_MEMBER(p_source_target_guid IN RAW,
                       p_assoc_target_guid IN RAW)
                    RETURN BOOLEAN;


--
-- FUNCTION: EUME2E_ASSOC_EXISTS
-- PURPOSE:
--   check if the associate target is already associated with
--   the source target the eum/e2e association
-- 
FUNCTION EUME2E_ASSOC_EXISTS(p_source_target_guid IN RAW,
                             p_assoc_target_guid IN RAW,
                             p_assoc_guid IN RAW)
                    RETURN BOOLEAN;

--
-- FUNCTION: other_eume2e_assoc
-- PURPOSE:
--   check if a target is associated with the same website
--   in the same eum/e2e association in another way
--   Example: If the associated target as a member of a key
--            cluster is associated with the website with eum 
--            association, check if it is also a key component
--            of the website itself which may also associate 
--            it with the website with eum association. In this
--            case removing either the member of the cluster
--            or key component association should not remove
--            the eum association
--          
-- 
FUNCTION OTHER_EUME2E_ASSOC(p_assoc_target_name IN VARCHAR2, 
                            p_assoc_target_type IN VARCHAR2, 
                            p_src_target_name IN VARCHAR2, 
                            p_src_target_type IN VARCHAR2,
                            p_assoc_def_name IN VARCHAR2, 
                            p_is_cluster IN NUMBER)
                    RETURN BOOLEAN;

END mgmt_website_target;
/
show errors;

