Rem drv: <migrate type="pre_data_upgrade" version="99.9.9.9" pos="-"/>
Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/upgrade/pre_data_upgrade.sql st_emdw_lsatyapr_bug-7594101/1 2008/11/27 00:28:18 lsatyapr Exp $
Rem
Rem pre_data_upgrade.sql
Rem
Rem Copyright (c) 2005, 2008, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      pre_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    lsatyapr    11/27/08 - Bug7594101 Fix 11.1.0.7 upgrade
Rem    lsatyapr    07/17/08 - Spl check for 11.1.0.6 upgrade
Rem    lsatyapr    07/10/08 - Bug7214155 Avoid jobtype upg in non-central mode
Rem    chyu        11/17/06 - adding the stat analyzer bug 5666424
Rem    chyu        11/17/06 - modifying the version
Rem    chyu        12/12/05 - Created
Rem

-- We have to register metadata here so that all the metrics are available
-- we should always take it from the latest
@&EM_SQL_ROOT/core/latest/targetTypes_sql/core_targetTypes.sql

-- Do the object analyze here before all the data_upgrade scripts
DECLARE
BEGIN
  EMD_MAINTENANCE.analyze_objects_without_stats('&&EM_REPOS_USER');
END;
/

-- set the flag that determines whether new job type registration reschedules
-- the current executions to pick the new job type appropriately. This must be
-- done before the job types are registered.
-- NOTE: This needs to be done only if upgrading from 11.1.0.6 DB
DECLARE
l_version MGMT_VERSIONS.version%TYPE;
BEGIN
  BEGIN
    SELECT version INTO l_version
    FROM   MGMT_VERSIONS
    WHERE  component_name='DB';

    -- EM key not available by default on DB11 onwards, so check whether to
    -- reschedule jobs only for versions later than 11
    -- (Reinforce character-based check using TO_CHAR)
    IF TO_NUMBER(SUBSTR(l_version, 1, 2)) >= 11 THEN
      EMD_MAINTENANCE.calc_reschd_on_new_jobtype;
    END IF;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      NULL;
  END;
END;
/
