Rem drv: <migrate type="schema_upgrade" version="10.1.0.3"/> 
Rem
Rem $Header: ecm_schema_upgrade.sql 13-jan-2005.00:58:36 ktlaw Exp $
Rem
Rem ecm_schema_upgrade.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ktlaw       01/13/05 - add repmgr header 
Rem    vkhizder    04/20/04 - vkhizder_csa_schema_upgrade10102_to_10103 
Rem    vkhizder    04/19/04 - CSA schema upgrade from 10.1.0.2.0 to 10.1.0.3.0 
Rem

Rem Remove CSA view (other views including new/changed views will be regenerated automatically)

DROP VIEW MGMT$CSA_HOSTS;

Rem Upgrade CSA tables

DROP TABLE MGMT_ECM_CSA_GENERAL_INFO;
DROP TABLE MGMT_ECM_CSA;
DROP TABLE MGMT_ECM_HW;
DROP TABLE MGMT_ECM_OS;
DROP TABLE MGMT_ECM_OS_FILESYSTEM;

CREATE TABLE "MGMT_ECM_CSA_GENERAL_INFO" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_CSA_GENERAL_INFO0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "APPLET_VERSION" VARCHAR2(20),
  "CUSTOM_CLASS" VARCHAR2(1000),
  "CUSTOM_CLASS_VERSION" VARCHAR2(1000),
  "TARGET_ID_METHOD" VARCHAR2(100) NOT NULL,
  "OS_USER_NAME" VARCHAR2(500) NOT NULL,
  "BOOT_DISK_VOLUME_SERIAL_NUM" VARCHAR2(100) NOT NULL,
  "HOSTNAME" VARCHAR2(128) NOT NULL,
  "DOMAIN" VARCHAR2(500) NOT NULL,
  "TARGET_KEY1" VARCHAR2(4000),
  "TARGET_KEY2" VARCHAR2(4000),
  "TARGET_KEY3" VARCHAR2(4000),
  "PROXY_TARGET_NAME" VARCHAR2(256),
  "PROXY_TARGET_DISPLAY_NAME" VARCHAR2(256),
  "PROXY_TARGET_ID" RAW(16),
  CONSTRAINT "MGMT_ECM_CSA_GENERAL_INFO_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID")
) MONITORING;

CREATE TABLE "MGMT_ECM_CSA" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_CSA0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "NET_LATENCY_IN_MS" NUMBER,
  "NET_BANDWIDTH_IN_KBITPS" NUMBER,
  "NET_EFFECTIVE_IP" VARCHAR2(20),
  "NET_IP" VARCHAR2(20),
  "NET_SUBNET" VARCHAR2(20),
  "BROWSER_TYPE" VARCHAR2(100),
  "BROWSER_VERSION" VARCHAR2(20),
  "BROWSER_JVM_VENDOR" VARCHAR2(100),
  "BROWSER_JVM_VERSION" VARCHAR2(20),
  "BROWSER_PROXY_SERVER" VARCHAR2(4000),
  "BROWSER_PROXY_EXCEPTIONS" VARCHAR2(4000),
  "BROWSER_CACHE_SIZE_IN_MB" NUMBER,
  "BROWSER_CACHE_UPDATE_FRQ" VARCHAR2(200),
  "BROWSER_HTTP1_1_SUPPORT" VARCHAR2(1),
  "REFERRING_URL_HEADER" VARCHAR2(4000),
  "REFERRING_URL_PARAMS" VARCHAR2(4000),
  "CSA_URL_HEADER" VARCHAR2(4000),
  "CSA_URL_PARAMS" VARCHAR2(4000),
  "DESTINATION_URL_HEADER" VARCHAR2(4000),
  "DESTINATION_URL_PARAMS" VARCHAR2(4000),
  CONSTRAINT "MGMT_ECM_CSA_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID")
) MONITORING;

CREATE TABLE "MGMT_ECM_HW" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_HW0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "HOSTNAME" VARCHAR2(128),
  "DOMAIN" VARCHAR2(500),
  "VENDOR_NAME" VARCHAR2(128),
  "SYSTEM_CONFIG" VARCHAR2(4000),
  "MACHINE_ARCHITECTURE" VARCHAR2(500),
  "CLOCK_FREQ_IN_MHZ" NUMBER,
  "MEMORY_SIZE_IN_MB" NUMBER,
  "AVAIL_MEMORY_SIZE_IN_MB" NUMBER,
  "LOCAL_DISK_SPACE_IN_GB" NUMBER,
  "AVAIL_LOCAL_DISK_SPACE_IN_GB" NUMBER,
  "CPU_COUNT" NUMBER(8),
  "CPU_BOARD_COUNT" NUMBER(8),
  "IOCARD_COUNT" NUMBER(8),
  "FAN_COUNT" NUMBER(8),
  "POWER_SUPPLY_COUNT" NUMBER(8),
  "BOOT_DISK_VOLUME_SERIAL_NUM" VARCHAR2(100),
  "SYSTEM_BIOS" VARCHAR2(100),
  CONSTRAINT "MGMT_ECM_HW_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID")
) MONITORING;

CREATE TABLE "MGMT_ECM_OS" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_OS0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "NAME" VARCHAR2(128),
  "VENDOR_NAME" VARCHAR2(128),
  "BASE_VERSION" VARCHAR2(100),
  "UPDATE_LEVEL" VARCHAR2(100),
  "DISTRIBUTOR_VERSION" VARCHAR2(100),
  "MAX_SWAP_SPACE_IN_MB" NUMBER,
  "ADDRESS_LENGTH_IN_BITS" VARCHAR2(20),
  "MAX_PROCESS_VIRTUAL_MEMORY" NUMBER,
  "TIMEZONE" VARCHAR2(64),
  "TIMEZONE_REGION" VARCHAR2(64),
  "TIMEZONE_DELTA" NUMBER,
  CONSTRAINT "MGMT_ECM_OS_PK" PRIMARY KEY ("ECM_SNAPSHOT_ID")
) MONITORING;

CREATE TABLE "MGMT_ECM_OS_FILESYSTEM" (
  "ECM_SNAPSHOT_ID" RAW(16) NOT NULL CONSTRAINT "MGMT_ECM_OS_FILESYSTEM0" REFERENCES "MGMT_ECM_GEN_SNAPSHOT" ("SNAPSHOT_GUID") ON DELETE CASCADE,
  "RESOURCE_NAME" VARCHAR2(128) NOT NULL,
  "MOUNT_LOCATION" VARCHAR2(1024) NOT NULL,
  "TYPE" VARCHAR2(100),
  "DISK_SPACE_IN_GB" NUMBER,
  "AVAIL_DISK_SPACE_IN_GB" NUMBER,
  "LOCAL_DRIVE" VARCHAR2(1),
  "MOUNT_OPTIONS" VARCHAR2(1024)
) MONITORING;

