Rem drv: <migrate type="schema_upgrade" version="10.2.0.0"  params="EM_ECM_DEPOT_TABLESPACE" pos="webapp/txnmgmt_schema_upgrade.sql+"/>
Rem
Rem $Header: admin_schema_upgrade.sql 25-jul-2005.13:45:40 chyu Exp $
Rem
Rem admin_schema_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      admin_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        07/25/05 - modifying the upgrade header 
Rem    chyu        07/18/05 - modify the version number for the header 
Rem    eujang      03/02/05 - adding the missing table to the admin schema 
Rem                           upgrade 
Rem    skini       02/15/05 - Add backslash 
Rem    edemembe    02/09/05 - edemembe_bug-3556656
Rem    edemembe    02/09/05 - Created
Rem

DEFINE EM_ECM_DEPOT_TABLESPACE = "&1"

Rem
Rem Make sure the CBO stats for the "big" 3 schema tables are locked during upgrade.
Rem
BEGIN
  EXECUTE IMMEDIATE 
    'call dbms_stats.lock_table_stats(''SYSMAN'', ''MGMT_METRICS_RAW'')';
  EXECUTE IMMEDIATE 
    'call dbms_stats.lock_table_stats(''SYSMAN'', ''MGMT_METRICS_1HOUR'')';
  EXECUTE IMMEDIATE 
    'call dbms_stats.lock_table_stats(''SYSMAN'', ''MGMT_METRICS_1DAY'')';
EXCEPTION
    WHEN OTHERS THEN
      NULL;  -- Ignore errors
END;
/
rem
rem  PURPOSE
rem
rem     The MGMT_URL_PROXY table contains information of all the internet
rem     Proxy Servers in the enterprise.
rem
rem  COLUMNS
rem
rem     PROTOCOL         - the proxy protocol (e.g. HTTP, FTP)
rem
rem     HOST_NAME        - hostname (of the proxy server)
rem
rem     PORT_NUMBER      - the port on the HOST (proxy server is listening on this port)
rem
rem     LOCAL_HOST       - the host that will be using this proxy (this is to support multi-OMS configurations)
rem
rem     CREATED_ON       - when this entry was created
rem
rem     IS_DEFAULT       - is this the default proxy to use ?
rem
rem     DONT_PROXY_FOR   - comma seperated list of all hosts, domains etc for
rem                        which the proxy server will be by-passed
rem
rem     PROXY_REALM      - some proxy servers might need additional authentication
rem                        realm identifies the network which the user is part of
rem
rem     PROXY_USER       - the proxy user id / name
rem
rem     PROXY_PASSWORD   - the password that identifies the user
rem
rem  NOTES
rem
rem
rem

CREATE TABLE MGMT_URL_PROXY
    (PROTOCOL             VARCHAR2(32)   NOT NULL,
     HOST_NAME            VARCHAR2(128)  NOT NULL,
     PORT_NUMBER          NUMBER         NOT NULL,
     LOCAL_HOST           VARCHAR2(128)  NOT NULL,
     CREATED_ON           DATE           DEFAULT SYSDATE,
     IS_DEFAULT           VARCHAR2(32)   DEFAULT 'NO',
     DONT_PROXY_FOR       VARCHAR2(1024),
     PROXY_REALM          VARCHAR2(32),
     PROXY_USER           VARCHAR2(32),
     PROXY_PASSWORD       VARCHAR2(32),
     CONSTRAINT MGMT_URL_PROXY_PK PRIMARY KEY (PROTOCOL, HOST_NAME, PORT_NUMBER, LOCAL_HOST))
     MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_URL_CACHE table stores the contents (resources) of a URL
rem     as a BLOB in the table row.
rem     This will enable resource cache enables clients to work in a
rem     disconnected fasion - use URL resource even when not connected to
rem     the internet.
rem
rem  COLUMNS
rem
rem     URL              - the URL
rem
rem     CREATED_ON       - when this row was created
rem
rem     CONTENT_TYPE     - the type of the content (CHAR, BINARY etc)
rem
rem     CONTENT_LENGTH   - the size of the content BLOB
rem
rem     CONTENT          - the resource
rem
rem  NOTES
rem
rem
rem

CREATE TABLE MGMT_URL_CACHE
    (
     URL                VARCHAR2(256)    NOT NULL,
     CREATED_ON         DATE             DEFAULT SYSDATE,
     CONTENT_TYPE       VARCHAR2(32),
     CONTENT_LENGTH     NUMBER,
     CONTENT            BLOB,
     CONSTRAINT MGMT_URL_CACHE_PK PRIMARY KEY (URL)
    ) MONITORING
      LOB(CONTENT) STORE AS ( TABLESPACE &EM_ECM_DEPOT_TABLESPACE );
