Rem
Rem $Header: basic_common_init.sql 16-may-2005.15:11:45 rpinnama Exp $
Rem
Rem basic_common_init.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      basic_common_init.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rkpandey    07/07/05 - Bug 4474926:Register logging module TARGET 
Rem    rpinnama    05/16/05 - rpinnama_bug-4331862_main
Rem    rpinnama    05/12/05 - Created
Rem


BEGIN
  -- Add schema owner name as a parameter in the repository.
  BEGIN
    INSERT INTO MGMT_PARAMETERS
      (parameter_name, parameter_value, parameter_comment)
     VALUES
      (MGMT_GLOBAL.G_SCHEMA_OWNER_PARAM_NAME, '&&EM_REPOS_USER', 'The owner of the repository.');
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;
END;
/


Rem Data required for sharedfilesystem loader
BEGIN
  BEGIN
   INSERT INTO MGMT_PARAMETERS
    (parameter_name, parameter_value, parameter_comment)
   VALUES
    ('LOAD_DESIGNATOR_COUNT', '40', 'The number of load designators');
  EXCEPTION
    WHEN OTHERS THEN
      NULL;
  END;
 COMMIT;
END;
/

rem Register receiver logging modules.
BEGIN
  mgmt_log.register_logging_module ('LOADER.RECEIVER','Loader Receiver');
  commit;
END;
/

BEGIN
  -- Add metric categories for Functional class
DECLARE
  l_func_categories MGMT_CATEGORY_DEF_ARRAY := MGMT_CATEGORY_DEF_ARRAY();
BEGIN
  -- =-= str - add nls-ids when UI support is added
  l_func_categories.extend(9);
  l_func_categories(1) := MGMT_CATEGORY_DEF_OBJ.NEW(p_category_name => mgmt_global.G_FUNC_CATEGORY_FAULT,
                                                    p_category_name_nlsid => 'FAULT');
  l_func_categories(2) := MGMT_CATEGORY_DEF_OBJ.NEW(p_category_name => mgmt_global.G_FUNC_CATEGORY_WORKLOAD_VOL,
                                                    p_category_name_nlsid => 'WORKLOAD_VOLUME');
  l_func_categories(3) := MGMT_CATEGORY_DEF_OBJ.NEW(p_category_name => mgmt_global.G_FUNC_CATEGORY_WORKLOAD_TYPE,
                                                    p_category_name_nlsid => 'WORKLOAD_TYPE');
  l_func_categories(4) := MGMT_CATEGORY_DEF_OBJ.NEW(p_category_name => mgmt_global.G_FUNC_CATEGORY_PERFORMANCE,
                                                    p_category_name_nlsid => 'PERFORMANCE');
  l_func_categories(5) := MGMT_CATEGORY_DEF_OBJ.NEW(p_category_name => mgmt_global.G_FUNC_CATEGORY_CAPACITY,
                                                    p_category_name_nlsid => 'CAPACITY');     
  l_func_categories(6) := MGMT_CATEGORY_DEF_OBJ.NEW(p_category_name => mgmt_global.G_FUNC_CATEGORY_CONFIGURATION,
                                                    p_category_name_nlsid => 'CONFIGURATION');       
  l_func_categories(7) := MGMT_CATEGORY_DEF_OBJ.NEW(p_category_name => mgmt_global.G_FUNC_CATEGORY_SECURITY,
                                                    p_category_name_nlsid => 'SECURITY');  
  l_func_categories(8) := MGMT_CATEGORY_DEF_OBJ.NEW(p_category_name => mgmt_global.G_FUNC_CATEGORY_STORAGE,
                                                    p_category_name_nlsid => 'STORAGE');
  l_func_categories(9) := MGMT_CATEGORY_DEF_OBJ.NEW(p_category_name => mgmt_global.G_FUNC_CATEGORY_UNCLASSIFIED,
                                                    p_category_name_nlsid => 'UNCLASSIFIED');
  
  mgmt_metric.create_category_class( 
              p_class_name        => mgmt_global.G_CATEGORY_CLASS_FUNCTIONAL,
              p_class_name_nlsid  => NULL, 
              p_category_def_list => l_func_categories);
  
  COMMIT;
END;
END;
/


rem Create the AQ for Loader Shared FS solution
BEGIN
  DBMS_AQADM.CREATE_QUEUE_TABLE 
        (queue_table => '&EM_REPOS_USER'||'.MGMT_LOADER_QTABLE',
         queue_payload_type => 'RAW',
         multiple_consumers => TRUE);
  DBMS_AQADM.CREATE_QUEUE 
        (queue_name => '&EM_REPOS_USER'||'.MGMT_LOADER_Q',
         queue_table => '&EM_REPOS_USER'||'.MGMT_LOADER_QTABLE');
  DBMS_AQADM.START_QUEUE 
        (queue_name => '&EM_REPOS_USER'||'.MGMT_LOADER_Q');
END;
/

rem Initialize sharedFS.
BEGIN
  EMD_LOADER.INITIALIZE_SHAREDFS();
  COMMIT;
END;
/

rem Register the OMS failover callback
BEGIN
  MGMT_FAILOVER.REGISTER_CALLBACK('EMD_LOADER.OMS_FAILOVER');
  COMMIT;
END;
/

BEGIN
  emd_loader.add_plsql_handler_for_rowset(
      p_rowset_name => 'MGMT_CHANGE_AGENT_URL', 
      p_proc_name => 'emd_loader.set_emd_url_change');
  commit;
EXCEPTION
  WHEN OTHERS
    THEN
      dbms_output.put_line( 'EXCEPTION add handler for MGMT_CHANGE_AGENT_URL rowset callback '|| SQLCODE );
      RAISE;
END;
/
show error;


BEGIN
  -- Register rowset handler for target type versions
  emd_loader.add_plsql_handler_for_rowset(
      p_rowset_name => 'MGMT_TARGET_TYPE_VERSIONS',
      p_proc_name => 'EM_TARGET.add_target_type_version');
  COMMIT;
END;
/

-- Register target logging module
BEGIN
  mgmt_log.register_logging_module ('TARGET','Target');
 
  COMMIT;
END;
/

