Rem drv: <migrate type="data_upgrade" version="10.2.0.0" pos="availability_data_upgrade.sql+"/>
Rem
Rem $Header: basic_data_upgrade.sql 26-jul-2005.19:28:50 chyu Exp $
Rem
Rem basic_data_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      basic_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        07/26/05 - modifying the migrate header position 
Rem    chyu        07/18/05 - updating the new rep manager header 
Rem    rpinnama    05/12/05 - Migrate target delete callbacks to 
Rem                           mgmt_callbacks tabe 
Rem    rpinnama    05/12/05 - Move 102010 common initialization to common_init 
Rem    rpinnama    05/06/05 - Register CHANGE_AGENT_URL rowset handler 
Rem    rmaggarw    02/24/05 - bug 4204931: prefix schema name to AQ objects 
Rem    rmaggarw    02/17/05 - add AQ and seed data from SharedFS loader 
Rem    rpinnama    02/06/05 - rpinnama_add_upgrade_scripts
Rem    rpinnama    02/02/05 - Created
Rem

Rem put index compression here since we need to call a plsql procedure to do it.
BEGIN
 EMD_MAINTENANCE.COMPRESS_INDEX('MGMT_CURRENT_METRICS_PK', 1, FALSE);
 EMD_MAINTENANCE.COMPRESS_INDEX('MGMT_METRIC_ERRORS_PK', 4, FALSE);
 EMD_MAINTENANCE.COMPRESS_INDEX('MGMT_STRING_METRIC_HISTORY_PK', 3, FALSE);
 EMD_MAINTENANCE.COMPRESS_INDEX('MGMT_TARGET_PROPERTIES_PK', 1, FALSE);
 EMD_MAINTENANCE.COMPRESS_INDEX('MGMT_TARGET_ROLLUP_TIMES_PK', 1, FALSE);
END;
/

PROMPT Reregister target deletion callbacks
SELECT to_char(SYSDATE, 'YYYY-MM-DD HH24:MI:SS') FROM DUAL;

DECLARE
BEGIN
  FOR tgt_del_cbk IN (SELECT callback_name from mgmt_target_delete_callbacks)
  LOOP
    BEGIN
      MGMT_ADMIN.add_target_deletion_callback(tgt_del_cbk.callback_name);
    EXCEPTION
      WHEN OTHERS THEN
        -- Ignore duplicate callbacks
        DBMS_OUTPUT.PUT_LINE('***** INFO : Error registering callback ' || tgt_del_cbk.callback_name);
        NULL;
    END;
  END LOOP;
END;
/

PROMPT Done Reregister target deletion callbacks
SELECT to_char(SYSDATE, 'YYYY-MM-DD HH24:MI:SS') FROM DUAL;




-- 1020101 initialization done by calling the common init
@@&&EM_SQL_ROOT/core/v102010/basic/basic_common_init.sql


