Rem drv: <migrate type="schema_upgrade" version="10.2.0.0" pos="availability_schema_upgrade.sql+"/>
Rem
Rem $Header: basic_schema_upgrade.sql 01-dec-2006.21:41:22 aptrived Exp $
Rem
Rem basic_schema_upgrade.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      basic_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    aptrived    12/01/06 - Bug#5475805, fixing ORA-0955
Rem    rmaggarw    11/22/06 - bug 5666116 - cascade index on dropping pk on
Rem                           mgmt_annotation
Rem    rmaggarw    11/26/06 - Backport rmaggarw_bug-5666116 from main
Rem    pmodi       11/25/06 - Backport pmodi_bug-5666121 from main Use 
Rem                           cascade in DROP CONSTRAINT
Rem    ramalhot    08/24/05 - Moved is_renderable col of mgmt_metric to 
Rem                           v102020 
Rem    neearora    08/22/05 - Added check for existence of MGMT_CALLBACKS 
Rem                           before creating the table 
Rem    chyu        08/23/05 - removing the is_rendenrable column from the 
Rem                           mgmt_metric table 
Rem    chyu        07/25/05 - modifying the upgrade header 
Rem    chyu        07/18/05 - adding the <migration> header 
Rem    pmodi       07/13/05 - Bug:444831 - Add back 2 cols to MGMT_TARGETS 
Rem                           which gets dropped in v102020, for BETA to 
Rem                           production upgrade 
Rem    pmodi       07/12/05 - Bug:4480809 - Change default value to NULL for 
Rem                           mgmt_targets.timezone_region 
Rem    dcawley     06/23/05 - Change primary key on annotations table 
Rem    jsadras     06/17/05 - create index on mgmt_current_metrics.metric_guid 
Rem                           , Bug:4289902 
Rem    dcawley     06/15/05 - Increase user_name column in annotation table 
Rem    pmodi       05/26/05 - Bug:4396320-change default value of 
Rem                           is_transposed to NULL 
Rem    rmarripa    05/14/05 - set default value of remote to null 
Rem    rpinnama    06/06/05 - Fix 4397891: Recreate index 02 on mgmt_targets 
Rem    rpinnama    05/17/05 - Add is_renderable column to mgmt_metrics 
Rem    jsadras     05/03/05 - add is_long_running 
Rem    ramalhot    04/21/05 -  removed columns from mgmt_targets 
Rem    pmodi       04/19/05 - Disbale trigger before alter of mgmt_targets 
Rem    dkjain      04/15/05 - upgrade mgmt_category_map_idx_01 
Rem    skini       03/21/05 - Upgrade PK for prop defs table 
Rem    jsadras     03/10/05 - mgmt_callbacks.eval_order
Rem    eujang      03/10/05  - debug
Rem    eujang      03/03/05  - Adding missing indexes 
Rem    ramalhot    02/09/05 -  added owner in mgmt_targets 
Rem    dcawley     02/08/05 - Add owner column to mgmt_targets 
Rem    rpinnama    02/06/05 - rpinnama_add_upgrade_scripts
Rem    rpinnama    02/02/05 - Created
Rem

DEFINE EM_TARGET_NAME_SIZE=256
DEFINE EM_TARGET_TYPE_SIZE=64
DEFINE EM_META_VER_SIZE=8
DEFINE EM_URL_SIZE=1024
DEFINE EM_CLASS_NAME_SIZE=64
DEFINE EM_CATEGORY_NAME_SIZE=64
DEFINE EM_DEFAULT_NLSID_SIZE=64



Rem Upgrade types
CREATE OR REPLACE TYPE SMP_EMD_TGT_OBJECT as OBJECT (
     target_name VARCHAR2(256),
     target_type VARCHAR2(64),
     target_guid RAW(16),
     display_name VARCHAR(256),
     type_display_name VARCHAR2(128),
     host_name VARCHAR2(256)
);
/

CREATE OR REPLACE TYPE SMP_EMD_TGT_OBJECT_TBL as TABLE of SMP_EMD_TGT_OBJECT;
/

-- type for compare metrics in metric details page
CREATE OR REPLACE TYPE MGMT_MD_COMPARE_OBJ as OBJECT (
    target_guid RAW(16),
    metric_guid RAW(16),
    target_name VARCHAR2(256),
    timezone_region VARCHAR2(64),
    start_time DATE,
    end_time DATE
);
/

create or replace type MGMT_MD_COMPARE_ARRAY as TABLE of MGMT_MD_COMPARE_OBJ;
/


Rem Upgrade tables


ALTER TABLE MGMT_METRICS
ADD (
    usage_type                 NUMBER          DEFAULT 0,
    is_repository              NUMBER(1)       DEFAULT 0, 
    author                     VARCHAR2(256)   DEFAULT 'ORACLE',
    source_type                NUMBER(1)       DEFAULT 0,
    source                     VARCHAR2(4000)  DEFAULT NULL,
    is_transposed              NUMBER(1)       DEFAULT NULL,
    is_test_metric             NUMBER(1)       DEFAULT 0,
    has_push                   NUMBER(1)       DEFAULT 0,
    has_pull                   NUMBER(1)       DEFAULT 0,
    remote                     NUMBER(1)       DEFAULT NULL,
    repo_timing_enabled        NUMBER(1)       DEFAULT 0,
    non_thresholded_alerts     NUMBER(1)       DEFAULT NULL,
    keyonly_thresholds         NUMBER(1)       DEFAULT NULL,
    is_long_running            NUMBER(1)       DEFAULT 0
);


DECLARE
BEGIN
  -- Populate the newly added columns
  UPDATE mgmt_metrics
     SET is_repository = 1
   WHERE metric_type IN (5, 6, 7, 8);

  -- Populate source and source_type
  -- For repos_table, number and string, set source_type = G_METRIC_SOURCE_OLD_PLSQL
  UPDATE mgmt_metrics
     SET source_type = 1,
         source = eval_func
   WHERE metric_type IN (5, 6, 7);

  -- For repos events, set source type = G_METRIC_SOURCE_SEVEVAL_PLSQL
  UPDATE mgmt_metrics
     SET source_type = 5,
         source = eval_func
   WHERE metric_type = 8;

  COMMIT;
END;
/

DECLARE 
  l_non_thresholded_alerts NUMBER;
  l_key_only_thresholds NUMBER;
BEGIN

  -- Populate the columns non_thresholded_alerts and keyonly_thresholds
  FOR ext_rec IN (SELECT metric_guid, target_type, meta_ver, category_prop_1,
                         category_prop_2, category_prop_3, category_prop_4,
			 category_prop_5, alertable, thresholdable, keyonly_thresholds
                    FROM mgmt_metrics_ext
                   ORDER BY metric_guid, meta_ver, category_prop_1, category_prop_2,
		            category_prop_3, category_prop_4, category_prop_5)
  LOOP
    l_non_thresholded_alerts := 0;
    l_key_only_thresholds := 0;

    IF (ext_rec.alertable = 'Y' AND ext_rec.thresholdable = 'N') THEN
      l_non_thresholded_alerts := 1;
    ELSE
      l_non_thresholded_alerts := 0;
    END IF;

    IF (ext_rec.keyonly_thresholds = 'Y') THEN
      l_key_only_thresholds := 1;
    ELSE
      l_key_only_thresholds := 0;
    END IF;

    UPDATE mgmt_metrics
       SET non_thresholded_alerts = l_non_thresholded_alerts,
           keyonly_thresholds = l_key_only_thresholds
     WHERE metric_guid = ext_rec.metric_guid
       AND type_meta_ver = ext_rec.meta_ver
       AND category_prop_1 = ext_rec.category_prop_1
       AND category_prop_2 = ext_rec.category_prop_2
       AND category_prop_3 = ext_rec.category_prop_3
       AND category_prop_4 = ext_rec.category_prop_4
       AND category_prop_5 = ext_rec.category_prop_5;

  END LOOP;

  COMMIT;

END;
/


ALTER TABLE mgmt_target_prop_defs
ADD (
     computed_flag            NUMBER(1)                          DEFAULT 0 NOT NULL,
     read_only_flag           NUMBER(1)                          DEFAULT 0 NOT NULL,
     hidden_flag              NUMBER(1)                          DEFAULT 0 NOT NULL,
     system_flag              NUMBER(1)                          DEFAULT 1 NOT NULL,
     all_versions             NUMBER(1)                          DEFAULT 0 NOT NULL
);

ALTER TABLE MGMT_TARGET_PROP_DEFS DROP CONSTRAINT MGMT_TARGET_PROP_DEFS_PK CASCADE DROP INDEX;
ALTER TABLE MGMT_TARGET_PROP_DEFS
   ADD CONSTRAINT MGMT_TARGET_PROP_DEFS_PK
       PRIMARY KEY (target_type, type_meta_ver, property_name, property_type)
       USING INDEX;



CREATE TABLE MGMT_ALL_TARGET_PROPS
    (property_name            VARCHAR2(64)                       NOT NULL,
     property_type            VARCHAR2(64)                       DEFAULT 'INSTANCE',
     property_display_name    VARCHAR2(64)                       NOT NULL,
     property_display_nlsid   VARCHAR2(64)                       DEFAULT NULL,
     required_flag            NUMBER(1)                          DEFAULT 0,
     credential_flag          NUMBER(1)                          DEFAULT 0,
     default_value            VARCHAR2(1024)                     DEFAULT NULL,
     computed_flag            NUMBER(1)                          DEFAULT 0,
     read_only_flag           NUMBER(1)                          DEFAULT 0,
     hidden_flag              NUMBER(1)                          DEFAULT 0,
     system_flag              NUMBER(1)                          DEFAULT 0)
  INITRANS 2
  MONITORING;

Rem
Rem indices on mgmt_current_metrics
Rem

BEGIN
  EXECUTE IMMEDIATE 'CREATE INDEX &&EM_REPOS_USER..MGMT_CURRENT_METRICS_IDX_01 ON MGMT_CURRENT_METRICS(metric_guid)';
 EXCEPTION
    WHEN OTHERS THEN
      IF(SQLCODE != -955)THEN --name is already used by an existing object 
        RAISE;
      END IF;
END;
/

rem  PURPOSE
rem    This table stores the versions for which the repository metric
rem    is supported.
rem    
CREATE TABLE mgmt_metric_versions
(
    target_type         VARCHAR2(&&EM_TARGET_TYPE_SIZE) NOT NULL,
    metric_name         VARCHAR2(64)                    NOT NULL,
    start_type_meta_ver VARCHAR2(8)                     DEFAULT '1.0',
    end_type_meta_ver   VARCHAR2(8)                     DEFAULT NULL
)
MONITORING;

COMMENT ON TABLE mgmt_metric_versions IS
  'This table stores the list of versions for which the repository metric
   is supported.';

COMMENT ON COLUMN mgmt_metric_versions.target_type IS
  'The type of the target.';

COMMENT ON COLUMN mgmt_metric_versions.metric_name IS
  'The name of the repository metric that is supported for multiple versions.';

COMMENT ON COLUMN mgmt_metric_versions.start_type_meta_ver IS
  'The starting type meta version from which this metric is supported. 
   Defaults to 1.0, the first meta version for all target types.';

COMMENT ON COLUMN mgmt_metric_versions.end_type_meta_ver IS
  'The ending type meta version till which this metric is supported. 
   Defaults to NULL, to specify that this metric has to be applied to all versions
   above start_type_meta_ver.';


ALTER TABLE mgmt_metric_versions
  ADD CONSTRAINT mgmt_metric_versions_pk
    PRIMARY KEY(target_type, metric_name);


rem  
rem  PURPOSE
rem    
rem    This table stores the list of metric classes.
rem
CREATE TABLE mgmt_category_classes
(   
    class_name       VARCHAR2(&&EM_CLASS_NAME_SIZE)    NOT NULL,
    class_name_nlsid VARCHAR2(&&EM_DEFAULT_NLSID_SIZE)
)
MONITORING;

COMMENT ON TABLE mgmt_category_classes IS
  'This table stores the list of category classes.';

COMMENT ON COLUMN mgmt_category_classes.class_name IS
  'The name of the category class.';

COMMENT ON COLUMN mgmt_category_classes.class_name_nlsid IS
  'The NLSID of the category class.';

ALTER TABLE mgmt_category_classes
  ADD CONSTRAINT mgmt_category_classes_pk
    PRIMARY KEY(class_name);


rem
rem  PURPOSE
rem
rem    This table contains categories available for a metric class.
rem
CREATE TABLE mgmt_categories
(
    class_name          VARCHAR2(&&EM_CLASS_NAME_SIZE) NOT NULL,
    category_name       VARCHAR2(&&EM_CATEGORY_NAME_SIZE) NOT NULL,
    category_name_nlsid VARCHAR2(&&EM_DEFAULT_NLSID_SIZE)
)
MONITORING;

COMMENT ON TABLE mgmt_categories IS
  'This table defines the category names available for a metric class.';

COMMENT ON COLUMN mgmt_categories.class_name IS
  'The name of the metric class for which the categories are defined.';

COMMENT ON COLUMN mgmt_categories.category_name IS
  'The name of the category applicable for the metric class.';

COMMENT ON COLUMN mgmt_categories.category_name_nlsid IS
  'The NLSID of the category name.';

ALTER TABLE mgmt_categories
  ADD CONSTRAINT mgmt_categories_pk
    PRIMARY KEY(class_name, category_name);


rem
rem  PURPOSE
rem
rem    This table provides information about what category is applicable
rem    for a given metric/policy guid and metric class. The same table is
rem    used to define mappings for both metrics and policies.
rem
CREATE TABLE mgmt_category_map
(     
    target_type         VARCHAR2(&&EM_TARGET_TYPE_SIZE)   NOT NULL,
    type_meta_ver       VARCHAR2(&&EM_META_VER_SIZE)      DEFAULT '1.0' NOT NULL,
    object_guid         RAW(16)                           NOT NULL,
    class_name          VARCHAR2(&&EM_CLASS_NAME_SIZE)    NOT NULL,
    category_name       VARCHAR2(&&EM_CATEGORY_NAME_SIZE) NOT NULL, 
    object_type         NUMBER(1)                         DEFAULT 0 NOT NULL
)
MONITORING;

COMMENT ON TABLE mgmt_category_map IS
  'This table provides information about what category is applicable
   for a given metric/policy guid and metric class. The same table is
   used to define mappings for both metrics and policies.';
  
COMMENT ON COLUMN mgmt_category_map.target_type is
  'Defines the target type of the object being categorized.';

COMMENT ON COLUMN mgmt_category_map.type_meta_ver is
  'Defines the type meta version of the object being categorized.';

COMMENT ON COLUMN mgmt_category_map.object_guid IS
  'The GUID of either metric or policy. If object_type =
        = 1, the guid is metric_guid
        = 2, the guid is a policy_guid.';

COMMENT ON COLUMN mgmt_category_map.class_name IS
  'The classification name.';

COMMENT ON COLUMN mgmt_category_map.category_name IS
  'The name of the category for which the object_guid belongs to
   for the given classification.';

COMMENT ON COLUMN mgmt_category_map.object_type IS
  'Defines the type of the object for which the mapping is defined.
   If the object_type = 0, the object_guid is a metric_guid
   Else if the object_type = 1, then the object_guid is policy_guid';.


ALTER TABLE mgmt_category_map
  ADD CONSTRAINT mgmt_category_map_pk
    PRIMARY KEY(target_type, type_meta_ver, object_guid, class_name);

CREATE INDEX mgmt_category_map_idx_01
  ON mgmt_category_map(category_name, object_type, object_guid);

ALTER TABLE MGMT_TARGET_TYPES
ADD (
     target_type_guid       RAW(16),
     max_type_meta_ver      VARCHAR(8)                        DEFAULT '1.0'
);


DECLARE 
  l_type_guid RAW(16);
BEGIN
  FOR types IN (SELECT target_type FROM mgmt_target_types) 
  LOOP
    l_type_guid := DBMS_OBFUSCATION_TOOLKIT.md5(
             input => UTL_RAW.cast_to_raw('ora$target_type' ||
                            ';'|| types.target_type));
    UPDATE mgmt_target_types
       SET target_type_guid = l_type_guid
     WHERE target_type = types.target_type;

  END LOOP;
  -- TODO: Populate max_type_meta_ver.
  COMMIT;

END;
/

Rem Enable not null constraint

ALTER TABLE MGMT_TARGET_TYPES
MODIFY (target_type_guid RAW(16) NOT NULL);

COMMENT ON TABLE mgmt_target_types IS
    'The MGMT_TARGET_TYPES table holds the list of target type';

COMMENT ON COLUMN mgmt_target_types.target_type IS
    'the type of the target.  The type defines the set of metrics that are 
     applicable for the target.';

COMMENT ON COLUMN mgmt_target_types.type_display_name IS
    'a user friendly name in English for the target type that is 
    used from the user interface.';

COMMENT ON COLUMN mgmt_target_types.type_display_nlsid IS
    'NLS id for the target type display';

COMMENT ON COLUMN mgmt_target_types.type_resource_bundle IS
    'Resource bundle name that holds all the NLS ids for this type.';

COMMENT ON COLUMN mgmt_target_types.target_type_guid IS
    'The unique ID for the target type.';

COMMENT ON COLUMN mgmt_target_types.max_type_meta_ver IS
    'The maximum type meta version known in the repository.';


rem
rem  PURPOSE
rem     The MGMT_TARGET_TYPE_VERSIONS table holds the list of
rem     target type versions.
rem
CREATE TABLE MGMT_TARGET_TYPE_VERSIONS
   (target_type           VARCHAR2(&EM_TARGET_TYPE_SIZE) NOT NULL,
    type_meta_ver         VARCHAR2(128)                  DEFAULT '1.0',
    type_display_name     VARCHAR2(128)                  DEFAULT ' ',
    type_display_nlsid    VARCHAR2(64)                   DEFAULT ' ',
    type_resource_bundle  VARCHAR2(256)                  DEFAULT ' ',
    target_type_ver_guid  RAW(16)                        NOT NULL,
    created_date          DATE                           DEFAULT SYSDATE,
    last_updated_date     DATE                           DEFAULT SYSDATE)
  INITRANS 2
  MONITORING;

COMMENT ON TABLE mgmt_target_type_versions IS
    'The MGMT_TARGET_TYPE_VERSIONS table holds the list of target type versions';

COMMENT ON COLUMN mgmt_target_type_versions.target_type IS
    'the type of the target.';

COMMENT ON COLUMN mgmt_target_type_versions.type_meta_ver IS
    'the target type metadata version.';

COMMENT ON COLUMN mgmt_target_type_versions.target_type_ver_guid IS
    'the unqiue ID for the targe type metadata version.';

COMMENT ON COLUMN mgmt_target_type_versions.type_display_name IS
    'a user friendly name in English for the target type version that is 
    used from the user interface.';

COMMENT ON COLUMN mgmt_target_type_versions.type_display_nlsid IS
    'NLS id for the target type display';

COMMENT ON COLUMN mgmt_target_type_versions.type_resource_bundle IS
    'Resource bundle name that holds all the NLS ids for this type.';

COMMENT ON COLUMN mgmt_target_type_versions.created_date IS
    'the date/time when the target type meta version is created 
    in the repository.';

COMMENT ON COLUMN mgmt_target_type_versions.last_updated_date IS
    'the date/time when the target type meta version is 
    last updated in the repository.';

ALTER TABLE MGMT_TARGET_TYPE_VERSIONS
   ADD CONSTRAINT MGMT_TARGET_TYPE_VERSIONS_PK
       PRIMARY KEY (target_type, type_meta_ver)
       USING INDEX;


PROMPT Populating target types table
SELECT to_char(SYSDATE, 'YYYY-MM-DD HH24:MI:SS') FROM DUAL;

DECLARE 
  l_type_ver_guid RAW(16);
  l_max_type_meta_ver mgmt_metrics.type_meta_ver%TYPE;
  l_max_type_meta_num NUMBER;
  l_type_meta_num NUMBER;

  FUNCTION type_meta_ver_to_num(p_type_meta_ver IN VARCHAR2)
    RETURN NUMBER IS 
    l_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
    l_minor_ver NUMBER := 0;
    l_major_ver NUMBER := 0;
    l_ret_numb  NUMBER := 0;
  BEGIN
    l_type_meta_ver := NVL(p_type_meta_ver, '1.0');
    l_major_ver := TO_NUMBER( SUBSTR(l_type_meta_ver, 1, INSTR(l_type_meta_ver, '.') -1));
    l_minor_ver := TO_NUMBER( SUBSTR(l_type_meta_ver, INSTR(l_type_meta_ver, '.') + 1));
  
    l_ret_numb := (1000 * l_major_ver) + l_minor_ver;
  
    RETURN l_ret_numb;
  
  END type_meta_ver_to_num;

BEGIN

  -- Populate target type versions
  FOR types IN (SELECT target_type, type_display_name, type_display_nlsid, 
                       type_resource_bundle, max_type_meta_ver
                  FROM mgmt_target_types
		 ORDER BY target_type) 
  LOOP

    l_max_type_meta_ver := '1.0';
    l_max_type_meta_num := type_meta_ver_to_num(l_max_type_meta_ver);

    FOR type_vers IN (SELECT DISTINCT target_type, type_meta_ver
                        FROM mgmt_metrics
                       WHERE target_type = types.target_type
  		       ORDER BY target_type, type_meta_ver) 

    LOOP

      l_type_ver_guid := DBMS_OBFUSCATION_TOOLKIT.md5(
             input => UTL_RAW.cast_to_raw('ora$target_type_ver' ||
                            ';'|| types.target_type || ';' || types.max_type_meta_ver));

      l_type_meta_num := type_meta_ver_to_num(type_vers.type_meta_ver);

      IF (l_type_meta_num > l_max_type_meta_num) THEN
        l_max_type_meta_num := l_type_meta_num;
	l_max_type_meta_ver := type_vers.type_meta_ver;
      END IF;

      BEGIN
        INSERT INTO mgmt_target_type_versions
          (target_type, type_meta_ver, type_display_name, type_display_nlsid, 
	   type_resource_bundle, target_type_ver_guid)
         VALUES
          (types.target_type, type_vers.type_meta_ver, types.type_display_name, 
	   types.type_display_nlsid, types.type_resource_bundle, l_type_ver_guid);
      EXCEPTION
        WHEN DUP_VAL_ON_INDEX THEN
          -- Ignore duplicates
          NULL;
      END;

    END LOOP;

    -- Handle the case where the type exists without any metrics
    l_type_ver_guid := DBMS_OBFUSCATION_TOOLKIT.md5(
        input => UTL_RAW.cast_to_raw('ora$target_type_ver' ||
                            ';'|| types.target_type || ';' || l_max_type_meta_ver));

    BEGIN
      INSERT INTO mgmt_target_type_versions
          (target_type, type_meta_ver, type_display_name, type_display_nlsid, 
	   type_resource_bundle, target_type_ver_guid)
      VALUES
          (types.target_type, l_max_type_meta_ver, types.type_display_name, 
	   types.type_display_nlsid, types.type_resource_bundle, l_type_ver_guid);
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
          -- Ignore duplicates
          NULL;
    END;

    -- Update the max type meta ver
    UPDATE mgmt_target_types
       SET max_type_meta_ver = l_max_type_meta_ver
     WHERE target_type = types.target_type;

  END LOOP;

  COMMIT;

END;
/

PROMPT Done populating target types table
SELECT to_char(SYSDATE, 'YYYY-MM-DD HH24:MI:SS') FROM DUAL;

ALTER TABLE MGMT_TARGETS DISABLE ALL TRIGGERS ;

ALTER TABLE MGMT_TARGETS
ADD (
     last_assoc_load_time  DATE         DEFAULT NULL,
     assoc_count        NUMBER          DEFAULT 0,
     owner              VARCHAR2(256)   DEFAULT '<SYSTEM>'
);

ALTER TABLE MGMT_TARGETS MODIFY TIMEZONE_REGION VARCHAR2(64) DEFAULT NULL ;

ALTER TABLE MGMT_TARGETS ENABLE ALL TRIGGERS ;


-- Drop and recreate the mgmt_targets_idx_02 index
DROP INDEX MGMT_TARGETS_IDX_02;

CREATE INDEX MGMT_TARGETS_IDX_02
  ON MGMT_TARGETS
     (emd_url, target_type)
  INITRANS 4;

DECLARE
   l_object_name VARCHAR2(30);
BEGIN
  SELECT object_name
    INTO l_object_name
    FROM all_objects
   WHERE object_name = 'MGMT_CALLBACKS'
     AND object_type = 'TABLE';

EXCEPTION
  WHEN NO_DATA_FOUND THEN
    EXECUTE IMMEDIATE 
      'CREATE TABLE &&EM_REPOS_USER..MGMT_CALLBACKS ( ' || 
        'callback_type NUMBER(2) NOT NULL, ' ||
        'callback_name VARCHAR2(100) NOT NULL, ' ||
        'selector_1    VARCHAR2(64) DEFAULT '' '', ' ||
        'selector_2    VARCHAR2(64) DEFAULT '' '', ' ||
        'selector_3    VARCHAR2(64) DEFAULT '' '', ' ||
        'eval_order    NUMBER(2)    DEFAULT 0, ' ||
        'CONSTRAINT MGMT_CALLBACKS_PK PRIMARY KEY (callback_name,callback_type, selector_1,selector_2) ' ||
      ')MONITORING ';
END;
/ 

rem
rem  PURPOSE
rem
rem  MGMT_ROWSET_HANDLERS table stores rowset handlers used by XMLLoader
rem

CREATE TABLE MGMT_ROWSET_HANDLERS ( 
    rowset_name       VARCHAR2(32)  NOT NULL,
    protocol_version  VARCHAR2(16)  DEFAULT ' ',
    handler_type      NUMBER(2)     NOT NULL,
    handler_info      VARCHAR2(128) DEFAULT NULL,
    CONSTRAINT MGMT_ROWSET_HANDLERS_PK 
        PRIMARY KEY (rowset_name, protocol_version)
) MONITORING;

COMMENT ON TABLE MGMT_ROWSET_HANDLERS IS
  'The MGMT_ROWSET_HANDLERS table stores details of the handlers used
   by XMLLoader to process rowsets.';

COMMENT ON COLUMN MGMT_ROWSET_HANDLERS.ROWSET_NAME IS
  'the rowset name.';
  
COMMENT ON COLUMN MGMT_ROWSET_HANDLERS.PROTOCOL_VERSION IS
  'the protocol version for which this handler settings have to be applied.';

COMMENT ON COLUMN MGMT_ROWSET_HANDLERS.HANDLER_TYPE IS
  'the type of the rowset handler.';
  
COMMENT ON COLUMN MGMT_ROWSET_HANDLERS.HANDLER_INFO IS
  'Additional info related to the type of the handler.
   For PL/SQL rowset handler the handler_info stores the 
   plsql procedure name.';


CREATE TABLE MGMT_MESSAGES (
    message_id    VARCHAR2(256)   NOT NULL,
    subsystem     VARCHAR2(64)    NOT NULL,
    language_code VARCHAR2(2)     DEFAULT 'en' NOT NULL,
    country_code  VARCHAR2(2)     DEFAULT ' ' NOT NULL,
    message       NVARCHAR2(1000) DEFAULT ' ',
    CONSTRAINT MGMT_MESSAGES_PK PRIMARY KEY (message_id, subsystem, language_code, country_code)
) MONITORING;


CREATE TABLE MGMT_LOADER_DESIGNATORS (
    designator   VARCHAR2(2) NOT NULL,
    oms_id       NUMBER DEFAULT 0,
    CONSTRAINT MGMT_LOADER_DESIGNATORS_PK PRIMARY KEY(designator)
) MONITORING;

rem
rem  PURPOSE
rem     Sequence for generating unique filenames in Shared FS solution
rem
CREATE SEQUENCE MGMT_LOADER_SEQUENCE
    MINVALUE 1000000000
    MAXVALUE 9999999999
    START WITH 1000000001
    INCREMENT BY 1
    CYCLE
    ORDER;



Rem
Rem Indices for MGMT_ALL_TARGET_PROPS table
Rem

ALTER TABLE MGMT_ALL_TARGET_PROPS
   ADD CONSTRAINT MGMT_ALL_TARGET_PROPS_PK
       PRIMARY KEY (property_name, property_type)
       USING INDEX;

Rem
Rem Increase the size of the user_name column in the annotations table
Rem
ALTER TABLE MGMT_ANNOTATION MODIFY (USER_NAME VARCHAR2(256));

Rem
Rem Drop the primary key on the annotations table and replace with an index
Rem
ALTER TABLE MGMT_ANNOTATION DROP CONSTRAINT MGMT_ANNOTATION_PK CASCADE DROP INDEX;

CREATE INDEX MGMT_ANNOTATION_IDX_01
  ON MGMT_ANNOTATION
     (source_obj_type, source_obj_guid, timestamp)
  INITRANS 4;

