Rem
Rem $Header: beacon_common_init.sql 15-jun-2005.18:17:56 rmarripa Exp $
Rem
Rem beacon_common_init.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      beacon_common_init.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rmarripa    06/14/05 -  add webapp service initialization 
Rem    rpinnama    05/16/05 - rpinnama_bug-4331862_main
Rem    rpinnama    05/12/05 - Created
Rem

DECLARE
  TBL_NAMES SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN
  BEGIN
    MGMT_ADMIN.ADD_TARGET_DELETION_CALLBACK('EMD_BCN_ADMIN.BEACON_DELETE_CALLBACK');
  EXCEPTION
    WHEN OTHERS THEN
      -- Ignore duplicate registrations
      NULL;
  END;

  EM_TARGET.ADD_TGT_PRE_DELETION_CALLBACK('EMD_BCN_ADMIN.BEACON_PRE_DELETE_CALLBACK',
                                           ' ',
                                           MGMT_GLOBAL.G_BEACON_TARGET_TYPE,
                                           0 );
  TBL_NAMES.EXTEND;
  TBL_NAMES(1) := 'MGMT_BCN_TARGET';
  MGMT_ADMIN.ADD_TARGET_DELETION_EXCEPTIONS(TBL_NAMES);
  TBL_NAMES.DELETE;
  COMMIT;
END;
/


DECLARE
BEGIN
  -- A separate repository patch is applied to handle 10.1.* OMS 
  -- and 10.2 agents or later. This patch creates Response/Status metrics 
  -- for webapps in 10.1.* repository. 
  -- Before we create Response/Status metrics for webapp type_meta_ver 3.0
  -- in 10.2, we should delete the Response/Status metrics created 
  -- on 10.1 OMS using the patch.   
  --  In the sql below, type_meta_ver is compared with '3.*' and '4.*' versions 
  -- to cover any future webapp versions. -- Rajagopal  6/14/05 

  DELETE 
    FROM MGMT_METRICS 
   WHERE target_type = MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE
     AND (type_meta_ver <> '1.0' AND type_meta_ver <> '2.0' )
     AND metric_name = MGMT_GLOBAL.G_AVAIL_METRIC_NAME;

  em_service.initialize_service_type(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE, FALSE, '3.0');

  MGMT_TARGET.add_target_type_property(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE,
                                       'IsBaselineable', 
                                       'true');

  -- Set the path to the resource bundle for the service
  UPDATE MGMT_TARGET_TYPES
     SET TYPE_RESOURCE_BUNDLE = 'oracle.sysman.resources.website'
   WHERE TARGET_TYPE = MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE;
  
  COMMIT;
END;
/

BEGIN
DECLARE

  PROCEDURE add_prop_def(p_service_type IN VARCHAR2, p_type_meta_ver IN VARCHAR2, p_property_name IN VARCHAR2)
  AS
  BEGIN
     dbms_output.put_line('adding props');
     BEGIN
        INSERT INTO mgmt_target_prop_defs(target_type, type_meta_ver,
                         property_name,
                         property_display_name, hidden_flag)
        VALUES(p_service_type, p_type_meta_ver, p_property_name, p_property_name, 1);
     EXCEPTION
        WHEN DUP_VAL_ON_INDEX THEN
            NULL;
     END;
  END; -- PROCEDURE add_prop_def

  PROCEDURE add_svc_prop_defs(p_service_type IN VARCHAR2, p_type_meta_ver IN VARCHAR2)
  AS
  BEGIN
     add_prop_def(p_service_type, p_type_meta_ver, EM_SERVICE.G_SVC_HP_USAGE_METRIC_NAME);
     add_prop_def(p_service_type, p_type_meta_ver, EM_SERVICE.G_SVC_HP_USAGE_METRIC_COL );
     add_prop_def(p_service_type, p_type_meta_ver, EM_SERVICE.G_SVC_HP_USAGE_KEY );
     add_prop_def(p_service_type, p_type_meta_ver, EM_SERVICE.G_SVC_HP_PERF_METRIC_NAME);
     add_prop_def(p_service_type, p_type_meta_ver, EM_SERVICE.G_SVC_HP_PERF_METRIC_COL );
     add_prop_def(p_service_type, p_type_meta_ver, EM_SERVICE.G_SVC_HP_PERF_KEY );
  END; --PROCEDURE add_svc_prop_defs

  BEGIN
     --add property def for website target
     add_svc_prop_defs(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE, '3.0');
     COMMIT;
  EXCEPTION
    WHEN OTHERS THEN
      ROLLBACK;
  END; -- for previous BEGIN block
END; --
/
show errors;

DECLARE
BEGIN
  EMD_BCN_ADMIN.GEN_BEACON_RESP_METRICS(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE, '2.0');
  EMD_BCN_ADMIN.GEN_BEACON_RESP_METRICS(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE, '1.0');
  COMMIT;
END;
/
SHOW ERRORS;

