Rem DO NOT ADD HEADER HERE, and DO NOT DELETE THIS FILE EITHER.  THIS FILE
Rem IS BEING REFERENCED FROM blackout_data_upgrade.sql
Rem
Rem $Header: blackout_post_creation.sql 19-jul-2005.13:35:04 chyu Exp $
Rem
Rem blackout_post_creation.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      blackout_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        07/19/05 - modifying the new rep manager header 
Rem    rpinnama    05/12/05 - Move usermodel callback registration to v102010 
Rem                           data upgrade 
Rem    paachary    03/08/05 - paachary_upgrdscrpts
Rem    paachary    03/04/05 - Created
Rem
DECLARE
   
    PROCEDURE add_reason(p_reason mgmt_blackout_reason.reason%TYPE)
    IS
        p_ignore   NUMBER;
        p_count    NUMBER;
    BEGIN
        SELECT count(*)
        INTO   p_count
        FROM   mgmt_blackout_reason
        WHERE
            reason = p_reason;
        
        IF (p_count = 0) THEN
            p_ignore := 
            mgmt_blackout.add_reason(p_reason);
        END IF;
    END add_reason;
    
    BEGIN
        add_reason('Added via emctl utility');
        add_reason('Apps: New Application Monitoring');
        add_reason('Apps: Application Decommissioning');
        add_reason('Apps: Application Configuration Change' );
        add_reason('Apps: Application Emergency');
        add_reason('Apps: Application Password Change');
        add_reason('Apps: Application Patch/Maintenance');
        add_reason('Apps: Application Upgrade');
        add_reason('Apps: Application Standardization');
        add_reason('SLB: Load Balancer Upgrade');
        add_reason('SLB: Load Balancer Emergency');
        add_reason('SLB: Load Balancer Configuration Change');
        add_reason('SLB: Load Balancer Patch/Maintenance');
        add_reason('AS: Application Server Configuration Change');
        add_reason('AS: Application Server Emergency');
        add_reason('AS: Application Server Patch/Maintenance');
        add_reason('AS: Application Server Upgrade');
        add_reason('AS: Application Server Bounce');
        add_reason('DB: Database Cold Backup');
        add_reason('DB: New Database Monitoring');
        add_reason('DB: Database Decommissioning');
        add_reason('DB: Database Configuration Change');
        add_reason('DB: Database Emergency');
        add_reason('DB: Database Password Change');
        add_reason('DB: Database Patch/Maintenance');
        add_reason('DB: Disaster Recovery Node');
        add_reason('DB: Database Refresh');
        add_reason('DB: Database Upgrade');
        add_reason('Hardware Configuration Change');
        add_reason('Hardware Emergency');
        add_reason('Hardware Patch/Maintenance');
        add_reason('Hardware Upgrade');
        add_reason('Hardware Failure');
        add_reason('Network Emergency');
        add_reason('Network Outage');
        add_reason('Network Patch/Maintenance');
        add_reason( 'Network Configuration Change');
        add_reason('Network Upgrade           ');
        add_reason('Network Hardware Failure');
        add_reason('Storage Filer Upgrade');
        add_reason( 'Security Patch');
        add_reason('Testing');
        add_reason('OS Configuration Change');
        add_reason( 'OS Emergency');
        add_reason('OS Patch/Maintenance');
        add_reason('OS Password Change');
        add_reason('OS Upgrade');
        add_reason('Server Bounce');
        add_reason('Server Decommissioning');
        add_reason('Server Physical Move');
        add_reason('Other: Customer Request');
        add_reason('EM: Agent Configuration Change');
        add_reason('EM: Agent Emergency');
        add_reason('EM: Agent Patch/Maintenance');
        add_reason('EM: Agent Upgrade');
        add_reason('EM: OMS Server Maintenance');
        add_reason('EM: OMS Server Configuration Change');
        add_reason('EM: OMS Server Emergency');
        add_reason('EM: OMS Server Patch/Maintenance');
        add_reason('EM: OMS Server Upgrade');
   COMMIT;
END;
/


-- register user model callbacks 
-- Also register target deletion callbacks for stopping relevant blackouts
BEGIN
  BEGIN
    MGMT_USER.add_callback('MGMT_BLACKOUT_ENGINE.grant_priv_callback',
                         MGMT_USER.PRIV_GRANTED_CALLBACK);
  EXCEPTION WHEN OTHERS THEN
    -- Ignore duplicate registration errors
    NULL;
  END;

  BEGIN
    MGMT_USER.add_callback('MGMT_BLACKOUT_ENGINE.revoke_priv_callback',
                           MGMT_USER.PRIV_REVOKED_CALLBACK);
  EXCEPTION WHEN OTHERS THEN
    -- Ignore duplicate registration errors
    NULL;
  END;

  BEGIN
    MGMT_USER.add_callback('MGMT_BLACKOUT_ENGINE.get_user_blackouts',
                         MGMT_USER.GET_USER_OBJECTS_CALLBACK);
  EXCEPTION WHEN OTHERS THEN
    -- Ignore duplicate registration errors
    NULL;
  END;

  BEGIN
    MGMT_USER.add_callback('MGMT_BLACKOUT_ENGINE.drop_user_blackouts',
                           MGMT_USER.USER_DROPPED_CALLBACK);
  EXCEPTION WHEN OTHERS THEN
    -- Ignore duplicate registration errors
    NULL;
  END;

  BEGIN
    MGMT_USER.add_callback('MGMT_BLACKOUT_ENGINE.check_reassign_user_blackouts',
                         MGMT_USER.CHECK_USER_REASSIGN_CALLBACK);
  EXCEPTION WHEN OTHERS THEN
    -- Ignore duplicate registration errors
    NULL;
  END;

  BEGIN
    MGMT_USER.add_callback('MGMT_BLACKOUT_ENGINE.reassign_user_blackouts',
                         MGMT_USER.USER_REASSIGN_CALLBACK);
  EXCEPTION WHEN OTHERS THEN
    -- Ignore duplicate registration errors
    NULL;
  END;

  BEGIN
    MGMT_ADMIN.add_target_deletion_callback('MGMT_BLACKOUT_ENGINE.clean_blk_on_tgt_del');
  EXCEPTION WHEN OTHERS THEN
    -- Ignore duplicate registration errors
    NULL;
  END;

  BEGIN
    -- Add assoc callbacks
    -- Callback for adding a target to a host
    MGMT_ASSOC.add_assoc_addition_callback('MGMT_BLACKOUT_ENGINE.host_change_callback',
                                         MGMT_ASSOC.ASSOC_DEF_HOSTED_BY);
  EXCEPTION WHEN OTHERS THEN
    -- Ignore duplicate registration errors
    NULL;
  END;

  BEGIN
    -- Callback to handle the case when a target is removed from a host as a result of
    -- of the target being relocated to another host. Note that this is different from
    -- a target being deleted from the system.
    MGMT_ASSOC.add_assoc_deletion_callback('MGMT_BLACKOUT_ENGINE.host_change_callback',
                                         MGMT_ASSOC.ASSOC_DEF_HOSTED_BY);
  EXCEPTION WHEN OTHERS THEN
    -- Ignore duplicate registration errors
    NULL;
  END;

  BEGIN
    -- Callbacks for adding/removing a target to/from a group
    MGMT_ASSOC.add_assoc_addition_callback('MGMT_BLACKOUT_ENGINE.group_change_callback',
                                           MGMT_ASSOC.ASSOC_DEF_CONTAINS);
  EXCEPTION WHEN OTHERS THEN
    -- Ignore duplicate registration errors
    NULL;
  END;

  BEGIN
    MGMT_ASSOC.add_assoc_deletion_callback('MGMT_BLACKOUT_ENGINE.group_change_callback',
                                           MGMT_ASSOC.ASSOC_DEF_CONTAINS);
  EXCEPTION WHEN OTHERS THEN
    -- Ignore duplicate registration errors
    NULL;
  END;

END;
/


