Rem DO NOT INSERT HEADER IN THIS FILE.  THIS FILE IS REFERENCED BY 
Rem chronos_data_upgrade_cond.sql DEPENDING ON THE CONDITIONS.
Rem
Rem $Header: chronos_data_upgrade.sql 18-jul-2005.17:39:12 chyu Exp $
Rem
Rem chronos_data_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      chronos_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    eporter     08/15/05 - Add missing entries to mgmt_target_rollup_times 
Rem    chyu        07/18/05 - updating the new rep manager header 
Rem    eporter     05/02/05 - Bug 4339496 - Run add_bootstrap_time on targets 
Rem    eporter     03/02/05 - eporter_bug-4204264
Rem    eporter     02/28/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

DECLARE
  rows INTEGER := 0;
BEGIN 

  FOR i IN (SELECT target_guid from mgmt_targets )
    LOOP
      BEGIN
        INSERT INTO MGMT_TARGET_ROLLUP_TIMES
            ( TARGET_GUID, ROLLUP_TABLE_NAME, ROLLUP_TIMESTAMP ) 
         VALUES
            (i.target_guid, 'MGMT_RT_PR_MAPPING_1HOUR', TO_DATE('01-01-1900', 'MM-DD-YYYY'));
        INSERT INTO MGMT_TARGET_ROLLUP_TIMES
            ( TARGET_GUID, ROLLUP_TABLE_NAME, ROLLUP_TIMESTAMP ) 
         VALUES
            (i.target_guid, 'MGMT_RT_PR_MAPPING_1DAY', TO_DATE('01-01-1900', 'MM-DD-YYYY'));
        INSERT INTO MGMT_TARGET_ROLLUP_TIMES
            ( TARGET_GUID, ROLLUP_TABLE_NAME, ROLLUP_TIMESTAMP ) 
         VALUES
            (i.target_guid, 'MGMT_RT_INCOMPLETE_LOADS_1HOUR', TO_DATE('01-01-1900', 'MM-DD-YYYY'));
        INSERT INTO MGMT_TARGET_ROLLUP_TIMES
            ( TARGET_GUID, ROLLUP_TABLE_NAME, ROLLUP_TIMESTAMP ) 
         VALUES
            (i.target_guid, 'MGMT_RT_INCOMPLETE_LOADS_1DAY', TO_DATE('01-01-1900', 'MM-DD-YYYY'));
        INSERT INTO MGMT_RT_BOOTSTRAP_TIMES
            ( TARGET_GUID, ROLLUP_TIMESTAMP ) 
         VALUES
            (i.target_guid, TO_DATE('01-01-1900', 'MM-DD-YYYY'));

        rows := rows + 1;
        IF(MOD(rows, 200) = 0) THEN
          COMMIT;
        END IF;

      EXCEPTION
        WHEN DUP_VAL_ON_INDEX THEN
          -- Ignore duplicates
          NULL;
      END;
    END LOOP;

  mgmt_log.register_logging_module ('RTBOOTSTRAPROLLUP','End User Bootstrap Rollup','EMD_RT_ROLLUP.BOOTSTRAP_ROLLUP()');
  mgmt_log.register_logging_module ('RTROLLUP PR MAPPING 1HOUR');
  mgmt_log.register_logging_module ('RTROLLUP PR MAPPING 1HOUR PURGE');
  mgmt_log.register_logging_module ('RTROLLUP PR MAPPING 1DAY');
  mgmt_log.register_logging_module ('RTROLLUP PR MAPPING 1DAY PURGE');
  mgmt_log.register_logging_module ('RTROLLUP INCOMPLETE LOADS 1HOUR');
  mgmt_log.register_logging_module ('RTROLLUP INCOMPLETE LOADS 1HOUR PURGE');
  mgmt_log.register_logging_module ('RTROLLUP INCOMPLETE LOADS 1DAY');
  mgmt_log.register_logging_module ('RTROLLUP INCOMPLETE LOADS 1DAY PURGE');
  mgmt_log.register_logging_module ('RTBOOTSTRAPROLLUP URL');
  mgmt_log.register_logging_module ('RTBOOTSTRAPROLLUP URL DIST');
  mgmt_log.register_logging_module ('RTBOOTSTRAPROLLUP DOMAIN');
  mgmt_log.register_logging_module ('RTBOOTSTRAPROLLUP DOMAIN DIST');
  mgmt_log.register_logging_module ('RTBOOTSTRAPROLLUP IP');
  mgmt_log.register_logging_module ('RTBOOTSTRAPROLLUP IP DIST');
END;
/
