Rem drv: <migrate type="data_upgrade" version="10.2.0.0" pos="blackout_data_upgrade.sql+"/>
Rem
Rem $Header: collections_data_upgrade.sql 26-jul-2005.19:28:50 chyu Exp $
Rem
Rem collections_data_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      collections_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        07/26/05 - modifying the migrate header position 
Rem    chyu        07/18/05 - updating the new rep manager header 
Rem    rpinnama    05/13/05 - 
Rem    jsadras     05/12/05 - Bug:4365714
Rem    jsadras     04/26/05 - Remove task types and add default worker support
Rem    rpinnama    05/12/05 - Resume collections only for repository metrics 
Rem    jsadras     02/21/05 - added callback additions/register modules 
Rem    jsadras     02/09/05 - start collections
Rem    rpinnama    02/06/05 - rpinnama_add_upgrade_scripts
Rem    rpinnama    02/02/05 - Created
Rem


--
-- Register the module for error logging
-- 
BEGIN
  mgmt_log.register_logging_module (MGMT_COLLECTION.G_MODULE_NAME,
                                    'Repository Metrics',
                                    'EM_TASK.WORKER');

  mgmt_log.register_logging_module (EM_METRIC_EVAL.G_MODULE_NAME,
                                    'Metric Evaluation') ;

  mgmt_log.register_logging_module (EM_POLICY_EVAL.G_MODULE_NAME,
                                    'Policy Evaluation') ;
                                    
  COMMIT;
END;
/

-- Add target addition callback
BEGIN
  mgmt_admin.add_target_addition_callback('mgmt_collection.start_default_collection') ;
END;
/

-- Add target delete exceptions
BEGIN
  INSERT INTO mgmt_target_delete_exceptions values ('MGMT_COLLECTION_METRIC_TASKS') ;
  COMMIT;
END ;
/

-- Add pre-target delete callbacks
BEGIN
  em_target.add_tgt_pre_deletion_callback('em_coll_util.handle_target_delete');
  COMMIT;
END;
/

--Start collections      
BEGIN
  FOR rec IN ( SELECT DISTINCT  
                                t.target_type,
                                t.target_name,
                                m.metric_name,
                                m.metric_column,
                                tasks.coll_name
                 FROM mgmt_collections coll,
                      mgmt_collection_metric_tasks tasks,
                      mgmt_targets t,
                      mgmt_metrics m
                WHERE coll.is_enabled = 2 AND
                      coll.object_guid = tasks.target_guid AND
                      coll.object_type = 2                    AND
                      coll.coll_name = tasks.coll_name       AND
                      t.target_guid = tasks.target_guid AND
                      m.metric_guid = tasks.metric_guid AND
                      m.target_type = t.target_type AND
                      m.type_meta_ver = t.type_meta_ver AND
                      (m.category_prop_1 = t.category_prop_1 OR m.category_prop_1 = ' ') AND
                      (m.category_prop_2 = t.category_prop_2 OR m.category_prop_2 = ' ') AND
                      (m.category_prop_3 = t.category_prop_3 OR m.category_prop_3 = ' ') AND
                      (m.category_prop_4 = t.category_prop_4 OR m.category_prop_4 = ' ') AND
                      (m.category_prop_5 = t.category_prop_5 OR m.category_prop_5 = ' ') AND
                      (m.is_repository = 1 or m.metric_type IN (5, 6, 7) ) AND
                      tasks.task_id IS NULL) 
  LOOP
    -- Resume only repository collections
    MGMT_COLLECTION.resume_collection
      (p_target_type=>rec.target_type,
       p_target_name=>rec.target_name,
       p_metric_name=>rec.metric_name,
       p_metric_column=>rec.metric_column,
       p_coll_name=>rec.coll_name) ;
  END LOOP ;

  UPDATE mgmt_collections
     SET is_enabled=1
   WHERE is_enabled=2 ;

  COMMIT ;
EXCEPTION
 -- temporarily catching exeptions until all other
 -- upgrade scripts are checked in, this is dependent on 
 -- mgmt_jobs compiling successfully
WHEN OTHERS THEN  NULL ;
END ;
/

-- default number of workers to 1 for short running
-- and 1 for long running tasks
BEGIN
  mgmt_collection.set_worker_count(EM_TASK.G_TASK_CLASS_SHORT_RUNNING,1);
  mgmt_collection.set_worker_count(EM_TASK.G_TASK_CLASS_LONG_RUNNING,1);
  COMMIT ;
END ;
/

