Rem drv: <migrate type="data_upgrade" version="10.2.0.0" pos="group/group_data_upgrade.sql+"/>
Rem
Rem $Header: credentials_data_upgrade.sql 08-sep-2005.16:18:32 dsahrawa Exp $
Rem
Rem credentials_data_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      credentials_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       dsahrawa 09/08/05 - fix for 4586117 is in credentials, rollback
Rem                           previous fix
Rem       dsahrawa 09/01/05 - bug 4586117, do not insert ref creds if the 
Rem                           target_type is host 
Rem       chyu     07/26/05 - modifying the migrate header position 
Rem       chyu     07/18/05 - updating the new rep manager header 
Rem       rzazueta 06/13/05 - Add table to delete exceptions 
Rem       dcawley  06/13/05 - Remove duplicate callback registration 
Rem       skini    02/16/05 - skini_job_bo_migration
Rem

-- register user model callbacks for user deletion
BEGIN
    -- for jobs
    MGMT_USER.add_callback('EM_CREDENTIAL.user_reassigned',
                           MGMT_USER.USER_REASSIGN_CALLBACK);
    
END;
/
COMMIT;

-- Add table as a delete exception.
BEGIN
DECLARE del_exceptions SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN
    -- Add deletion exceptions here
    del_exceptions.extend(1);
    del_exceptions(1) := 'MGMT_COLLECTION_TEMPLATE_CREDS';
    MGMT_ADMIN.add_target_deletion_exceptions(del_exceptions);
END;
END;
/

-- Insert host credentials, if required for all agent-monitored
-- target types
DECLARE
l_target_name MGMT_TARGETS.target_name%TYPE;
l_target_type MGMT_TARGETS.target_type%TYPE;
l_target_guid MGMT_TARGETS.target_guid%TYPE;
BEGIN

    FOR crec IN (SELECT DISTINCT target_type
                 FROM   MGMT_TARGETS
                 WHERE  emd_url like '%http%') LOOP
        SELECT  target_name, target_type, target_guid
        INTO    l_target_name, l_target_type, l_target_guid
        FROM    MGMT_TARGETS
        WHERE   target_type=crec.target_type
        AND     ROWNUM=1;

        EM_CREDENTIAL.add_host_credential_info(l_target_name,
                                               l_target_type,
                                               l_target_guid);
    END LOOP;
END;
/
COMMIT;
