Rem drv: <migrate type="schema_upgrade" version="10.2.0.0" pos="jobs/jobs_schema_upgrade.sql+"/> 
Rem
Rem $Header: data_propagation_schema_upgrade.sql 25-jul-2005.13:51:42 chyu Exp $
Rem
Rem data_propagation_schema_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      data_propagation_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        07/25/05 - modifying the upgrade header 
Rem    chyu        07/18/05 - modify the version number for the header 
Rem    rzazueta    06/20/05 - Add index to mgmt_update_operations_details 
Rem    rzazueta    05/04/05 - Add new columns to 
Rem                           mgmt_update_operations_details 
Rem    skini       03/15/05 - skini_bug-4187366
Rem    eujang      03/10/05 - eujang_rep_upgrade_debug
Rem    eujang      03/02/05 - Created
Rem


rem
rem MGMT_UPDATE_COLL_CREDS_DATA
rem
rem PURPOSE
rem   Stores update data for the credentials data set.
rem
rem COLUMNS
rem   DATA_SET_GUID   - Identifies update data for a particular update 
rem                     job; used to join this table with 
rem                     MGMT_UPDATE_OPERATIONS_DATA
rem
CREATE TABLE MGMT_UPDATE_COLL_CREDS_DATA
    (data_set_guid           RAW(16)          NOT NULL,
     metric_guid             RAW(16)          NOT NULL,
     collection_name         VARCHAR2(64),
     credential_set_name     VARCHAR2(64)     NOT NULL,
     credential_column       VARCHAR2(32)     NOT NULL,
     credential_value        VARCHAR2(1024)
    ) MONITORING;




rem
rem MGMT_UPDATE_TEMPLATE_DATA_MAP
rem
rem PURPOSE
rem   Stores the mapping of data_set_guid to template_copy_guid.
rem
rem COLUMNS
rem   DATA_SET_GUID - Identifies data for a particular data propagation job
rem   TEMPLATE_COPY_GUID - GUID of the template copy
rem
CREATE TABLE MGMT_UPDATE_TEMPLATE_DATA_MAP
    (data_set_guid           RAW(16)          NOT NULL,
     template_copy_guid      RAW(16)          NOT NULL
    ) MONITORING; 

Rem
Rem Indexes for MGMT_UPDATE_TEMPLATE_DATA_MAP table
Rem
ALTER TABLE MGMT_UPDATE_TEMPLATE_DATA_MAP
    ADD CONSTRAINT PK_MGMT_UPD_TEMPLATE_DATA
        PRIMARY KEY(data_set_guid);

ALTER TABLE MGMT_UPDATE_OPERATIONS MODIFY (job_owner VARCHAR2(256));

ALTER TABLE MGMT_UPDATE_OPERATIONS_DETAILS 
ADD(
     last_updated_timestamp     DATE            DEFAULT NULL,
     error_message              VARCHAR2(4000)  DEFAULT ''
);

Rem
Rem Indexes for MGMT_UPDATE_OPERATIONS_DETAILS table
Rem
CREATE INDEX MGMT_UPDATE_OPS_DETAILS_IDX01
  ON MGMT_UPDATE_OPERATIONS_DETAILS(destination_target_guid);

CREATE INDEX MGMT_UPDATE_OPS_DETAILS_IDX02
  ON MGMT_UPDATE_OPERATIONS_DETAILS(execution_id, destination_target_guid, execution_status);

CREATE INDEX MGMT_UPDATE_OPS_DETAILS_IDX03
  ON MGMT_UPDATE_OPERATIONS_DETAILS(execution_id, execution_status);

