Rem
Rem $Header: ecm_hostpatch_indexes.sql 14-feb-2005.04:59:39 gsbhatia Exp $
Rem
Rem ecm_hostpatch_indexes.sql
Rem
Rem Copyright (c) 2005, Oracle.  All rights reserved.  
Rem
Rem    NAME
Rem      ecm_hostpatch_indexes.sql - Indexes for Host Patching tables.
Rem
Rem    DESCRIPTION
Rem      Indexes for Host Patching tables.
Rem
Rem    NOTES
Rem      None.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    02/14/05 - Removing header 
Rem    ranmath     02/10/05 - Created
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    ranmath     12/08/04 - bug-4053039: Do not use TARGET_GUID in column 
Rem                           names. 
Rem    ranmath     12/03/04 - (bug-4046371) Update indexes for the new column 
Rem                           names. 
Rem    ranmath     09/10/04 - Created
Rem

rem
rem Index for the Group Target GUID foreign key in the Hosts table.
rem
CREATE INDEX mgmt_ecm_hp_host_group_idx
  ON mgmt_ecm_hostpatch_hosts(group_guid);

rem
rem Index for the packages repository GUID foreign key in
rem packages repository available packages table.
rem
CREATE INDEX mgmt_ecm_hp_pkg_repos_idx
  ON mgmt_ecm_hostpatch_repos_pkgs(repos_guid);

rem
rem Indexes for the Group Target GUID and packages repository GUID foreign
rem keys respectively in Group packages repository relationship table.
rem
CREATE INDEX mgmt_ecm_hp_gr_group_idx
  ON mgmt_ecm_hostpatch_group_repos(group_guid);
CREATE INDEX mgmt_ecm_hp_gr_repos_idx
  ON mgmt_ecm_hostpatch_group_repos(repos_guid);

rem
rem Index for Host Target GUID foreign key in the Host compliance
rem information table.
rem
CREATE INDEX mgmt_ecm_hp_compl_host_idx
  ON mgmt_ecm_hostpatch_host_compl(host_guid);

rem
rem Index for Group Target GUID foreign key in Group compliance history table.
rem
CREATE INDEX mgmt_ecm_hp_compl_group_idx
  ON mgmt_ecm_hostpatch_compl_hist(group_guid);

