Rem
Rem $Header: create_cpf_policy.sql 02-mar-2005.04:10:11 mningomb Exp $
Rem
Rem create_cpf_policy.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      create_cpf_policy.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mningomb      12/15/04 - mningomb_cpf_policy
Rem    mningomb      10/08/04 - Created
Rem
DECLARE
   --Metric related variables
   l_metricColList     MGMT_METRIC_COLUMN_ARRAY; 
   l_metric_type       NUMBER;
   l_snapshot_list     MGMT_SNAPSHOT_ARRAY; 
  --Policy related variables
   l_category_list MGMT_CATEGORY_ARRAY; 
   l_ctxList MGMT_VIOL_CTXT_DEF_ARRAY; 
   l_defaultSettingsList MGMT_POLICY_KEY_VAL_ARRAY; 
BEGIN
  l_metric_type := MGMT_GLOBAL.G_METRIC_TYPE_TABLE;
  l_snapshot_list := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type => 'host',
                p_snapshot_name => 'Inventory'));

  l_metricColList := MGMT_METRIC_COLUMN_ARRAY(

                           MGMT_METRIC_COLUMN_OBJ.NEW(
                            p_column_name => 'HOME_LOCATION',
                            p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
                            p_is_key => MGMT_GLOBAL.G_TRUE,  
                            p_column_label => 'Home location',         
                            p_column_label_nlsid =>'CPF_HOME_LOCATION_NLSID'),

                           MGMT_METRIC_COLUMN_OBJ.NEW(
                            p_column_name => 'ADVISORY_NAME',
                            p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
                            p_is_key => MGMT_GLOBAL.G_TRUE,  
                            p_column_label => 'Advisory',         
                            p_column_label_nlsid =>'CPF_ADVISORY_NAME_NLSID'), 
                           
                           MGMT_METRIC_COLUMN_OBJ.NEW(
                            p_column_name => 'IMPACT',
                            p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
                            p_is_key => MGMT_GLOBAL.G_FALSE,  
                            p_column_label => 'Impact',         
                            p_column_label_nlsid =>'CPF_IMPACT_NLSID'), 
                           
                           MGMT_METRIC_COLUMN_OBJ.NEW(
                            p_column_name => 'PATCHES',
                            p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
                            p_is_key => MGMT_GLOBAL.G_FALSE,  
                            p_column_label => 'Patches',         
                            p_column_label_nlsid =>'CPF_PATCHES_NLSID'), 
                           
                           MGMT_METRIC_COLUMN_OBJ.NEW(
                            p_column_name => 'ADVISORY_ABSTRACT',
                            p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
                            p_is_key => MGMT_GLOBAL.G_FALSE,  
                            p_column_label => 'Abstract',         
                            p_column_label_nlsid =>'CPF_ADVISORY_ABSTRACT_NLSID'), 

                           
                           MGMT_METRIC_COLUMN_OBJ.NEW(
                            p_column_name => 'HOME_LOCATION_DISPLAY',
                            p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
                            p_is_key => MGMT_GLOBAL.G_FALSE,  
                            p_column_label => 'Home location',        
                            p_column_label_nlsid =>'CPF_HOME_LOCATION_DISPLAY_NLSID'), 
                           
                                                      
                           MGMT_METRIC_COLUMN_OBJ.NEW(
                            p_column_name => 'HOST_NAME',
                            p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
                            p_is_key => MGMT_GLOBAL.G_TRUE,  
                            p_column_label => 'Host name',         
                            p_column_label_nlsid =>'CPF_HOST_NAME_NLSID'), 
                           
                           MGMT_METRIC_COLUMN_OBJ.NEW(
                            p_column_name => 'ADVISORY_URL',
                            p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
                            p_is_key => MGMT_GLOBAL.G_FALSE,  
                            p_column_label => 'Advisory URL',
                            p_column_label_nlsid =>'CPF_ADVISORY_URL_NLSID'), 
                           
                           MGMT_METRIC_COLUMN_OBJ.NEW(
                            p_column_name => 'PATCH_GUIDS',
                            p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
                            p_is_key => MGMT_GLOBAL.G_FALSE,  
                            p_column_label => 'Patch GUIDs',     
                            p_column_label_nlsid =>'CPF_PATCH_GUIDS_NLSID')

                       ); 
    MGMT_TARGET.REGISTER_TARGET_TYPE(
                   p_target_type_in => 'host',
                   p_type_meta_ver_in => CPF_POLICY.HOST_TYPE_META_VERSION,
                   p_type_display_name_in => 'Host',
                   p_type_display_nlsid_in => 'host_name',
                   p_type_resource_bundle_in => MGMT_TARGET.G_DEFAULT_RESOURCE_BUNDLE);

    MGMT_METRIC.CREATE_METRIC(
                  p_target_type         => 'host',
                  p_metric_name         => 'critcal_patch_advisories_metric',
                  p_type_meta_ver       => CPF_POLICY.HOST_TYPE_META_VERSION,
                  p_valid_if_list       => NULL,
                  p_metric_type         => l_metric_type,
                  p_metric_label        => 'Critcal patch advisories metric',
                  p_metric_label_nlsid  => 'CPF_METRIC_NLSID',
                  p_description         => 'Critical Patch Advisories for Oracle Homes',
                  p_description_nlsid   => 'CPF_METRIC_DESC_NLSID',
                  p_short_name          => 'CPF metric ',
                  p_short_name_nlsid    => 'CPF_METRIC_SNAME_NLSID',
                  p_is_repository       => MGMT_GLOBAL.G_TRUE,
                  p_author              => 'ORACLE',
                  p_source_type         => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
                  p_source              => 'select HOME_LOCATION, ADVISORY_NAME, IMPACT, PATCHES , ADVISORY_ABSTRACT, HOME_LOCATION_DISPLAY,  HOST_NAME, ADVISORY_URL,  PATCH_GUIDS, TARGET_GUID  from TABLE(CPF_POLICY.CPF_QUERY)',
                  p_snapshot_name_list  => l_snapshot_list,
                  p_metric_column_list  => l_metricColList 
      );
 COMMIT;

   l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
                 MGMT_VIOL_CTXT_DEF.NEW(
                      p_metric_column => 'ADVISORY_NAME',
                      p_url_link_template => '^ADVISORY_URL^'
                   ), 
                 MGMT_VIOL_CTXT_DEF.NEW(
                      p_metric_column => 'IMPACT'
                   ), 
                 MGMT_VIOL_CTXT_DEF.NEW(
                      p_metric_column => 'PATCHES',
                      p_url_link_template => 'ecm/patch/critical/patchAdvisoriesCriticalPatch$guid=^PATCH_GUIDS^$host=^HOST_NAME^$dir=^HOME_LOCATION^?event=getMultiListOfOracleHomes',
                    p_url_link_type => MGMT_POLICY.G_URL_TYPE_UIX
                   ), 
                 MGMT_VIOL_CTXT_DEF.NEW(
                      p_metric_column => 'ADVISORY_ABSTRACT'
                   ), 
                 MGMT_VIOL_CTXT_DEF.NEW(
                      p_metric_column => 'HOME_LOCATION_DISPLAY',
                      p_url_link_template => 'ecm/track/view/oracleHome$target=^HOST_NAME^$type=host$location=^HOME_LOCATION^?event=doLoad',
                    p_url_link_type => MGMT_POLICY.G_URL_TYPE_UIX
                   ), 
                 MGMT_VIOL_CTXT_DEF.NEW(
                      p_metric_column => 'HOME_LOCATION',
                      p_is_hidden => MGMT_GLOBAL.G_TRUE
                   ), 
                 MGMT_VIOL_CTXT_DEF.NEW(
                      p_metric_column => 'HOST_NAME',
                      p_is_hidden => MGMT_GLOBAL.G_TRUE
                   ), 
                 MGMT_VIOL_CTXT_DEF.NEW(
                      p_metric_column => 'ADVISORY_URL',
                      p_is_hidden => MGMT_GLOBAL.G_TRUE
                   ), 
                 MGMT_VIOL_CTXT_DEF.NEW(
                      p_metric_column => 'PATCH_GUIDS',
                      p_is_hidden => MGMT_GLOBAL.G_TRUE
                   )
              ); 

   l_category_list := 
               MGMT_CATEGORY_ARRAY(
                   MGMT_CATEGORY_OBJ.NEW('Functional', 'Configuration')
               ); 

   l_defaultSettingsList := 
               MGMT_POLICY_KEY_VAL_ARRAY(MGMT_POLICY_KEY_VAL.NEW(
                 p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL)
               );

   mgmt_policy.CREATE_POLICY(
          p_target_type     => 'host',
          p_policy_name     => 'Critical Patch Advisories for Oracle Homes',
          p_metric_name     => 'critcal_patch_advisories_metric',
          p_author          => 'ORACLE',
          p_policy_label_nlsid     => 'CPF_POLICY_NAME',
          p_description     => 'Checks Oracle Homes for missing critical patches',
          p_description_nlsid   => 'CPF_POLICY_DESC',
          p_impact     => 'To help ensure a secure and reliable configuration, all relevant and current critical patches should be applied.  Vulnerabilities have been identified for the following critical patch advisories.',
          p_impact_nlsid     => 'CPF_POLICY_IMPACT',
          p_recommendation     => 'Apply one of the identified patches for each critical patch advisory.',
          p_recommendation_nlsid     => 'CPF_POLICY_RECOM',
          p_violation_level     => MGMT_GLOBAL.G_SEVERITY_CRITICAL,
          p_condition_type     => MGMT_GLOBAL.G_CONDITION_SQL,
          p_condition     => 'rownum > 0',
          p_auto_enable => MGMT_GLOBAL.G_TRUE,
          p_message     => 'Your host is vulnerable to advisory %ADVISORY_NAME%. Certain critical patch or patchset are applicable to it.',
          p_message_nlsid  => 'CPF_MESSAGE_NLSID',
          p_category_list => l_category_list,
          p_dflt_param_val_list     => l_defaultSettingsList ,
          p_viol_ctxt_list     => l_ctxList
   );
  COMMIT;
END;
/
show errors;
