Rem
Rem $Header: gensvc_types.sql 30-aug-2005.12:17:02 chyu Exp $
Rem
Rem gensvc_types.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      gensvc_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        08/30/05 - 
Rem    rmarripa    07/21/05 - change componenet type 
Rem    rmarripa    12/24/04 - rmarripa_webapp_upgrade_changes
Rem    rmarripa    09/13/04 - Created
Rem

-- If the agg_met_type metric is a system based metric(1) then 
-- dep_comp_metric_list will have list of dependency metrics,  
-- if the agg_met_type is a test based metric then dep_test_metric_list 
-- will have list of dependency metrics. At any time, one of these
-- members should be null.  
-- agg_met_type will be either system based (1) or test based(2). 
CREATE OR REPLACE TYPE mgmt_svc_agg_metric_dep AS OBJECT
(
    agg_met_type             NUMBER, 
    dep_sys_metric_list      MGMT_METRIC_INSTANCE_ARRAY,
    dep_test_metric_key_list MGMT_BCN_THRESHOLD_KEY_ARRAY,
    test_metric_key_type     NUMBER, 
    eval_func                VARCHAR2(256)
);
/

CREATE OR REPLACE TYPE mgmt_svc_agg_met_thresh_inst AS OBJECT
(
    source_metric          MGMT_METRIC_INSTANCE, 
    metric_category        VARCHAR2(256), 
    metric_deps            MGMT_SVC_AGG_METRIC_DEP, 
    crit_threshold         VARCHAR2(256),
    warn_threshold         VARCHAR2(256),
    key_operator           NUMBER
);
/

CREATE OR REPLACE TYPE mgmt_svc_agg_met_thr_array AS 
        TABLE OF mgmt_svc_agg_met_thresh_inst;
/

CREATE OR REPLACE TYPE MGMT_GENSVC_GUID_ARRAY IS TABLE OF RAW(16);
/

CREATE OR REPLACE TYPE MGMT_GENSVC_OBJID_ARRAY IS TABLE OF VARCHAR2(32);
/

CREATE OR REPLACE TYPE MGMT_GENSVC_TGT_NAME_ARRAY IS TABLE OF VARCHAR2(512);
/

CREATE OR REPLACE TYPE MGMT_GENSVC_VAR_NAME_ARRAY IS TABLE OF VARCHAR2(512);
/

Rem 
Rem txn_add: 0 = remove, non-zero = add
Rem 
CREATE OR REPLACE TYPE MGMT_GENSVC_UBJOB_TEST AS OBJECT
  (
     test_name    VARCHAR2(256),
     test_type    VARCHAR2(64),
     test_guid    VARCHAR2(32),
     avail_test   NUMBER,
     add_test     NUMBER
  );
/

CREATE OR REPLACE TYPE MGMT_GENSVC_UBJOB_TEST_ARRAY AS 
        TABLE OF MGMT_GENSVC_UBJOB_TEST;
/

CREATE OR REPLACE TYPE MGMT_GENSVC_UBJOB_JOB AS OBJECT
  (
     beacon_name VARCHAR2(256),
     job_id      VARCHAR2(32)
  );
/

CREATE OR REPLACE TYPE MGMT_GENSVC_UBJOB_JOB_ARRAY AS 
        TABLE OF MGMT_GENSVC_UBJOB_JOB;
/

CREATE OR REPLACE TYPE MGMT_GENSVC_TMPL_BCN AS OBJECT
  (
     target_guid   VARCHAR2(32),
     target_name   VARCHAR2(256),
     avail_beacon  NUMBER
  );
/

CREATE OR REPLACE TYPE MGMT_GENSVC_TMPL_BCN_ARRAY AS 
        TABLE OF MGMT_GENSVC_TMPL_BCN;
/

CREATE OR REPLACE TYPE MGMT_GENSVC_TMPL_VAR AS OBJECT
  (
     name            VARCHAR2(512),
     default_value   VARCHAR2(4000)
  );
/

CREATE OR REPLACE TYPE MGMT_GENSVC_TMPL_VAR_ARRAY AS 
        TABLE OF MGMT_GENSVC_TMPL_VAR;
/

CREATE OR REPLACE TYPE MGMT_GENSVC_TXN_INST AS OBJECT
  (
   tgt_id                  VARCHAR2(32),
   txn_defn_with_props     MGMT_BCN_TXN_WITH_PROPS,
   steps_defn_with_props   MGMT_BCN_STEP_WITH_PROPS_ARRAY,
   rm_steps                MGMT_BCN_STEPID_ARRAY,
   stepgroups_defn         MGMT_BCN_STEPGROUP_ARRAY,
   rm_stepgroups           MGMT_BCN_STEPGROUPID_ARRAY,
   txn_thresholds          MGMT_BCN_THRESHOLD_ARRAY,
   step_thresholds         MGMT_BCN_THRESHOLD_ARRAY,
   stepgroup_thresholds    MGMT_BCN_THRESHOLD_ARRAY
  );
/

CREATE OR REPLACE TYPE MGMT_GENSVC_TXN_INST_ARRAY AS 
        TABLE OF MGMT_GENSVC_TXN_INST;
/

CREATE OR REPLACE TYPE COMPONENT AS OBJECT (
  target_guid RAW(16),
  target_name VARCHAR2(256),
  target_type VARCHAR2(64),
  current_status NUMBER,
  service_tz VARCHAR2(64),
  target_tz VARCHAR2(64),
  start_time DATE,
  end_time DATE
);
/

CREATE OR REPLACE TYPE COMPONENT_ARRAY AS TABLE of COMPONENT;
/
----------------------------------------------------------------
-- Service and Test Availabilty
----------------------------------------------------------------

CREATE OR REPLACE TYPE MGMT_GENSVC_AV_TEST AS OBJECT
  ( 
    test_name VARCHAR2(64),
    test_type VARCHAR2(64),
    metric_name VARCHAR2(64),
    metric_column VARCHAR2(64),
    avail_test NUMBER,
    monit_status NUMBER
  );
/

CREATE OR REPLACE TYPE MGMT_GENSVC_AV_TEST_ARRAY AS
        TABLE OF MGMT_GENSVC_AV_TEST;
/
