Rem drv: <migrate type="pre_data_upgrade" version="10.2.0.0" pos="esm/esm_post_creation.sql+"/>
Rem
Rem $Header: group_post_creation.sql 24-aug-2005.11:27:09 paachary Exp $
Rem
Rem group_post_creation.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      group_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    paachary    08/24/05 - Removing the property of REDUNDANCY GROUP target type 
Rem                           from is_group. Refer bug 4567883.
Rem    chyu        07/19/05 - modifying the new rep manager header 
Rem    rkpandey    05/17/05 - move register system type to system_common_init.sql 
Rem    pmodi       04/19/05 - Remove DB metric creation 
Rem    eujang      03/10/05 - debug
Rem    eujang      03/08/05 - fix compile problem 
Rem    pmodi       02/21/05 - add is_aggregate prop for group/composite and
Rem                           create req metrics of oracle db for group data upgrade
Rem    pmodi       02/17/05 - pmodi_em_group_migration1
Rem    pmodi       02/16/05 - Created
Rem

DECLARE
 
  l_type_properties SMP_EMD_NVPAIR_ARRAY;

BEGIN

  -- Redundancy Group target type
  l_type_properties := SMP_EMD_NVPAIR_ARRAY (
           SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DERIVED_STATUS_PROP, '0'),
           SMP_EMD_NVPAIR(MGMT_GLOBAL.G_IS_CLUSTER_PROP, '1'),
           SMP_EMD_NVPAIR(MGMT_GLOBAL.G_IS_COMPOSITE_PROP, '1'),
           SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISALLOW_REDUNDANCY_GROUP, '1') );

   MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE,
                                    'Redundancy Group', 'redundancy_group_name',
                                    l_type_properties);
  l_type_properties.DELETE;

END;
/

-- initialization for group types..
BEGIN
  -- Registering default metrics for group
  EM_GROUPS_UI.initialize_group_type(MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE);
  EM_GROUPS_UI.initialize_group_type(MGMT_GLOBAL.G_GENERIC_SYSTEM_TYPE);
  EM_GROUPS_UI.initialize_group_type(MGMT_GLOBAL.G_COMPOSITE_TARGET_TYPE);
  COMMIT;
END;
/

-- Add is_aggregate property for group/composite
BEGIN
  MERGE
   INTO mgmt_type_properties p
  USING (SELECT DISTINCT target_type target_type, 'is_aggregate' prop_name, '1' prop_value
           FROM mgmt_type_properties
          WHERE property_name = 'is_group'
             OR property_name = 'is_composite'
        )a
     ON (p.target_type = a.target_type and p.property_name = a.prop_name )
   WHEN MATCHED THEN
     UPDATE SET p.property_value = 1
   WHEN NOT MATCHED THEN
     INSERT (target_type, property_name, property_value)
     VALUES (a.target_type, a.prop_name, a.prop_value) ;

  COMMIT;
END;
/

