Rem
Rem $Header: dashboard_service_outofbox_reports.sql 26-jul-2005.06:20:34 tjana Exp $
Rem
Rem dashboard_service_outofbox_reports.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      dashboard_service_outofbox_reports.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    tjana       07/26/05 - delete rpt before creation 
Rem    lgloyd      06/22/05 - normalize category names 
Rem    mkm         06/03/05 - mkm_t0519
Rem    mkm         06/02/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

BEGIN
 
  DECLARE 
    l_target_types  MGMT_IP_TARGET_TYPES;
    l_service_types MGMT_IP_TARGET_TYPES;
    l_param_classes MGMT_IP_PARAM_CLASSES;
    l_param_values  MGMT_IP_PARAM_VALUE_LIST;
    l_targets       MGMT_IP_TARGET_LIST;
    l_report_guid   RAW(16);
    l_element_guid  RAW(16);
    l_index         NUMBER;

    CURSOR servicesCursor IS
      SELECT TARGET_TYPE 
      FROM mgmt_type_properties 
      WHERE PROPERTY_NAME ='is_service' and property_value=1;

  BEGIN

    -- -------------------------------------------------------------------------
    -- Element Type Definitions
    -- -------------------------------------------------------------------------    
    l_target_types := MGMT_IP_TARGET_TYPES();
    l_index := 0;
    l_service_types := MGMT_IP_TARGET_TYPES();
    
    
      FOR record IN servicesCursor
      LOOP
         l_index := l_index + 1;
	 l_target_types.extend(1);
         l_target_types(l_index) := record.TARGET_TYPE;
	 l_service_types.extend(1);
	 l_service_types(l_index) := record.TARGET_TYPE;
      END LOOP;
    
   
    mgmt_ip.add_element_type(
      p_element_type_nlsid  => 'SVC_DASH_SERVICE_TYPE',  
      p_target_types        => l_target_types);

    -- -------------------------------------------------------------------------
    -- Element Definitions
    -- -------------------------------------------------------------------------    
    
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(4);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.SvcHeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.TimeZoneParamController';
    l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.SvcTgtParamController';


    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(1);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(  
        'oracle.sysman.eml.ip.render.elem.emr.services.elemName',
        'dashboard_service_status');

    mgmt_ip.add_element_definition
      ( 'dashboard_service_status',
        'SVC_DASH_SERVICE_TYPE',
        'dashboard_service_status_desc',
        'oracle.sysman.eml.ip.render.elem.emr.services.controller.render.ServiceStatusRenderController',
        0,
        l_param_classes,
        l_param_values);
    
  
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(5);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.SvcHeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.TimeZoneParamController';
    l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.SvcTgtParamController';
    l_param_classes(5) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.SLTableParamController';
    
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(1);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(  
        'oracle.sysman.eml.ip.render.elem.emr.services.elemName',
        'servicelevel_table');

    mgmt_ip.add_element_definition
      ( 'servicelevel_table',
        'SVC_DASH_SERVICE_TYPE',
        'servicelevel_table_desc',
        'oracle.sysman.eml.ip.render.elem.emr.services.controller.render.SLTableRenderController',
        0,
        l_param_classes,
        l_param_values);

    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(5);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.SvcHeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.TimeZoneParamController';
    l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.SvcTgtParamController';
    l_param_classes(5) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.SLTableParamController';
    
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(1);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(  
        'oracle.sysman.eml.ip.render.elem.emr.services.elemName',
        'service_dashboard');

    mgmt_ip.add_element_definition
      ( 'service_dashboard',
        'SVC_DASH_SERVICE_TYPE',
        'service_dashboard_desc',
        'oracle.sysman.eml.ip.render.elem.emr.services.controller.render.ServiceStatusRenderController',
        0,
        l_param_classes,
        l_param_values);

    mgmt_ip.add_element_definition
      ('service_charts_elem',
        'SVC_DASH_SERVICE_TYPE',
        'service_charts_elem_desc',
        'oracle.sysman.eml.ip.render.elem.emr.services.controller.render.ServiceChartsController',
        1,
        null,
        null);
  
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(5);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.SvcHeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.TimeZoneParamController';
    l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
    l_param_classes(5) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.SLViolationsParamController';

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(4);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(  
        'oracle.sysman.eml.ip.render.elem.emr.services.elemName',
        'ServiceLevel_Details_Elem');
    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.metaParam.minTargetsAllowed','1');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.metaParam.maxTargetsAllowed','1');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.metaParam.allowsMixedTargetTypes','true');    

    mgmt_ip.add_element_definition
      ( 'ServiceLevel_Details_Elem',
        'SVC_DASH_SERVICE_TYPE',
        'ServiceLevel_Details_Elem_desc',
        'oracle.sysman.eml.ip.render.elem.emr.services.controller.render.SLDetailsRenderController',
        0,
        l_param_classes,
        l_param_values);

    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(5);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.SvcHeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.TimeZoneParamController';
    l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.SvcTgtParamController';
    l_param_classes(5) := 'oracle.sysman.eml.ip.render.elem.emr.services.controller.param.SLViolationsParamController';

    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(1);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(  
        'oracle.sysman.eml.ip.render.elem.emr.services.elemName',
        'Violations_table');

    mgmt_ip.add_element_definition
      ( 'Violations_table',
        'SVC_DASH_SERVICE_TYPE',
        'Violations_table_desc',
        'oracle.sysman.eml.ip.render.elem.emr.services.controller.render.SLViolationsRenderController',
        0,
        l_param_classes,
        l_param_values);

    mgmt_ip.add_element_definition
      ('servicedetails_elem',
        'SVC_DASH_SERVICE_TYPE',
        'servicedetails_desc',
        'oracle.sysman.eml.ip.render.elem.emr.services.controller.render.ServiceDetailsRenderController',
        1,
        null,
        null);

    --    -- -------------------------------------------------------------------------
    -- Report Definitions
    -- -------------------------------------------------------------------------    

    BEGIN
      MGMT_IP.delete_report_by_title('SYSMAN', 'Service_Charts', 0);
      EXCEPTION WHEN OTHERS THEN NULL;
    END;

    l_report_guid := mgmt_ip.create_report_definition (
      'Service_Charts',
      'Service_Charts',
      'SYSMAN',
      'EMR', 'Services',
      p_internal_use_only => 1,
      p_style => 'DASHBOARD',
      p_public_report => 1,
      p_system_report => 1,
      p_show_navigation => 0);
    

    l_element_guid := mgmt_ip.add_element_to_report_def (
      l_report_guid,
      'service_charts_elem',
      'SVC_DASH_SERVICE_TYPE',
      NULL,
      1,
      1,
      NULL,
      NULL);

    BEGIN
      MGMT_IP.delete_report_by_title('SYSMAN', 'ServiceLevel_Details', 0);
      EXCEPTION WHEN OTHERS THEN NULL;
    END;

    l_report_guid := mgmt_ip.create_report_definition (
      'ServiceLevel_Details',
      'ServiceLevel_Details',
      'SYSMAN',
      'EMR', 'Services',
      p_internal_use_only => 1,
      p_style => 'DASHBOARD',
      p_public_report => 1,
      p_system_report => 1,
      p_show_navigation => 0);
    

    l_element_guid := mgmt_ip.add_element_to_report_def (
      l_report_guid,
      'ServiceLevel_Details_Elem',
      'SVC_DASH_SERVICE_TYPE',
      NULL,
      1,
      1,
      NULL,
      NULL);

    BEGIN
      MGMT_IP.delete_report_by_title('SYSMAN', 'Service_Details', 0);
      EXCEPTION WHEN OTHERS THEN NULL;
    END;

    l_report_guid := mgmt_ip.create_report_definition (
      'Service_Details',
      'Service_Details',
      'SYSMAN',
      'EMR', 'Services',
      p_internal_use_only => 1,
      p_style => 'DASHBOARD',
      p_public_report => 1,
      p_system_report => 1,
      p_show_navigation => 0);
      
    
    l_element_guid := mgmt_ip.add_element_to_report_def (
      l_report_guid,
      'servicedetails_elem',
      'SVC_DASH_SERVICE_TYPE',
      NULL,
      1,
      1,
      NULL,
      NULL);


------------------------------------- START OF OOTB SERVICE DASHBOARD --------------------------------------------- 


    -------- TARGET TYPES TO BE DISPLAYED FOR SELECTION -------------------------------------
    BEGIN
      MGMT_IP.delete_report_by_title('SYSMAN', EM_DASHBOARD_SERVICE.G_DASHBOARD_TITLE , 0);
      EXCEPTION WHEN OTHERS THEN NULL;
    END;
    
    -------- This Report has a time period and the User can Customize it ----------------
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(1);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TimePeriodOption',
      'false');

-------------------- SERVICE DASHBOARD REPORT BEGINS --------------------------------------------------
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                   => EM_DASHBOARD_SERVICE.G_DASHBOARD_TITLE,
      p_description_nlsid             => 'service_dashboard_desc',
      p_owner                         => 
                                 EM_DASHBOARD_SERVICE.G_DASHBOARD_REPORT_OWNER,
      p_category_nlsid                => 'IPMSG_MONITORING_CATEGORY', 
      p_sub_category_nlsid            => 'IPMSG_DASHBOARDS_CATEGORY',
      p_late_binding_target_types     =>  l_service_types,
      p_late_binding_multi_targets    =>  1,
      p_show_table_of_contents        =>  0, 
      p_system_report                 =>  1,
      p_style		              =>  'DASHBOARD',
      p_parameters                    =>  l_param_values
      );
 
 -------------------- ADDING SERVICE DASHBOARD ELEMENT --------------------------------------------------
    
l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(1);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'delimitedTimeRanges',
      '0:0;0:1;0:2');



l_element_guid := mgmt_ip.add_element_to_report_def ( 
      p_report_guid         => l_report_guid,
      p_element_name_nlsid  => 'service_dashboard',
      p_element_type_nlsid  => 'SVC_DASH_SERVICE_TYPE',
      p_header_nlsid        => 'service_dashboard',
      p_element_order       => 1, 
      p_element_row         => 1, 
      p_parameters          => l_param_values,
      p_targets             => null
    );
------------------------------------- END OF OOTB SERVICE DASHBOARD --------------------------------------------- 

    COMMIT;  
    
  END;

END;
/
