Rem
Rem $Header: dashboard_service_types.sql 21-jul-2005.05:38:57 mkm Exp $
Rem
Rem dashboard_service_types.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      dashboard_service_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mkm         07/21/05 - changing varray to table 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    mkm         06/17/05 - changing definition of sla_sev_rec 
Rem    mkm         06/07/05 - modifying METRIC_REC 
Rem    mkm         06/03/05 - mkm_t0519
Rem    mkm         06/02/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

-- Array of target guid for dashboard UI
CREATE OR REPLACE TYPE target_guid_array IS 
  TABLE OF VARCHAR2(64);
/

-- Record used for cigar bar and violations table
-- in SL details UI
CREATE OR REPLACE TYPE violations_record IS OBJECT (
                    svc_guid         RAW(16),
                    target_name      VARCHAR2(256),
                    start_time       DATE,
                    end_time         DATE,
                    outage_type      VARCHAR2(32),
                    user_name        VARCHAR(64),
                    message          VARCHAR(4000),
                    severity_guid    RAW(16)
  ); 
/

CREATE OR REPLACE TYPE violations_record_array 
        IS TABLE OF violations_record;
/


-- Record used for pie chart in SL details UI
CREATE OR REPLACE TYPE sla_pie_rec IS OBJECT(
             target_guid RAW(16),
             uptime_hours NUMBER,
             downtime_hours NUMBER,
             blackout_hours NUMBER,
             unmonitored_hours NUMBER,
             severe_hours NUMBER,
             total_hours  NUMBER,
             bh_start  CHAR(4),
             bh_end    CHAR(4),
             business_days VARCHAR2(7),
             time_zone VARCHAR2(64));
           
/
SHOW ERROR;

CREATE OR REPLACE TYPE pie_time_record_array 
  IS TABLE OF sla_pie_rec;
/
SHOW ERRORS;


--Record for severity duration
CREATE OR REPLACE TYPE sla_sev_rec IS OBJECT(
            sev_start_time DATE,
            sev_end_time   DATE);
/
SHOW ERRORS;

CREATE OR REPLACE TYPE sla_sev_rec_array 
IS TABLE OF sla_sev_rec;
/
SHOW ERRORS;

--Record for metric cursor
CREATE OR REPLACE TYPE metric_rec IS OBJECT(
            metric_guid RAW(16),
            metric_name VARCHAR2(64),
            metric_column VARCHAR2(64),
            column_label VARCHAR2(64),
            column_label_nlsid VARCHAR2(64),
            short_name VARCHAR2(64),
            short_name_nlsid VARCHAR2(64),
            key_part_values VARCHAR2(512),
            metric_value NUMBER,
            severity_code NUMBER);
/
SHOW ERRORS;

CREATE OR REPLACE TYPE metric_rec_array
IS TABLE OF metric_rec;
/
SHOW ERRORS;

CREATE OR REPLACE TYPE metric_rec_array_array
IS TABLE OF metric_rec_array;
/
SHOW ERRORS;

create or replace TYPE numTableType IS TABLE OF NUMBER;
/


create or replace FUNCTION str2numtbl( p_str IN VARCHAR2 ) RETURN numTableType
AS
   l_str      LONG DEFAULT p_str || ',';
   l_n        NUMBER;
   l_data    numTableType := numTabletype();
begin
  loop
    l_n := instr( l_str, ',' );
    exit when (nvl(l_n,0) = 0);
    l_data.extend;
    l_data( l_data.count ) := ltrim(rtrim(substr(l_str,1,l_n-1)));
    l_str := substr( l_str, l_n+1 );
end loop;
return l_data;
end;
/


CREATE OR REPLACE TYPE charTableType AS TABLE OF VARCHAR2(64);
/

-- Defn of data types and function for service level and dashboard reporting
-- Internal function to cast a string of values to a table. 
CREATE OR REPLACE FUNCTION str2tbl( p_str IN VARCHAR2 ) RETURN charTableType
AS
   l_str      LONG DEFAULT p_str || ',';
   l_n        NUMBER;
   l_data    charTableType := charTabletype();
BEGIN
  LOOP
    l_n := instr( l_str, ',' );
    exit when (nvl(l_n,0) = 0);
    l_data.extend;
    l_data( l_data.count ) := ltrim(rtrim(substr(l_str,1,l_n-1)));
    l_str := substr( l_str, l_n+1 );
END LOOP;
RETURN l_data;
END;
/

SHOW ERRORS;

create or replace type status_rec is OBJECT (
status NUMBER,
hrs NUMBER);
/

show errors;

create or replace type status_rec_arr is
varray(10) of status_rec;
/

show errors;

