rem
Rem $Header: webapp_oob_samples.sql 02-aug-2005.21:34:29 saramasa Exp $
Rem
Rem $Header: webapp_oob_samples.sql 02-aug-2005.21:34:29 saramasa Exp $
Rem webapp_oob_samples.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      webapp_oob_samples.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    saramasa    08/02/05 - Moved from beta 
Rem    saramasa    05/14/05 - saramasa_bug-4369274
Rem    saramasa    05/13/05 - Adding HGrid element to sql 
Rem    saramasa    05/13/05 - Created
Rem

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100


DECLARE
i_parameters MGMT_IP_PARAM_VALUE_LIST ;
p_parameters MGMT_IP_PARAM_VALUE_LIST ;
p_parameters1 MGMT_IP_PARAM_VALUE_LIST ;
p_parameters2 MGMT_IP_PARAM_VALUE_LIST ;
p_parameters3 MGMT_IP_PARAM_VALUE_LIST ;
p_parameters4 MGMT_IP_PARAM_VALUE_LIST ;
l_target_types MGMT_IP_TARGET_TYPES := MGMT_IP_TARGET_TYPES();
l_param_values MGMT_IP_PARAM_VALUE_LIST ;

l_report_definition_guid RAW(16);
l_elem_guid RAW(16);
target_guid RAW(16);
target_name VARCHAR2(256);

BEGIN

----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Performance Reports
----------------------------------------------------------------------------------------------------------------------------
BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Alerts', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_target_types := MGMT_IP_TARGET_TYPES();
l_target_types.extend(1);
l_target_types(1) := 'website';

l_param_values := MGMT_IP_PARAM_VALUE_LIST();
l_param_values.extend(3);
-- this report has a time period 
l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TimePeriodOption',
      'true');

-- the user can customize the time period for this report
l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TimePeriodUserCust',
      'true');

-- default time period to last 24 hours
l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TimePeriodParam',
      '0:0');

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Alerts', 'Web Application Alerts', 
                                                             'SYSMAN', 'Monitoring', 
                                                             'Web Application Alerts', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays all outstanding system/performance/usage/service/test alerts for a web application.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(7) := new mgmt_ip_param_value_record('AlertValue','2');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'Performance Alerts');

p_parameters1 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters1.extend(9);
p_parameters1(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters1(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters1(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters1(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters1(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters1(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters1(7) := new mgmt_ip_param_value_record('AlertValue','3');
p_parameters1(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters1(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'Usage Alerts');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Alerts', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 
                                                 'Web Application Alerts', 
                                                 'any_target_type', 
                                                 '', 
                                                 3, 
                                                 3, 
                                                 p_parameters1, null, '');




p_parameters2 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters2.extend(9);
p_parameters2(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters2(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters2(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters2(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters2(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters2(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters2(7) := new mgmt_ip_param_value_record('AlertValue','4');
p_parameters2(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters2(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'System Alerts');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Alerts', 
                                                 'any_target_type', '', 
                                                 4, 4, 
                                                 p_parameters2, null, '');



p_parameters3 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters3.extend(9);
p_parameters3(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters3(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters3(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters3(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters3(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters3(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters3(7) := new mgmt_ip_param_value_record('AlertValue','6');
p_parameters3(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters3(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'All Test Alerts');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Alerts', 
                                                 'any_target_type', '', 
                                                 5, 5, 
                                                 p_parameters3, null, '');




p_parameters4 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters4.extend(9);
p_parameters4(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters4(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters4(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters4(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters4(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters4(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters4(7) := new mgmt_ip_param_value_record('AlertValue','5');
p_parameters4(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters4(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'All Key Test Alerts');


l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Alerts', 
                                                 'any_target_type', '', 
                                                 6, 6, 
                                                 p_parameters4, null, '');




----------------------------------------------------------------------------------------------------------------------------
--- For Summary of The Transaction Performance of a Web Application(By Beacon) Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Transaction Performance Summary: by Beacon', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Transaction Performance Summary: by Beacon', 
                                                             'Summary of Transaction Performance grouped by Beacon Report', 
                                                             'SYSMAN', 'Monitoring', 
                                                             'Web Application Transaction Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays transaction performance information grouped by beacon.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.tp.viewBy','1');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'Transaction Performance Summary: By Beacon');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Transaction Performance Summary', 
                                                 'any_target_type', '', 
                                                 2, 2,
                                                 p_parameters, null, '');



----------------------------------------------------------------------------------------------------------------------------
--- For Summary of The Transaction Performance of a Web Application(By Transaction) Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Transaction Performance Summary: by Transaction', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Transaction Performance Summary: by Transaction', 
                                                              'Summary of Transaction Performance grouped by Transaction Report', 
                                                             'SYSMAN', 'Monitoring', 
                                                             'Web Application Transaction Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays transaction performance information grouped by transaction.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');


p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.tp.viewBy','1');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'Transaction Performance Summary: By Transaction');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Transaction Performance Summary', 
                                                 'any_target_type', '', 
                                                 2, 2, 
                                                 p_parameters, null, '');




----------------------------------------------------------------------------------------------------------------------------
--- For Transaction details of a Web Application Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Transaction Details', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Transaction Details', 
                                                              'Transaction details of a Web Application', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Transaction Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays transaction, step and step group performance for an availability transaction of a web application.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(5);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'Transaction Performance Details');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Transaction Performance Details', 
                                                 'any_target_type', '', 
                                                 2,2,
                                                 p_parameters, null, '');





----------------------------------------------------------------------------------------------------------------------------
--- For URL Performance details of a Web Application Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application URL Performance in OC4J', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application URL Performance in OC4J', 
                                                              'URL Performance details of a Web Application displayed using a Graph', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Request Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays breakdown of URL processing time by OC4J sub-system over the last 24 hours.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(5);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'URL Processing Breakdown');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application URL Performance', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');



----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Availability Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Availability', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Availability', 
                                                              'Web Application Availability', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Availability/Performance/Usage', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays availability history of a web application over the last 24 hours.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(8);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'Web Application Availability');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Availability', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Availability Grid Element', 
                                                 'any_target_type', '', 
                                                3,3,
                                                 null, null, '');



----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Performance and Usage Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Performance and Usage', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Performance and Usage', 
                                                              'Web Application Performance', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Availability/Performance/Usage', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays graphs of performance and usage metrics for a web application over the last 24 hours.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(8);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('PUValue','1');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Metric Details', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');

p_parameters1 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters1.extend(8);
p_parameters1(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters1(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters1(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters1(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters1(5) := new mgmt_ip_param_value_record('PUValue','2');
p_parameters1(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters1(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters1(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Metric Details', 
                                                 'any_target_type', '', 
                                                3,2,
                                                 p_parameters1, null, '');




----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Slowest 5 Pages by Domain  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Slowest Pages by Category', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Slowest Pages by Category', 
                                                              'Wep Application Slowest Pages by Category', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Page Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays the slowest 5 pages for a web application by domain/region/web cache/visitor');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(10);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('AxisValue','1');
p_parameters(6) := new mgmt_ip_param_value_record('PageTypeValue','2');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(10) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam','By Domain');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Page Performance By Category', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');




p_parameters1 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters1.extend(10);
p_parameters1(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters1(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters1(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters1(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters1(5) := new mgmt_ip_param_value_record('AxisValue','2');
p_parameters1(6) := new mgmt_ip_param_value_record('PageTypeValue','2');
p_parameters1(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters1(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters1(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters1(10) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam','By Region');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Page Performance By Category', 
                                                 'any_target_type', '', 
                                                3,3,
                                                 p_parameters1, null, '');




p_parameters2 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters2.extend(10);
p_parameters2(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters2(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters2(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters2(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters2(5) := new mgmt_ip_param_value_record('AxisValue','4');
p_parameters2(6) := new mgmt_ip_param_value_record('PageTypeValue','2');
p_parameters2(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters2(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters2(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters2(10) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam','By Web Cache');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Page Performance By Category', 
                                                 'any_target_type', '', 
                                                4,1,
                                                 p_parameters2, null, '');


p_parameters3 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters3.extend(10);
p_parameters3(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters3(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters3(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters3(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters3(5) := new mgmt_ip_param_value_record('AxisValue','3');
p_parameters3(6) := new mgmt_ip_param_value_record('PageTypeValue','2');
p_parameters3(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters3(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters3(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters3(10) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam','By Visitor');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Page Performance By Category', 
                                                 'any_target_type', '', 
                                                5,1,
                                                 p_parameters3, null, '');





----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Top 5 Most Popular Pages by Domain  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Top 5 Most Popular Pages by Category', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Top 5 Most Popular Pages by Category', 
                                                              'Web Application Top 5 Most Popular Pages by Category', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Page Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays response time statistics for top 5 most popular pages by domain/region/web cache/visitor');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(10);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('AxisValue','1');
p_parameters(6) := new mgmt_ip_param_value_record('PageTypeValue','1');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(10) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam','By Domain');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Page Performance By Category', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');

p_parameters1 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters1.extend(10);
p_parameters1(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters1(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters1(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters1(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters1(5) := new mgmt_ip_param_value_record('AxisValue','2');
p_parameters1(6) := new mgmt_ip_param_value_record('PageTypeValue','1');
p_parameters1(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters1(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters1(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters1(10) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam','By Region');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Page Performance By Category', 
                                                 'any_target_type', '', 
                                                3,3,
                                                 p_parameters1, null, '');

p_parameters2 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters2.extend(10);
p_parameters2(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters2(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters2(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters2(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters2(5) := new mgmt_ip_param_value_record('AxisValue','4');
p_parameters2(6) := new mgmt_ip_param_value_record('PageTypeValue','1');
p_parameters2(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters2(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters2(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters2(10) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam','By Web Cache');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Page Performance By Category', 
                                                 'any_target_type', '', 
                                                4,4,
                                                 p_parameters, null, '');

p_parameters3 := MGMT_IP_PARAM_VALUE_LIST();
p_parameters3.extend(10);
p_parameters3(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters3(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters3(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters3(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters3(5) := new mgmt_ip_param_value_record('AxisValue','3');
p_parameters3(6) := new mgmt_ip_param_value_record('PageTypeValue','1');
p_parameters3(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters3(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters3(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters3(10) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam','By Visitor');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Page Performance By Category', 
                                                 'any_target_type', '', 
                                                5,5,
                                                 p_parameters3, null, '');


----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Slowest URL Requests By Total Time  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Slowest URL Requests By Total Time', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Slowest URL Requests By Total Time', 
                                                              'Web Application Slowest URL Requests By Total Time', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Request Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays server-tier breakdown for URL requests of a web application, ordered by Total Time.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(10);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.viewBy','uri');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.minHits','8');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(10) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'URL Performance');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Request Performance', 
                                                 'any_target_type', '', 
                                                 2,2,
                                                 p_parameters, null, '');



----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Slowest URL Requests By EJB Time  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Slowest URL Requests By EJB Time', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Slowest URL Requests By EJB Time', 
                                                              'Web Application Slowest URL Requests By EJB Time', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Request Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays server-tier breakdown for URL requests of a web application, ordered by EJB Time.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(10);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.viewBy','ejb');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.minHits','8');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(10) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'URL Performance By EJB');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Request Performance', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');




----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Slowest URL Requests By JSP Time  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Slowest URL Requests By JSP Time', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Slowest URL Requests By JSP Time', 
                                                              'Web Application Slowest URL Requests By JSP Time', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Request Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays server-tier breakdown for URL requests of a web application, ordered by JSP Time.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(10);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.viewBy','jsp');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.minHits','8');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(10) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'URL Performance By JSP');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Request Performance', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');



----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Slowest URL Requests By Servlet Time  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Slowest URL Requests By Servlet Time', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Slowest URL Requests By Servlet Time', 
                                                              'Web Application Slowest URL Requests By Servlet Time', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Request Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays server-tier breakdown for URL requests of a web application, ordered by Servlet Time.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(10);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.viewBy','servlet');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.minHits','8');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(10) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'URL Performance By Servlet');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Request Performance', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');




----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Slowest URL Requests By JDBC Time  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Slowest URL Requests By JDBC Time', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Slowest URL Requests By JDBC Time', 
                                                              'Web Application Slowest URL Requests By JDBC Time', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Request Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays server-tier breakdown for URL requests of a web application, ordered by JDBC Time.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(10);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.viewBy','jdbc');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.minHits','8');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(10) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'URL Performance By JDBC Time');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Request Performance', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');


----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Slowest URL Requests By Hits  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Slowest URL Requests By Hits', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Slowest URL Requests By Hits', 
                                                              'Web Application Slowest URL Requests By Hits', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Request Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays server-tier breakdown for URL requests of a web application, ordered by number of hits.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(10);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.viewBy','hits');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.e2e.minHits','8');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(10) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'URL Performance By # Hits');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Request Performance', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');




----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Top 10 Most Popular URLs  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Top 10 Most Popular URLs', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Top 10 Most Popular URLs', 
                                                              'Web Application Top 10 Most Popular URLs', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Page Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays response time details for top 10 most popular pages for a web application over the last 24 hours.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('EUMValue','3');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'Top 10 Most Popular Pages');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Page Performance', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');



----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Top 10 Slowest Pages  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Top 10 Slowest Pages', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Top 10 Slowest Pages', 
                                                              'Web Application Top 10 Slowest Pages', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Page Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays response time details for the 10 slowest pages for a web application over the last 24 hours.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('EUMValue','1');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'Top 10 Slowest Pages');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Page Performance', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');


----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Top 5 Most Active Regions  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Top 5 Most Active Regions', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Top 5 Most Active Regions', 
                                                              'Web Application Top 5 Most Active Regions', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Page Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays response time details for the top 5 regions with the most number of hits over the last 24 hours.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('EUMValue','5');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'Top 5 Most Active Regions');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Page Performance', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');



----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Top 5 Slowest Visitor Regions  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Top 5 Slowest Visitor Regions', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Top 5 Slowest Visitor Regions', 
                                                              'Web Application Top 5 Slowest Visitor Regions', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Page Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays response time details for 5 slowest visitor regions over the last 24 hours.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('EUMValue','4');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'Top 5 Slowest Visitor Regions');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Page Performance', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');



----------------------------------------------------------------------------------------------------------------------------
--- For Web Application Page Watch List  Reports
----------------------------------------------------------------------------------------------------------------------------

BEGIN
MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Page Watch List', 0);
EXCEPTION WHEN OTHERS THEN NULL;
END;

l_report_definition_guid := MGMT_IP.create_report_definition('Web Application Page Watch List', 
                                                              'Web Application Page Watch List', 'SYSMAN', 'Monitoring', 
                                                             'Web Application Page Performance', l_target_types, 
                                                             0, 0, 
                                                             1, '', 
                                                             0, '',
                                                             'BLAF', 1, 
                                                             'EM', '', 
                                                             '10.2', l_param_values, 
                                                             0, 0, null);


i_parameters := MGMT_IP_PARAM_VALUE_LIST();
i_parameters.extend(3);
i_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage','Displays response time details for pages on a web application''s page watch list.');
i_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle','OraInstructionText');
i_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination','');

p_parameters := MGMT_IP_PARAM_VALUE_LIST();
p_parameters.extend(9);
p_parameters(1) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodParam','0:0');
p_parameters(2) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption','true');
p_parameters(3) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimezoneRegion','');
p_parameters(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodUserCust','false');
p_parameters(5) := new mgmt_ip_param_value_record('EUMValue','2');
p_parameters(6) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TargetsParamController.InternalTargetType','');
p_parameters(7) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.SetTargetsOption.InheritOrOverride.InheritTargetsSelectedByViewer');
p_parameters(8) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride','oracle.sysman.eml.ip.render.elem.TimePeriodOption.InheritOrOverride.InheritReportTimePeriod');
p_parameters(9) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.headerParam', 'Page Watch List');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'IPMSG_STYLED_TEXT', 
                                                 'IPMSG_ANY_TARGET_TYPE', '', 
                                                 1, 1, 
                                                 i_parameters, null, '');

l_elem_guid := MGMT_IP.add_element_to_report_def(l_report_definition_guid, 'Web Application Page Performance', 
                                                 'any_target_type', '', 
                                                2,2,
                                                 p_parameters, null, '');


COMMIT;
END;
/




