Rem
Rem $Header: webapp_outofbox_reports.sql 02-aug-2005.21:34:05 saramasa Exp $
Rem
Rem webapp_outofbox_reports.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      webapp_outofbox_reports.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    saramasa    08/02/05 - Moved from beta 
Rem    pmaddi      04/12/05 - Removing header param from Web Application 
Rem                           Transaction Performance Details element 
Rem    pmaddi      03/28/05 - Renaming elements to proposed conventions., 
Rem    pmaddi      03/23/05 - Redifining element defintions for elements with 
Rem                           unused default parameters. 
Rem    pmaddi      03/21/05 - Renaming elements. 
Rem    pmaddi      03/10/05 - 
Rem    pmaddi      03/01/05 - pmaddi_reports_res
Rem    pmaddi      02/23/05 - Created
Rem

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

SET DEFINE OFF

BEGIN
 
  DECLARE 
    l_target_types  MGMT_IP_TARGET_TYPES;
    l_param_classes MGMT_IP_PARAM_CLASSES;
    l_param_values  MGMT_IP_PARAM_VALUE_LIST;
    l_targets       MGMT_IP_TARGET_LIST;
    l_report_guid   RAW(16);
    l_element_guid  RAW(16);
    
  BEGIN
   
        
    -- e2e table from inputs
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(4);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
    l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.webapps.e2e.E2EParamController';
    mgmt_ip.add_element_definition
      ('Web Application Request Performance',
        'any_target_type',
        'Displays table with end to end montioring information',
        'oracle.sysman.eml.ip.render.elem.webapps.e2e.SlowestURLRenderController',
        0,
        l_param_classes,
        null);  
    
        
    -- e2e chart from inputs
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(3);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.webapps.e2e.E2EChartParamController';
    mgmt_ip.add_element_definition
      ('Web Application URL Performance',
        'any_target_type',
        'Displays time series chart showing the performance for a given url.',
        'oracle.sysman.eml.ip.render.elem.webapps.e2e.URLPerfRenderController',
        0,
        l_param_classes,
        null);
        
    -- Transaction performance table from inputs
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(4);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
    l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.webapps.tp.TransactionPerformanceParamController';
    mgmt_ip.add_element_definition
      ('Web Application Transaction Performance Summary',
        'any_target_type',
        'Shows Table summarizing the transaction performance',
        'oracle.sysman.eml.ip.render.elem.webapps.tp.TransactionPerformanceRenderController',
        0,
        l_param_classes,
        null);
        

    -- Transaction performance details table from inputs
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(3);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.webapps.tp.TransPerfParamController';
    mgmt_ip.add_element_definition
      ('Web Application Transaction Performance Details',
        'any_target_type',
        'Displays 6 tables depicting the transaction performance details for a given transaction',
        'oracle.sysman.eml.ip.render.elem.webapps.tp.TransPerfDetailsRenderController',
        0,
        l_param_classes,
        null);   


		-- Element for Page By Axis 
		l_param_classes := MGMT_IP_PARAM_CLASSES();
      l_param_classes.extend(4);
			l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
      l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
      l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
      l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.webapps.eum.PagesByAxisParamController';
      mgmt_ip.add_element_definition(
         p_element_name_nlsid  => 'Web Application Page Performance By Category',
         p_element_type_nlsid  => 'any_target_type',
         p_description_nlsid   => 'Renders values for Different Pages of a Web Application',
         p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.webapps.eum.PagesByAxisRenderController',
         p_internal_use_only   => 0,
         p_param_classes       => l_param_classes,
         p_default_parameters  => null,
         p_pack_name           => null
         );
	
		 -- Element for EUM reports
		l_param_classes := MGMT_IP_PARAM_CLASSES();
      l_param_classes.extend(4);
			l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
      l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
      l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
      l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.webapps.eum.EUMParamController';
      mgmt_ip.add_element_definition(
         p_element_name_nlsid  => 'Web Application Page Performance',
         p_element_type_nlsid  => 'any_target_type',
         p_description_nlsid   => 'Renders EUM Reports for a given Web Application',
         p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.webapps.eum.EUMRenderController',
         p_internal_use_only   => 0,
         p_param_classes       => l_param_classes,
         p_default_parameters  => null,
         p_pack_name           => null
         );
	

		-- Element for Alert Reports	
      l_param_classes := MGMT_IP_PARAM_CLASSES();
      l_param_classes.extend(4);				
			l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
      l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
      l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
      l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.webapps.summary.AlertParamController';
      mgmt_ip.add_element_definition(
         p_element_name_nlsid  => 'Web Application Alerts',
         p_element_type_nlsid  => 'any_target_type',
         p_description_nlsid   => 'Displays all the Alerts for the given Web Application',
         p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.webapps.summary.AlertRenderController',
         p_internal_use_only   => 0,
         p_param_classes       => l_param_classes,
         p_default_parameters  => null,
         p_pack_name           => null
         );
	
		-- Element for Performance and Usage Reports		
      l_param_classes := MGMT_IP_PARAM_CLASSES();
      l_param_classes.extend(4);
      l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
      l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
      l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
      l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.webapps.summary.PUParamController';
      mgmt_ip.add_element_definition(
         p_element_name_nlsid  => 'Web Application Metric Details',
         p_element_type_nlsid  => 'any_target_type',
         p_description_nlsid   => 'Renders Performance and Usage Graphs for a Web Application',
         p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.webapps.summary.PURenderController',
         p_internal_use_only   => 0,
         p_param_classes       => l_param_classes,
         p_default_parameters  => null,
         p_pack_name           => null
         );
	
		--Element for Availability Reports		
	l_param_classes := MGMT_IP_PARAM_CLASSES();
      l_param_classes.extend(2);
      l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
      l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';      
      mgmt_ip.add_element_definition(
         p_element_name_nlsid  => 'Web Application Availability',
         p_element_type_nlsid  => 'any_target_type',
         p_description_nlsid   => 'Gives Availability for the Web Application',
         p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.webapps.summary.AvailabilityRenderController',
         p_internal_use_only   => 0,
         p_param_classes       => l_param_classes,
         p_default_parameters  => null,
         p_pack_name           => null
         );		
      
			-- Element for showing Avaialabilty Grid control
      l_param_classes := MGMT_IP_PARAM_CLASSES();
      l_param_classes.extend(3);
      l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
      l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
      l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';      
      mgmt_ip.add_element_definition(
         p_element_name_nlsid  => 'Availability Grid Element',
         p_element_type_nlsid  => 'any_target_type',
         p_description_nlsid   => 'Gives Availability for the Web Application',
         p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.webapps.summary.SvcAvailabilityHGridHandler',
         p_internal_use_only   => 0,
         p_param_classes       => l_param_classes,
         p_default_parameters  => null,
         p_pack_name           => null
         );
        
				-- Hidden report for displaying transaction performance details report by url
				 l_param_values := MGMT_IP_PARAM_VALUE_LIST();
			   l_param_values.extend(3);
				l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
			    'oracle.sysman.eml.ip.render.elem.TimePeriodOption',
				  'true');
			   l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
					'oracle.sysman.eml.ip.render.elem.TimePeriodUserCust',
					'true');
			  	l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
					'oracle.sysman.eml.ip.render.elem.TimePeriodParam',
					'0:0');
         l_report_guid := mgmt_ip.create_report_definition (
										p_title_nlsid                   => 'Web Application Transaction Details ',
										p_description_nlsid             => 'Web Application Transaction Details',
										p_owner => 'SYSMAN',
										p_category_nlsid => 'Monitoring', 
										p_sub_category_nlsid => 'Web Application Transaction Performance',
										p_internal_use_only => 1,
										p_public_report => 0,
										p_system_report => 1,
										p_show_navigation => 1,
										p_parameters    =>  l_param_values);
										
					l_param_values := MGMT_IP_PARAM_VALUE_LIST();
					l_param_values.extend(2);
					l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
										'oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage',
												'Displays the transaction performance details for a Web Application.');
					l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
										'oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle',
												'OraInstructionText');
					
					l_element_guid := mgmt_ip.add_element_to_report_def (
												p_report_guid => l_report_guid,
												p_element_name_nlsid => 'Styled Text',
												p_element_type_nlsid => 'any_target_type',
												p_element_order => 1,
												p_element_row => 1,
												p_parameters => l_param_values,
												p_targets => NULL
												);
					
					l_element_guid := mgmt_ip.add_element_to_report_def (
												l_report_guid,
												'Web Application Transaction Performance Details',
												'any_target_type',
												NULL,
												2,
												2,
												NULL,
												NULL);

    COMMIT;    
  END;
END;
/

SET DEFINE ON
SET ECHO ON
