Rem
Rem $Header: jobs_init.sql 19-jul-2005.13:41:04 pkantawa Exp $
Rem
Rem jobs_init.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      jobs_init.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pkantawa    07/19/05 - Remove tgt pre deletion callback 
Rem    skini       07/11/05 - Add group membership change 
Rem    rpinnama    05/16/05 - rpinnama_bug-4331862_main
Rem    rpinnama    05/12/05 - Created
Rem

DECLARE 
  del_exceptions SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN
    -- Add deletion exceptions here
    del_exceptions.extend(3);
    del_exceptions(1) := 'MGMT_JOB_TARGET';
    del_exceptions(2) := 'MGMT_JOB_EXT_TARGETS';
    del_exceptions(3) := 'MGMT_JOB_FLAT_TARGETS';
    MGMT_ADMIN.add_target_deletion_exceptions(del_exceptions);
END;
/
show errors;


-- register user model callbacks
BEGIN
    -- for jobs
    MGMT_USER.add_callback('MGMT_JOB_ENGINE.get_user_jobs',
                           MGMT_USER.GET_USER_OBJECTS_CALLBACK);
    MGMT_USER.add_callback('MGMT_JOB_ENGINE.drop_user_jobs',
                           MGMT_USER.USER_DROPPED_CALLBACK);
    MGMT_USER.add_callback('MGMT_JOB_ENGINE.reassign_user_jobs',
                           MGMT_USER.USER_REASSIGN_CALLBACK);
    MGMT_USER.add_callback('MGMT_JOB_ENGINE.check_reassign_user_jobs',
                           MGMT_USER.CHECK_USER_REASSIGN_CALLBACK);
    
    -- for ca
    MGMT_USER.add_callback('MGMT_JOB_ENGINE.get_user_ca',
                           MGMT_USER.GET_USER_OBJECTS_CALLBACK);
    MGMT_USER.add_callback('MGMT_JOB_ENGINE.drop_user_ca',
                           MGMT_USER.USER_DROPPED_CALLBACK);
    MGMT_USER.add_callback('MGMT_JOB_ENGINE.reassign_user_ca',
                           MGMT_USER.USER_REASSIGN_CALLBACK);
    MGMT_USER.add_callback('MGMT_JOB_ENGINE.check_reassign_user_ca',
                           MGMT_USER.CHECK_USER_REASSIGN_CALLBACK);
END;
/

-- Register ourselves as a callback to the http session manager
BEGIN
    MGMT_HTTP_SESSION.register_expiry_callback('JOB',
                                           'MGMT_JOB_ENGINE.handle_http_session_expiry');
END;
/

-- Group membership change callbacks

BEGIN
    -- Callbacks for adding/removing a target to/from a group
    MGMT_ASSOC.add_assoc_addition_callback('MGMT_JOB_ENGINE.group_change_callback',
                                           MGMT_ASSOC.ASSOC_DEF_CONTAINS);
    EXCEPTION WHEN OTHERS THEN
        -- Ignore duplicate registration errors
        NULL;
END;
/

BEGIN
    MGMT_ASSOC.add_assoc_deletion_callback('MGMT_JOB_ENGINE.group_change_callback',
                                          MGMT_ASSOC.ASSOC_DEF_CONTAINS);
    EXCEPTION WHEN OTHERS THEN
      -- Ignore duplicate registration errors
      NULL;
END;
/

COMMIT;

