Rem DO NOT ADD HEADER HERE, and DO NOT DELETE THIS FILE EITHER.  THIS FILE
Rem IS BEING REFERENCED FROM license_data_upgrade.sql
Rem
Rem $Header: license_post_creation.sql 20-sep-2005.00:01:09 paachary Exp $
Rem
Rem license_post_creation.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      license_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      This script contains calls to APIs which perform inserts/updates to the tables.
Rem      This script is invoked both during the upgradation and fresh creation repository scripts.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    paachary    09/20/05 - grabtrans
Rem    paachary    09/15/05 - Removing host as the dependent target type for 
Rem                           "oracle_database", "oracle_ias" and "rac_database"
Rem                           Removing dependency between "rac_database" and "cluster"
Rem    chyu        07/19/05 - modifying the new rep manager header 
Rem    schoudha    04/04/05 - Server Tracing changed to Interactive Transaction Trace 
Rem    paachary    04/15/05 - Adding mgmt_licensed_targets to the delete exclusion list
Rem    paachary    03/08/05 - paachary_upgrdscrpts
Rem    paachary    03/04/05 - Created
Rem

BEGIN
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_diag'  ,
        p_target_type        => 'oracle_database'  ,
        p_pack_display_label => 'Database Diagnostics Pack',
        p_pack_description   => 'Oracle Diagnostics Pack 10g for database offers a complete, cost-effective, and easy to use solution for managing the performance of Oracle Database environments by providing unique functionality such as automatic identification of performance bottlenecks, guided problem resolution, and comprehensive system monitoring.<p><li> Performance Monitoring (Database and Host)</li> <li> ADDM (Automated Database Diagnostic Monitor)</li> <li> Automatic Workload Repository </li> <li> Event Notifications:  Notification Methods, Rules and Schedules <li> Event history/metric history (Database and Host)</li> <li> Blackouts</li></p>',
        p_pack_abbr          => 'DD'  
    );
    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_tuning'  ,
        p_target_type        => 'oracle_database'  ,
        p_pack_display_label => 'Database Tuning Pack',
        p_pack_description   => 'Oracle Tuning Pack 10g offers a set of new, groundbreaking technologies that automate the entire application tuning process, thereby significantly lowering database management costs while enhancing performance and reliability.<p><li>SQL Access Advisor</li><li>SQL Tuning Advisor</li><li>SQL Tuning Sets</li><li>Reorganize Objects</li></p>',
        p_pack_abbr          => 'DT'  
    );
    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_config'  ,
        p_target_type        => 'oracle_database'  ,
        p_pack_display_label => 'Database Configuration Pack',
        p_pack_description   => 'Automates the time-consuming and often error prone process of software configuration, software and hardware inventory tracking, patching, cloning and policy management.<p><li>Database and Host Configuration</li><li>Deployments</li><li>Patch Database and View Patch Cache</li><li>Patch staging</li><li>Clone Database</li><li>Clone Oracle Home</li><li>Search configuration</li><li>Compare configuration</li><li>Policies</li></p>' ,
        p_pack_abbr          => 'DC'  
    );
    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'as_diag'  ,
        p_target_type        => 'oracle_ias'  ,
        p_pack_display_label => 'Application Server Diagnostics Pack',
        p_pack_description   => 'Ensures high availability of mission-critical applications by reducing the complex tasks of diagnosing and correcting application performance problems.<p><li>Historical/trending data (Application Server and Host)</li><li>Interactive Transaction Trace</li><li>Page Performance</li><li>Event Notifications:  Notification Methods, Rules and Schedules</li><li>Blackouts</li></p>' ,
        p_pack_abbr          => 'AD'  
    );
    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'as_config'  ,
        p_target_type        => 'oracle_ias'  ,
        p_pack_display_label => 'Application Server Configuration Pack',
        p_pack_description   => 'Improves the efficiency and reliability of software configuration, patching, cloning, policy management and hardware and software inventory tracking.<p> <li>Application Server and Host Configuration</li></p>' ,
        p_pack_abbr          => 'AC'  
    );
    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_diag'  ,
        p_target_type        => 'rac_database'  ,
        p_pack_display_label => 'Database Diagnostics Pack',
        p_pack_description   => 'Oracle Diagnostics Pack 10g for database offers a complete, cost-effective, and easy to use solution for managing the performance of Oracle Database environments by providing unique functionality such as automatic identification of performance bottlenecks, guided problem resolution, and comprehensive system monitoring.<p><li> Performance Monitoring (Database and Host)</li> <li> ADDM (Automated Database Diagnostic Monitor)</li> <li> Automatic Workload Repository </li> <li> Event Notifications:  Notification Methods, Rules and Schedules <li> Event history/metric history (Database and Host)</li> <li> Blackouts</li></p>' ,
        p_pack_abbr          => 'DD'  
    );
    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_tuning'  ,
        p_target_type        => 'rac_database'  ,
        p_pack_display_label => 'Database Tuning Pack',
        p_pack_description   => 'Oracle Tuning Pack 10g offers a set of new, groundbreaking technologies that automate the entire application tuning process, thereby significantly lowering database management costs while enhancing performance and reliability.<p><li>SQL Access Advisor</li><li>SQL Tuning Advisor</li><li>SQL Tuning Sets</li><li>Reorganize Objects</li></p>' ,
        p_pack_abbr          => 'DT'  
    );
    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_config'  ,
        p_target_type        => 'rac_database'  ,
        p_pack_display_label => 'Database Configuration Pack',
        p_pack_description   => 'Automates the time-consuming and often error prone process of software configuration, software and hardware inventory tracking, patching, cloning and policy management.<p><li>Database and Host Configuration</li><li>Deployments</li><li>Patch Database and View Patch Cache</li><li>Patch staging</li><li>Clone Database</li><li>Clone Oracle Home</li><li>Search configuration</li><li>Compare configuration</li><li>Policies</li></p>' ,
        p_pack_abbr          => 'DC'  
    );
    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_chgmgt'  ,
        p_target_type        => 'oracle_database'  ,
        p_pack_display_label => 'Database Change Management Pack',
        p_pack_description   => 'Oracle Change Management Pack 10g for database offers a set of applications to capture and compare the definitions of one or more database objects.<p><li>Create Metadata Baseline: You can capture database object definitions at different points in time and create reusable baseline versions.</li><li>Compare Database Objects: You can compare two sets of database objects definitions and view the differences. Comparison sources can be two databases, two baselines or a database and a baseline. You can repeat comparsions at different points in time and create comparison versions.</li></p>' ,
        p_pack_abbr          => 'CM'  
    );
    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_chgmgt'  ,
        p_target_type        => 'rac_database'  ,
        p_pack_display_label => 'Database Change Management Pack',
        p_pack_description   => 'Oracle Change Management Pack 10g for database offers a set of applications to capture and compare the definitions of one or more database objects.<p><li>Create Metadata Baseline: You can capture database object definitions at different points in time and create reusable baseline versions.</li><li>Compare Database Objects: You can compare two sets of database objects definitions and view the differences. Comparison sources can be two databases, two baselines or a database and a baseline. You can repeat comparsions at different points in time and create comparison versions.</li></p>' ,
        p_pack_abbr          => 'CM'  
    );
    
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_database',
        p_target_type         => 'oracle_database'
    );
    
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_ias',
        p_target_type         => 'oracle_ias'
    );
    
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_ias',
        p_target_type         => 'oracle_apache'
    );
    
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_ias',
        p_target_type         => 'oracle_jserv'
    );
    
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_ias',
        p_target_type         => 'oracle_webcache'
    );
    
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_ias',
        p_target_type         => 'oc4j'
    );
    
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_ias',
        p_target_type         => 'oracle_processconnect_domain'
    );
    
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_ias',
        p_target_type         => 'oracle_ldap'
    );
    
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_ias',
        p_target_type         => 'oracle_sso_server'
    );
    
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_ias',
        p_target_type         => 'website'
    );
    
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'rac_database',
        p_target_type         => 'osm_instance'
    );
    
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'rac_database',
        p_target_type         => 'oracle_database'
    );
    
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'rac_database',
        p_target_type         => 'rac_database'
    );
    
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_database',
        p_target_type         => 'osm_instance'
    );
    
    em_license.add_packs
    (
        p_pack_name     => 'db_diag'
    );
    
    em_license.add_packs
    (
        p_pack_name     => 'db_tuning'
    );
    
    em_license.add_packs
    (
        p_pack_name     => 'db_config'
    );
    
    em_license.add_packs
    (
        p_pack_name     => 'db_chgmgt'
    );
    
    em_license.add_packs
    (
        p_pack_name     => 'as_diag'
    );
    
    
    em_license.add_packs
    (
        p_pack_name     => 'as_config'
    );

    mgmt_admin.add_target_addition_callback
    (
        p_procedure_name_in=>'em_license.auto_license_target'
    );

    mgmt_admin.add_target_deletion_callback
    (
        p_procedure_name_in=>'em_license.auto_revoke_license_info'
    );

    mgmt_assoc.add_assoc_addition_callback
    (
        p_procedure_name=> 'em_license.webapp_license_assoc_create',
        p_assoc_def_name=> MGMT_ASSOC.ASSOC_DEF_DEPENDS_ON,
        p_source_target_type=> MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE
    );

    mgmt_assoc.add_assoc_deletion_callback
    (
        p_procedure_name    => 'em_license.webapp_license_assoc_delete',
        p_assoc_def_name    =>  MGMT_ASSOC.ASSOC_DEF_DEPENDS_ON,
        p_source_target_type => MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE
    );

    mgmt_assoc.add_assoc_addition_callback
    (
        p_procedure_name=> 'em_rac_license.rac_license_assoc_create',
        p_source_target_type=> MGMT_GLOBAL.G_RAC_DATABASE_TARGET_TYPE
    );

    mgmt_assoc.add_assoc_deletion_callback
    (
        p_procedure_name    => 'em_rac_license.rac_license_assoc_delete',
        p_source_target_type => MGMT_GLOBAL.G_RAC_DATABASE_TARGET_TYPE
    );

    mgmt_assoc.add_assoc_addition_callback
    (
        p_procedure_name=> 'em_rac_license.rac_license_assoc_create',
        p_source_target_type=> MGMT_GLOBAL.G_DATABASE_TARGET_TYPE
    );

    mgmt_assoc.add_assoc_deletion_callback
    (
        p_procedure_name    => 'em_rac_license.rac_license_assoc_delete',
        p_source_target_type => MGMT_GLOBAL.G_DATABASE_TARGET_TYPE
    );

    mgmt_assoc.add_assoc_addition_callback
    (
        p_procedure_name=> 'em_license.asm_license_assoc_create',
        p_source_target_type=> MGMT_GLOBAL.G_DATABASE_TARGET_TYPE
    );

    mgmt_assoc.add_assoc_deletion_callback
    (
        p_procedure_name    => 'em_license.asm_license_assoc_delete',
        p_source_target_type => MGMT_GLOBAL.G_DATABASE_TARGET_TYPE
    );


    mgmt_admin.add_target_deletion_exceptions(SMP_EMD_STRING_ARRAY('MGMT_LICENSED_TARGETS'));

    COMMIT;
END;
/
