Rem drv: <migrate type="schema_upgrade" version="10.2.0.0" pos="customize/customize_schema_upgrade.sql+"/>
Rem
Rem $Header: license_schema_upgrade.sql 01-dec-2006.21:48:52 aptrived Exp $
Rem
Rem license_schema_upgrade.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      license_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      This script provides the schema upgrade script for license functional unit
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    aptrived    12/01/06 - Bug#5475797, fixing ORA-0955
Rem    chyu        07/25/05 - modifying the upgrade header 
Rem    chyu        07/18/05 - adding the <migration> header 
Rem    paachary    07/15/05 - 
Rem    paachary    03/08/05 - paachary_upgrdscrpts
Rem    paachary    03/03/05 - Created
Rem

ALTER TABLE mgmt_license_definitions MODIFY (target_type VARCHAR2(64) NOT NULL);

ALTER TABLE mgmt_license_definitions MODIFY (pack_description VARCHAR2(1000));

ALTER TABLE mgmt_license_definitions ADD (pack_abbr  VARCHAR2(5));

BEGIN
    FOR c1 in 
    (
        SELECT pack_label 
        FROM mgmt_license_definitions
        FOR UPDATE
    )
    LOOP
        UPDATE mgmt_license_definitions
        SET pack_abbr = substr(c1.pack_label,1,5)
        WHERE pack_label = c1.pack_label;
    END LOOP;
END;
/
ALTER TABLE mgmt_license_definitions MODIFY (pack_abbr NOT NULL);

ALTER TABLE mgmt_license_definitions ADD CONSTRAINT mgmt_license_definitions_unq UNIQUE(pack_abbr,target_type);

ALTER TABLE mgmt_license_definitions DROP CONSTRAINT mgmt_license_definitions_pk CASCADE DROP INDEX;

ALTER TABLE mgmt_license_definitions ADD CONSTRAINT mgmt_license_definitions_pk PRIMARY KEY (pack_label,target_type);

Rem Calling the SQL from the migration path 
Rem emcore/source/oracle/sysman/emdrep/sql/core/v102010/license/license_tables.sql
Rem to create the tables added newly as a part of 10GR2.

@&EM_SQL_ROOT/core/v102010/license/license_tables.sql

Rem Calling the SQL from the migration path 
Rem emcore/source/oracle/sysman/emdrep/sql/core/v102010/license/license_indexes.sql
Rem to create the indexes added newly as a part of 10GR2.

@&EM_SQL_ROOT/core/v102010/license/license_indexes.sql

-- End Tables and Indexes

-- Types

Rem Calling the SQL from the migration path 
Rem emcore/source/oracle/sysman/emdrep/sql/core/v102010/license/license_types.sql
Rem to create the types added newly as a part of 10GR2.

@&EM_SQL_ROOT/core/v102010/license/license_types.sql
