Rem
Rem $Header: license_tables.sql 29-jun-2005.01:47:48 gsbhatia Exp $
Rem
Rem license_tables.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      license_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      This file contains only the newly added tables which are part of 10GR2.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    paachary    03/08/05 - paachary_upgrdscrpts
Rem    paachary    03/03/05 - Created
Rem
Rem
Rem  PURPOSE
Rem
Rem     The MGMT_LICENSED_TARGETS table holds the flattened list of
Rem     licensed targets in EM.
Rem
Rem  COLUMNS
Rem
Rem     TARGET_GUID    - the unique id of the licensed target
Rem
Rem     PACK_NAME  - the pack name the licensed target has license
Rem 
Rem     FROM_TARGET_GUID  - the unique id of the target that the licensed target gets its license from

CREATE TABLE mgmt_licensed_targets 
(
  target_guid      RAW(16),
  pack_name        VARCHAR(64),
  from_target_guid RAW(16),
 CONSTRAINT mgmt_licensed_targets_pk
PRIMARY KEY (target_guid, pack_name, from_target_guid)
) 
ORGANIZATION INDEX
MONITORING;

Rem
Rem  PURPOSE
Rem
Rem     The MGMT_LICENSE_CONFIRMATION table stores the access agreement information.
Rem
Rem  COLUMNS
Rem
Rem     TARGET_GUID    - the unique id of the licensed target
Rem
Rem     CONFIRMATION   - access agreement was confirmed or not
Rem 
Rem     CONFIRMED_BY   - the user who confirmed the access agreement
Rem 
Rem     CONFIRMED_TIME - when it was confirmed

CREATE TABLE mgmt_license_confirmation 
(
  target_guid    RAW(16),
  confirmation   VARCHAR(1),
  confirmed_by   VARCHAR2(256),
  confirmed_time DATE,
  CONSTRAINT mgmt_license_confirmation_pk
       PRIMARY KEY (target_guid)
) 
ORGANIZATION INDEX
OVERFLOW INCLUDING confirmed_time
MONITORING;

