Rem
Rem $Header: metric_types.sql 29-jun-2005.01:46:37 gsbhatia Exp $
Rem
Rem metric_types.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      metric_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    rpinnama    05/17/05 - Add is_renderable attribute to 
Rem                           mgmt_metric_column_obj 
Rem    rpinnama    03/21/05 - Default statefull to 1 
Rem    rpinnama    03/03/05 - 
Rem    rpinnama    03/01/05 - rpinnama_bug-3924067
Rem    rpinnama    02/25/05 - Created
Rem


CREATE OR REPLACE TYPE MGMT_CATEGORY_PROP_ARRAY IS TABLE OF VARCHAR2(64);
/

Rem PURPOSE
Rem Used to define ValidIf Conditions for a metric /collection Item
Rem COLUMNS
Rem CATPROP_1_CHOICES  : Choices for the category property 1
Rem CATPROP_2_CHOICES  : Choices for the category property 2
Rem CATPROP_3_CHOICES  : Choices for the category property 3
Rem CATPROP_4_CHOICES  : Choices for the category property 4
Rem CATPROP_5_CHOICES  : Choices for the category property 5
CREATE OR REPLACE TYPE MGMT_VALIDIF_OBJ IS OBJECT
(
    catprop_1_choices MGMT_CATEGORY_PROP_ARRAY,
    catprop_2_choices MGMT_CATEGORY_PROP_ARRAY,
    catprop_3_choices MGMT_CATEGORY_PROP_ARRAY,
    catprop_4_choices MGMT_CATEGORY_PROP_ARRAY,
    catprop_5_choices MGMT_CATEGORY_PROP_ARRAY,
    STATIC FUNCTION NEW(
        p_catprop_1_choices IN MGMT_CATEGORY_PROP_ARRAY DEFAULT NULL,
        p_catprop_2_choices IN MGMT_CATEGORY_PROP_ARRAY DEFAULT NULL,
        p_catprop_3_choices IN MGMT_CATEGORY_PROP_ARRAY DEFAULT NULL,
        p_catprop_4_choices IN MGMT_CATEGORY_PROP_ARRAY DEFAULT NULL,
        p_catprop_5_choices IN MGMT_CATEGORY_PROP_ARRAY DEFAULT NULL)
    RETURN MGMT_VALIDIF_OBJ
);
/


CREATE OR REPLACE TYPE MGMT_VALIDIF_ARRAY IS TABLE OF MGMT_VALIDIF_OBJ;
/

CREATE OR REPLACE TYPE MGMT_CATEGORY_DEF_OBJ IS OBJECT
(
    category_name       VARCHAR2(64),
    category_name_nlsid VARCHAR2(64),
    STATIC FUNCTION NEW(
        p_category_name       IN VARCHAR2,
        p_category_name_nlsid IN VARCHAR2 DEFAULT NULL
      )
    RETURN MGMT_CATEGORY_DEF_OBJ
);
/


CREATE OR REPLACE TYPE MGMT_CATEGORY_DEF_ARRAY IS TABLE OF MGMT_CATEGORY_DEF_OBJ;
/

CREATE OR REPLACE TYPE MGMT_CATEGORY_OBJ IS OBJECT
(
    class_name       VARCHAR2(64),
    category_name    VARCHAR2(64),
    STATIC FUNCTION NEW(
        p_class_name        IN VARCHAR2,
        p_category_name     IN VARCHAR2
      )
    RETURN MGMT_CATEGORY_OBJ
);
/

CREATE OR REPLACE TYPE MGMT_CATEGORY_ARRAY IS TABLE OF MGMT_CATEGORY_OBJ;
/

CREATE OR REPLACE TYPE MGMT_SNAPSHOT_OBJ IS OBJECT
(
    target_type      VARCHAR2(64),
    snapshot_name    VARCHAR2(64),
    store_metric     NUMBER(1),
    STATIC FUNCTION NEW(
        p_target_type    IN VARCHAR2,
        p_snapshot_name  IN VARCHAR2,
        p_store_metric   IN NUMBER DEFAULT 0
      )
    RETURN MGMT_SNAPSHOT_OBJ
);
/

CREATE OR REPLACE TYPE MGMT_SNAPSHOT_ARRAY IS TABLE OF MGMT_SNAPSHOT_OBJ;
/

Rem PURPOSE
Rem Used to define metric column for a table metric.
CREATE OR REPLACE TYPE MGMT_METRIC_COLUMN_OBJ IS OBJECT
(
    column_name          VARCHAR2(64),
    column_type          NUMBER(2),
    is_key               NUMBER(1),
    column_label         VARCHAR2(64),
    column_label_nlsid   VARCHAR2(64),
    description          VARCHAR2(128),
    description_nlsid    VARCHAR2(64),
    unit                 VARCHAR2(64),
    unit_nlsid           VARCHAR2(64),
    short_name           VARCHAR2(64),
    short_name_nlsid     VARCHAR2(64),
    is_for_summary       NUMBER(1),
    statefull            NUMBER(1),
    source_type          NUMBER(1),
    source               VARCHAR2(4000),
    non_thresholded_alerts NUMBER(1),
    keyonly_thresholds   NUMBER(1),
    is_renderable        NUMBER(1),
    category_list        MGMT_CATEGORY_ARRAY,
    STATIC FUNCTION NEW(
        p_column_name        IN VARCHAR2,
        p_column_type        IN NUMBER,
        p_is_key             IN NUMBER   DEFAULT 0,
        p_column_label       IN VARCHAR2 DEFAULT NULL,
        p_column_label_nlsid IN VARCHAR2 DEFAULT NULL,
        p_description        IN VARCHAR2 DEFAULT ' ',
        p_description_nlsid  IN VARCHAR2 DEFAULT NULL,
        p_unit               IN VARCHAR2 DEFAULT ' ',
        p_unit_nlsid         IN VARCHAR2 DEFAULT NULL,
        p_short_name         IN VARCHAR2 DEFAULT NULL,
        p_short_name_nlsid   IN VARCHAR2 DEFAULT NULL,
        p_is_for_summary     IN NUMBER   DEFAULT 0,
        p_statefull          IN NUMBER   DEFAULT 1,
        p_source_type        IN NUMBER   DEFAULT 0,
        p_source             IN VARCHAR2 DEFAULT NULL,
	p_non_thresholded_alerts IN NUMBER DEFAULT 0,
	p_keyonly_thresholds IN NUMBER DEFAULT 0,
        p_is_renderable      IN NUMBER DEFAULT 1,
        p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL
      ) 
    RETURN MGMT_METRIC_COLUMN_OBJ
);
/

CREATE OR REPLACE TYPE MGMT_METRIC_COLUMN_ARRAY IS TABLE OF MGMT_METRIC_COLUMN_OBJ;
/

CREATE OR REPLACE TYPE MGMT_KEY_VALUE_OBJ AS VARRAY(5) OF VARCHAR2(256) 
/

CREATE OR REPLACE TYPE MGMT_KEY_VALUE_ARRAY AS TABLE OF MGMT_KEY_VALUE_OBJ
/

