Rem
Rem $Header: notification_init.sql 16-may-2005.15:11:46 rpinnama Exp $
Rem
Rem notification_init.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      notification_init.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpinnama    05/16/05 - rpinnama_bug-4331862_main
Rem    rpinnama    05/12/05 - Created
Rem

Rem
Rem Register the target deleted callback
Rem
DECLARE 
  del_exceptions SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN
  em_target.add_tgt_pre_deletion_callback('EMD_NOTIFICATION.HANDLE_TARGET_DELETED');

  -- Add deletion exceptions here
  del_exceptions.extend(2);
  del_exceptions(1) := 'MGMT_NOTIFY_RULE_CONFIGS';
  del_exceptions(2) := 'MGMT_NOTIFY_JOB_RULE_CONFIGS';
  MGMT_ADMIN.add_target_deletion_exceptions(del_exceptions);
END;   
/
show errors;

-- Register the format handlers
BEGIN
  INSERT INTO MGMT_NOTIFY_FORMAT_HANDLERS (source_obj_type, class_name)
  VALUES (EMD_NOTIFICATION.METRIC_SEVERITY,
          'oracle.sysman.emdrep.notification.FormatViolation');

  INSERT INTO MGMT_NOTIFY_FORMAT_HANDLERS (source_obj_type, class_name)
  VALUES (EMD_NOTIFICATION.RCA_COMPLETED_SEVERITY,
          'oracle.sysman.emdrep.notification.FormatViolation');

  INSERT INTO MGMT_NOTIFY_FORMAT_HANDLERS (source_obj_type, class_name)
  VALUES (EMD_NOTIFICATION.POLICY_VIOLATION,
          'oracle.sysman.emdrep.notification.FormatViolation');

  INSERT INTO MGMT_NOTIFY_FORMAT_HANDLERS (source_obj_type, class_name)
  VALUES (EMD_NOTIFICATION.JOB_STATE_CHANGE,
          'oracle.sysman.emdrep.notification.FormatJob');

  INSERT INTO MGMT_NOTIFY_FORMAT_HANDLERS (source_obj_type, class_name)
  VALUES (EMD_NOTIFICATION.METRIC_CA_STATE_CHANGE,
          'oracle.sysman.emdrep.notification.FormatJob');

  INSERT INTO MGMT_NOTIFY_FORMAT_HANDLERS (source_obj_type, class_name)
  VALUES (EMD_NOTIFICATION.POLICY_CA_STATE_CHANGE,
          'oracle.sysman.emdrep.notification.FormatJob');

  COMMIT;
END;
/


