Rem
Rem $Header: policy_init.sql 19-aug-2005.02:47:08 jsadras Exp $
Rem
Rem policy_init.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      policy_init.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     08/19/05 - change add_metaver_upd_callback to 
Rem                           add_metaver_catprop_callback 
Rem    rpinnama    06/16/05 - Register target type ver upd callback
Rem    rpinnama    05/13/05 - rpinnama_bug-4331862
Rem    rpinnama    05/12/05 - Created
Rem

-- Add target addition callback to auto associate policies.
BEGIN
  mgmt_admin.add_target_addition_callback('EM_POLICY.auto_associate_policies');
  commit;
EXCEPTION
  WHEN OTHERS
    THEN 
      dbms_output.put_line( 'EXCEPTION registering add_target callback '|| SQLCODE );
      RAISE;
END;
/

-- Add target deletion callback to delete policy data
BEGIN
  MGMT_ADMIN.add_target_deletion_callback('EM_POLICY.handle_target_delete');

END;
/


-- Add target meta ver update callback to re-associate policies
BEGIN
  MGMT_TARGET.add_metaver_catprop_callback(
    p_callback_name => 'EM_POLICY.handle_type_meta_ver_change',
    p_target_type => ' ');
EXCEPTION
  WHEN OTHERS THEN
    -- Ignore duplicate registrations
    dbms_output.put_line( 'EXCEPTION registering meta ver update callback '|| SQLCODE );
    NULL;
END;
/


--
-- Register the module for performance logging
-- 
BEGIN
  mgmt_log.register_logging_module (EM_POLICY.G_MODULE_NAME,
                                    'Policy Evaluation') ;
  COMMIT;
END;
/

BEGIN
  mgmt_target.add_tgttype_addition_callback(
    p_callback_name => 'em_policy.handle_tgttype_addition');
  COMMIT;
END;
/

