Rem
Rem $Header: policy_tables.sql 02-aug-2005.00:08:04 niramach Exp $
Rem
Rem policy_tables.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      policy_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    niramach    08/02/05 - Move the delta from v102010 to v102020. 
Rem    jsadras     07/06/05 - add compress to 
Rem                           policy_assoc/policy_assoc_cfg_params 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    rpinnama    03/01/05 - rpinnama_bug-3924067
Rem    rpinnama    02/25/05 - Created
Rem


CREATE TABLE mgmt_policies
(
    policy_guid             RAW(16)        NOT NULL,
    policy_name             VARCHAR2(128)  NOT NULL,
    metric_guid             RAW(16)        NOT NULL,
    target_type             VARCHAR2(64)   NOT NULL,
    start_type_meta_ver     VARCHAR2(8)    DEFAULT '1.0',
    end_type_meta_ver       VARCHAR2(8)    DEFAULT NULL,
    policy_type             NUMBER(1)      DEFAULT 1,
    policy_label_nlsid      VARCHAR2(64)   DEFAULT NULL,
    description             VARCHAR2(256)  DEFAULT NULL,
    description_nlsid       VARCHAR2(64)   DEFAULT NULL,
    author                  VARCHAR2(256)  DEFAULT 'ORACLE',
    auto_enable             NUMBER(1)      DEFAULT 0,
    impact                  VARCHAR2(500)  DEFAULT ' ',
    impact_nlsid            VARCHAR2(64)   DEFAULT NULL,
    recommendation          VARCHAR2(500)  DEFAULT ' ',
    recommendation_nlsid    VARCHAR2(64)   DEFAULT NULL,
    violation_level         NUMBER         DEFAULT NULL,
    condition_type          NUMBER(1)      DEFAULT 1,
    condition               VARCHAR2(4000) DEFAULT NULL,
    condition_operator      NUMBER         DEFAULT 0,
    detailed_url_link       VARCHAR2(4000) DEFAULT NULL,
    message                 VARCHAR2(4000) DEFAULT NULL,
    message_nlsid           VARCHAR2(64)   DEFAULT NULL,
    clear_message           VARCHAR2(4000) DEFAULT NULL,
    clear_message_nlsid     VARCHAR2(64)   DEFAULT NULL,
    owner                   VARCHAR2(256)  DEFAULT '<SYSTEM>',
    created_date            DATE           DEFAULT SYSDATE,
    last_updated_date       DATE           DEFAULT SYSDATE,
    last_updated_by         VARCHAR2(256)  DEFAULT '<SYSTEM>',
    cs_consider_percentage  NUMBER(1)      DEFAULT 1,
    repo_timing_enabled     NUMBER(1)      DEFAULT 0
)
MONITORING;

COMMENT ON TABLE mgmt_policies IS
    'This table provides the policy rule description.';

COMMENT ON COLUMN mgmt_policies.policy_guid IS
    ' The unique Id of the policy rule.';

COMMENT ON COLUMN mgmt_policies.policy_name IS
    ' The name of the policy rule.';

COMMENT ON COLUMN mgmt_policies.target_type IS
    ' The target type on which this policy rule is applicable.';

COMMENT ON COLUMN mgmt_policies.start_type_meta_ver IS
    'The starting metadata version of the target type from which
     this policy is applicable.';

COMMENT ON COLUMN mgmt_policies.end_type_meta_ver IS
    'The ending metadata version of the target type upto which the
     policy is applicable.';

COMMENT ON COLUMN mgmt_policies.metric_guid IS
    'The metric on which this policy rule is defined.';

COMMENT ON COLUMN mgmt_policies.policy_type IS
    ' The type of the policy rule. Identifies whether the rule
     is for a threshold monitoring metric or for a policy. Valid values are :
       1 for threshold metric
       2 for policies.';

COMMENT ON COLUMN mgmt_policies.policy_label_nlsid IS
    ' The NLSID of the policy rule name.';

COMMENT ON COLUMN mgmt_policies.description IS
    ' The description of the Policy rule.';

COMMENT ON COLUMN mgmt_policies.description_nlsid IS
    ' The NLSID of the policy rule description.';
    
COMMENT ON COLUMN mgmt_policies.author IS
    ' The author of the policy rule.';

COMMENT ON COLUMN mgmt_policies.condition_type IS
    'Allowed condition types are 
   1. Simple condition
   2. SQL expression condition 
   3. PL/SQL procedure for evaluating condition.';

COMMENT ON COLUMN mgmt_policies.condition IS
    'If condition_type 
 = 1, this column contains the metric_column_name
 = 2, this column contains the conditional expression
 = 3, this column contains the pl/sql procedure name that peforms the condition..';

COMMENT ON COLUMN mgmt_policies.condition_operator IS
    'Applicable only if the condition_type = 1
         0 - GT
         1 - EQ
         2 - LT
         3 - LE
         4 - GE
         5 - CONTAINS
         6 - NE
         7 - MATCH    :  regular expression';

COMMENT ON COLUMN mgmt_policies.detailed_url_link IS
    'URL to be used for additional detailed information regarding the policy.';

COMMENT ON COLUMN mgmt_policies.message IS
    'Message with columns referenced either by column order or name.';

COMMENT ON COLUMN mgmt_policies.message_nlsid IS
    'NLSID of the message.';

COMMENT ON COLUMN mgmt_policies.clear_message IS
    'Message template to be used to generate clear severity message.
     Message with columns referenced either by column order or name.';

COMMENT ON COLUMN mgmt_policies.clear_message_nlsid IS
    'NLSID of the clear message.';

COMMENT ON COLUMN mgmt_policies.owner IS
    'The EM user who create the policy in the repository.';

COMMENT ON COLUMN mgmt_policies.created_date IS
    'The date/time when the policy was created.';

COMMENT ON COLUMN mgmt_policies.last_updated_date IS
    'The date/time when the policy was last modified.';

COMMENT ON COLUMN mgmt_policies.last_updated_by IS
    'The EM user name who last modified this policy.';

COMMENT ON COLUMN mgmt_policies.cs_consider_percentage IS
    'Flag indicating whether or not percentage of objects with violations
     is considered when computing the policy compliance score.';

COMMENT ON COLUMN mgmt_policies.repo_timing_enabled IS
    'Flag indicating whether the policy times are logged 
     0 = Timing information is not logged to system performance log,
     1 = Timing information not logged to system performance log' ;



CREATE TABLE mgmt_policy_parameters
( 
    policy_guid      RAW(16)       NOT NULL,
    param_name       VARCHAR2(64)  NOT NULL,
    param_name_nlsid VARCHAR2(64)  DEFAULT NULL,
    param_type       NUMBER(1)     DEFAULT 1
)
MONITORING; 

COMMENT ON TABLE mgmt_policy_parameters IS
    'This table stores the list of all possible policy parameters.';

COMMENT ON COLUMN mgmt_policy_parameters.policy_guid IS
    'The policy guid for which the parameter is defined.';

COMMENT ON COLUMN mgmt_policy_parameters.param_name IS
    'The name of the policy parameter.';

COMMENT ON COLUMN mgmt_policy_parameters.param_name_nlsid IS
    'The NLSID of the policy parameter.';
    
COMMENT ON COLUMN mgmt_policy_parameters.param_type IS
    'The type of the policy parameter. Possible values are :
       1 for NUMERIC
       2 for STRING';



CREATE TABLE mgmt_policy_bind_vars
(
    policy_guid      RAW(16)      NOT NULL,
    bind_column_name VARCHAR2(30) NOT NULL,
    bind_column_type NUMBER(1)    DEFAULT 1,
    CONSTRAINT mgmt_policy_bind_vars_pk
    PRIMARY KEY(policy_guid, bind_column_name)
)
ORGANIZATION INDEX
OVERFLOW INCLUDING bind_column_type
MONITORING;

COMMENT ON TABLE mgmt_policy_bind_vars IS
    'This table stores the list of bind variables to be used to evaluate
     the condition.';

COMMENT ON COLUMN mgmt_policy_bind_vars.policy_guid IS
    'This policy guid for which the bind variable are defined.';

COMMENT ON COLUMN mgmt_policy_bind_vars.bind_column_name IS
    'The name of the bind variable to be bound.';

COMMENT ON COLUMN mgmt_policy_bind_vars.bind_column_type IS
    'The type of the bind variable to be bound. Possible values are :
     1 - parameter to be bound is a metric column name.
     2 - parameter to be bound is a policy parameter';







CREATE TABLE mgmt_policy_viol_ctxt_def
(
    policy_guid            RAW(16)        NOT NULL,
    column_name            VARCHAR2(64)   NOT NULL,
    metric_guid            RAW(16)        NOT NULL,
    column_position        NUMBER         DEFAULT 0,
    is_hidden              NUMBER(1)      DEFAULT 0,
    url_link_template      VARCHAR2(4000) DEFAULT NULL,
    url_link_type          NUMBER(1)      DEFAULT 0
)
MONITORING;

COMMENT ON TABLE mgmt_policy_viol_ctxt_def IS
    'This table defines policy violation context definition for all policies.';

COMMENT ON COLUMN mgmt_policy_viol_ctxt_def.policy_guid IS
    'The guid of the policy.';

COMMENT ON COLUMN mgmt_policy_viol_ctxt_def.column_name IS
    'The column name to be included in the policy violation context.';

COMMENT ON COLUMN mgmt_policy_viol_ctxt_def.metric_guid IS 
    'The metric guid of the column name, if the column name is a metric
     column name. NULL, for non-metric column names.';

COMMENT ON COLUMN mgmt_policy_viol_ctxt_def.column_position IS
    'The position of the column name with in the context definition.';

COMMENT ON COLUMN mgmt_policy_viol_ctxt_def.is_hidden IS
    'Flag indicating whether or not the value for this metric (data source)
     column should be displayed when viewing a violation.  Default 0.';

COMMENT ON COLUMN mgmt_policy_viol_ctxt_def.url_link_template IS
    'URL template that contains references to any metric (data source) column 
     name defined in the metric (data source).  The actual values are
     substituted in at run-time to construct a URL that is associated with
     this metric columns value.  Default NULL.';

COMMENT ON COLUMN mgmt_policy_viol_ctxt_def.url_link_type IS
    'JSP by default, Maybe be UIX.  Important because the encoding is
     different.  The data plugged into the template needs to be appropriately
     encoded by the code.  This will key the code as to how to do the
     encoding.';



CREATE TABLE mgmt_policy_type_versions
(
    policy_guid        RAW(16)      NOT NULL,
    type_meta_ver      VARCHAR2(8)  DEFAULT '1.0',
    CONSTRAINT mgmt_policy_meta_versions_pk
    PRIMARY KEY (policy_guid, type_meta_ver)
)
ORGANIZATION INDEX
MONITORING;

COMMENT ON TABLE mgmt_policy_type_versions IS
    'This table stores the list of type meta versions for which a policy is applicable to.';

COMMENT ON COLUMN mgmt_policy_type_versions.policy_guid IS
    'The policy guid.';

COMMENT ON COLUMN mgmt_policy_type_versions.type_meta_ver IS
    'The metadata version of the target type for which this policy is applicable.';


CREATE TABLE mgmt_policy_assoc
(
    object_guid        RAW(16)      NOT NULL,
    policy_guid        RAW(16)      NOT NULL,
    coll_name          VARCHAR2(64) DEFAULT ' ',
    object_type        NUMBER(1)    DEFAULT 1,
    policy_type        NUMBER(1)    DEFAULT 1,
    is_enabled         NUMBER(1)    DEFAULT 1,
    CONSTRAINT mgmt_policy_assoc_pk
    PRIMARY KEY (object_guid,policy_guid,coll_name)
)
ORGANIZATION INDEX
OVERFLOW INCLUDING is_enabled
MONITORING;

COMMENT ON TABLE mgmt_policy_assoc IS
    'This table stores the policy to target/template associations.';

COMMENT ON COLUMN mgmt_policy_assoc.policy_guid IS
    'The metric/policy guid.';

COMMENT ON COLUMN mgmt_policy_assoc.object_guid IS
    'The guid of the target/template/default associated with the policy.';

COMMENT ON COLUMN mgmt_policy_assoc.coll_name IS
    'The collection name for which this policy association is defined.';

COMMENT ON COLUMN mgmt_policy_assoc.object_type IS
    'The type of guid stored in OBJECT_guid. Possible values are:
     = 1, for default policy
     = 2, for target
     = 3, for template';

COMMENT ON COLUMN mgmt_policy_assoc.policy_type IS
    'The type of policy stored in policy_guid. Possible values are:
     = 1, for metric thresholds
     = 2, for repository policies';

COMMENT ON COLUMN mgmt_policy_assoc.is_enabled IS
    'Flag to specify whether the policy is enabled/disabled for the
     specified target/template.';


CREATE TABLE mgmt_policy_assoc_cfg
(
    object_guid           RAW(16)       NOT NULL,
    policy_guid           RAW(16)       NOT NULL,
    coll_name             VARCHAR2(64)  DEFAULT ' ',
    key_value             VARCHAR2(256) DEFAULT ' ',
    key_operator          NUMBER        DEFAULT 0,
    eval_order            NUMBER        DEFAULT 1,
    is_exception          NUMBER(1)     DEFAULT 0,
    has_active_baseline   NUMBER(1)     DEFAULT 0,
    prevent_override      NUMBER(1)     DEFAULT 0,
    crit_action_job_id    RAW(16)       DEFAULT NULL,
    warn_action_job_id    RAW(16)       DEFAULT NULL,
    info_action_job_id    RAW(16)       DEFAULT NULL,
    fixit_job             VARCHAR2(128) DEFAULT NULL,
    simultaneous_actions  NUMBER(1)     DEFAULT 1,
    importance            NUMBER        DEFAULT NULL,
    num_occurrences       NUMBER        DEFAULT 1,
    is_push               NUMBER(1)     DEFAULT 0,
    condition_operator    NUMBER        DEFAULT 0,
    message               VARCHAR2(4000) DEFAULT NULL,
    message_nlsid         VARCHAR2(64)  DEFAULT NULL,
    clear_message         VARCHAR2(4000) DEFAULT NULL,
    clear_message_nlsid   VARCHAR2(64)  DEFAULT NULL
)
MONITORING;

COMMENT ON TABLE mgmt_policy_assoc_cfg IS
    'This table stores the configuration for a key value of
     target/template policy associations.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.policy_guid IS
    'The metric/policy guid.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.object_guid IS
    'The guid of the target/template/default associated with the policy.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.key_value IS
    'The key value for which the configuration is defined.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.key_operator IS
    'Specifies whether the key_value column has any SQL wildcards.
     For single key column metrics, the value is 1 if the key_value has
     Wildcard characters, 0 otherwise.
     For metrics with multiple keys, a list of operators for all key columns
     Will be stored here. For example, a metric with 3 keys (k1, k2, k3) where
     K1 and K2 use wildcards and K3 uses exact match, then 011 is stored in
     This column.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.eval_order IS
    'The order in which the configuration of the key_value is applied.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.is_exception IS
    'The is a flag that specifies that the metric rows with this key_value
     are treated as exception and no threshold/policy tests are performed.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.has_active_baseline Is
    'The is a flag that specifies that the metric rows with this key_value
     has an active baseline and any user updates to thresholds/parameter values
     should be ignored.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.prevent_override IS
    'The is a flag that specifies that the metric rows with this key_value
     has a tempalte override flag. Once the tempalte override flag is ON, any
     template application will not update the threshold/parameter values.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.crit_action_job_id IS
    'The critical corrective action job ID.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.warn_action_job_id iS
    'The warning corrective action job ID.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.info_action_job_id IS
    'The information corrective action job ID.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.fixit_job is
    'The agent response action.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.simultaneous_actions is
    'Flag to specify whether simultaneous correction action jobs can be run.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.importance is
    'Weight override per key.';
    
COMMENT ON COLUMN mgmt_policy_assoc_cfg.num_occurrences is
    'The number of times the test has to trigger to raise a violation.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.is_push is
    'This identifies whether the config is for a PUSH descriptor.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.condition_operator is
    'Defines the threshold condition to be applied
         0 - GT
         1 - EQ
         2 - LT
         3 - LE
         4 - GE
         5 - CONTAINS
         6 - NE
         7 - MATCH    :  regular expression';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.message IS
    'Message template to be used to generate severity message.
     Message can contain columns referenced either by column order or name.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.message_nlsid IS
    'NLSID of the message.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.clear_message IS
    'Message template to be used to generate clear severity message.
     Message can contain columns referenced either by column order or name.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg.clear_message_nlsid IS
    'NLSID of the clear message.';



CREATE TABLE mgmt_policy_assoc_cfg_params
(
    object_guid           RAW(16)       NOT NULL,
    policy_guid           RAW(16)       NOT NULL,
    coll_name             VARCHAR2(64)  DEFAULT ' ',
    key_value             VARCHAR2(256) DEFAULT ' ',
    key_operator          NUMBER        DEFAULT 0,
    param_name            VARCHAR2(64)  DEFAULT ' ',
    crit_threshold        VARCHAR2(256) DEFAULT ' ',
    warn_threshold        VARCHAR2(256) DEFAULT ' ',
    info_threshold        VARCHAR2(256) DEFAULT ' ',
    CONSTRAINT mgmt_policy_assoc_cfg_param_pk
    PRIMARY KEY(object_guid, policy_guid, coll_name, key_value, 
                key_operator, param_name)
)
ORGANIZATION INDEX
OVERFLOW INCLUDING info_threshold
MONITORING;

COMMENT ON TABLE mgmt_policy_assoc_cfg_params IS
    'This table stores the  parameter threshold values for a key
     configuration  of  target/template policy associations.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg_params.policy_guid iS
    'The metric/policy guid.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg_params.object_guid is
    'The guid of the target/template/default associated with the policy.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg_params.key_value is
    'The key value for which the configuration is defined.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg_params.key_operator iS
    'Specifies whether the key_value column has any SQL wildcards. 
     For single key column metrics, the value is 1 if the key_value has
     Wildcard characters, 0 otherwise. 
     For metrics with multiple keys, a list of operators for all key columns
     Will be stored here. For example, a metric with 3 keys (k1, k2, k3) where
     K1 and K2 use wildcards and K3 uses exact match, then 011 is stored in
     This column.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg_params.param_name is
    'The policy parameter name for which thresholds are specified.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg_params.crit_threshold is
    'The critical threshold value of the policy parameter name for the
     given target-policy association and key configuration.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg_params.warn_threshold is
    'The warning threshold value of the policy parameter name for the
     given target-policy association and key configuration.';

COMMENT ON COLUMN mgmt_policy_assoc_cfg_params.info_threshold iS
    'The information threshold value of the policy parameter name for the
     given target-policy association and key configuration.';





CREATE TABLE mgmt_policy_assoc_eval_summ
( 
    target_guid           RAW(16)      NOT NULL,
    policy_guid           RAW(16)      NOT NULL,
    coll_name             VARCHAR2(64) DEFAULT ' ',
    last_evaluation_date  DATE         DEFAULT NULL,
    rows_evaluated        NUMBER       DEFAULT 0,
    total_violations_logged NUMBER     DEFAULT 0,
    non_exempt_violations_logged NUMBER DEFAULT 0,
    max_violation_level   NUMBER       DEFAULT 0,
    compliance_score      NUMBER       DEFAULT 0
)   
MONITORING;


COMMENT ON TABLE mgmt_policy_assoc_eval_summ IS
    'This table stores the  policy evaluation summary details for a target.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_summ.target_guid IS
    'The target for which the evaluation summary is stored.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_summ.policy_guid IS
    'The policy for which the evaluation summary is stored.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_summ.coll_name IS
    'The collection item for which the evaluation summary is stored.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_summ.last_evaluation_date IS
    'The last date on which the policy was evaluated for the target 
     for the collection item.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_summ.rows_evaluated IS
    'The number of rows evaluated during the last evaluation.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_summ.total_violations_logged IS
    'The number of violations logged for the given target policy association.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_summ.non_exempt_violations_logged IS
    'The number of non-exempt violations logged for the given target policy association.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_summ.max_violation_level IS
    'The maximum violation level of all the violations logged for the given 
     target policy association.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_summ.compliance_score IS
    'The compliance score calculated for the target policy association.';


CREATE TABLE mgmt_policy_assoc_eval_details
(
    target_guid           RAW(16)        NOT NULL,
    policy_guid           RAW(16)        NOT NULL,
    coll_name             VARCHAR2(64)   DEFAULT ' ',
    result_key_value      VARCHAR2(256)  DEFAULT ' ',
    info_counter          NUMBER         DEFAULT 0,
    warn_counter          NUMBER         DEFAULT 0,
    crit_counter          NUMBER         DEFAULT 0,
    last_evaluation_date  DATE           DEFAULT NULL,
    last_error_message    VARCHAR2(2000) DEFAULT NULL,
    cfg_key_value         VARCHAR2(256)  DEFAULT NULL,
    cfg_key_operator      NUMBER         DEFAULT 0
)
MONITORING;


COMMENT ON TABLE mgmt_policy_assoc_eval_details IS
    'This table stores the detailed policy evaluation state.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_details.target_guid IS
    'The target for which the evaluation status is stored.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_details.policy_guid IS
    'The policy guid for which the evaluation status is stored.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_details.coll_name IS
    'The collection name for which the evaluation status is stored.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_details.result_key_value IS
    'The key value for which the evaluation status is stored.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_details.info_counter IS
    'The number of successive times the policy evaluation has trigger to 
     an info or higher violation level  for the target-policy-key_value
     combination'; 

COMMENT ON COLUMN mgmt_policy_assoc_eval_details.warn_counter IS
    'The number of successive times the policy evaluation has trigger to 
     a WARNING or higher violation level  for the target-policy-key_value
     combination'; 

COMMENT ON COLUMN mgmt_policy_assoc_eval_details.crit_counter IS
    'The number of successive times the policy evaluation has trigger to 
     CRITICAL violation level  for the target-policy-key_value
     combination'; 

COMMENT ON COLUMN mgmt_policy_assoc_eval_details.last_evaluation_date IS
    'The date/time at which the last policy evaluation happened for the
     given target-policy-key_value combination.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_details.last_error_message IS
    'The error message (if any) for the last policy evaluation happened for the
     given target-policy-key_value combination. If the policy evaluation was
     successful, the error message column would be NULL.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_details.cfg_key_value IS
    'The key value of the configuration that is used to evaluate the policy
     for the target/key_value.';

COMMENT ON COLUMN mgmt_policy_assoc_eval_details.cfg_key_operator IS
    'The key operator of gthe configuration that is used to evaluate the 
    policy for the target/key_value.';



CREATE TABLE mgmt_snapshot_metric_map
(
    snapshot_target_type VARCHAR2(64) NOT NULL,
    snapshot_name        VARCHAR2(64) NOT NULL,
    metric_guid          RAW(16)      NOT NULL,
    store_metric         NUMBER(1)    DEFAULT 0 NOT NULL,
    CONSTRAINT mgmt_snapshot_metric_map_pk
    PRIMARY KEY(snapshot_target_type, snapshot_name, metric_guid)
)
ORGANIZATION INDEX
OVERFLOW INCLUDING store_metric
MONITORING;


COMMENT ON TABLE mgmt_snapshot_metric_map IS
    'This table stores the snapshot to metric map.';

COMMENT ON COLUMN mgmt_snapshot_metric_map.snapshot_target_type IS
    'The target type of the snap shot.';

COMMENT ON COLUMN mgmt_snapshot_metric_map.snapshot_name IS
    'The Name of the snapshot.';

COMMENT ON COLUMN mgmt_snapshot_metric_map.metric_guid IS
    'The GUID of the metric.';

COMMENT ON COLUMN mgmt_snapshot_metric_map.store_metric IS
    'Does the results of metric collection for this snapshot need to be stored
     1=Store, 0=Do not store ( Default)' ;

