Rem
Rem $Header: policy_types.sql 29-jun-2005.01:46:40 gsbhatia Exp $
Rem
Rem policy_types.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      policy_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    rpinnama    03/01/05 - rpinnama_bug-3924067
Rem    rpinnama    02/25/05 - Created
Rem


CREATE OR REPLACE TYPE MGMT_POLICY_PARAM_DEF IS OBJECT
(
    param_name         VARCHAR2(64),
    param_name_nlsid   VARCHAR2(64),
    param_type         NUMBER,
    STATIC FUNCTION NEW( 
        p_param_name       IN VARCHAR2,
        p_param_name_nlsid IN VARCHAR2 DEFAULT NULL,
        p_param_type       IN NUMBER DEFAULT 0
      ) 
    RETURN MGMT_POLICY_PARAM_DEF
);
/

CREATE OR REPLACE TYPE MGMT_POLICY_PARAM_DEF_ARRAY IS TABLE OF MGMT_POLICY_PARAM_DEF;
/

CREATE OR REPLACE TYPE MGMT_POLICY_PARAM_VAL IS OBJECT 
(
    param_name         VARCHAR2(64),
    crit_threshold     VARCHAR2(256),
    warn_threshold     VARCHAR2(256),
    info_threshold     VARCHAR2(256),
    STATIC FUNCTION NEW( 
        p_param_name     IN VARCHAR2,
        p_crit_threshold IN VARCHAR2 DEFAULT NULL,
        p_warn_threshold IN VARCHAR2 DEFAULT NULL,
        p_info_threshold IN VARCHAR2 DEFAULT NULL
      ) 
    RETURN MGMT_POLICY_PARAM_VAL
);
/

CREATE OR REPLACE TYPE MGMT_POLICY_PARAM_VAL_ARRAY IS TABLE OF MGMT_POLICY_PARAM_VAL;
/

CREATE OR REPLACE TYPE MGMT_POLICY_KEY_COL_COND IS OBJECT 
(
    key_value        VARCHAR2(256),
    has_wildcard     NUMBER(1),
    key_column_name  VARCHAR2(256),
    STATIC FUNCTION NEW( 
        p_key_value       IN VARCHAR2 DEFAULT '%',
        p_has_wildcard    IN NUMBER   DEFAULT 1,
        p_key_column_name IN VARCHAR2 DEFAULT NULL
      ) 
    RETURN MGMT_POLICY_KEY_COL_COND
);
/

CREATE OR REPLACE TYPE MGMT_POLICY_KEY_COL_COND_ARRAY IS TABLE OF MGMT_POLICY_KEY_COL_COND;
/


CREATE OR REPLACE TYPE MGMT_POLICY_KEY_VAL IS OBJECT
(
    key_value             MGMT_POLICY_KEY_COL_COND_ARRAY,
    is_exception          NUMBER(1),
    prevent_override      NUMBER(1),
    crit_action_name      VARCHAR2(64),
    warn_action_name      VARCHAR2(64),
    info_action_name      VARCHAR2(64),
    agent_fixit           VARCHAR2(256),
    simultaneous_actions  NUMBER(1),
    importance            NUMBER,
    num_occurrences       NUMBER,
    is_push               NUMBER(1),
    condition_operator    NUMBER,
    message               VARCHAR2(4000),
    message_nlsid         VARCHAR2(64),
    clear_message         VARCHAR2(4000),
    clear_message_nlsid   VARCHAR2(64),
    param_values          MGMT_POLICY_PARAM_VAL_ARRAY,
    STATIC FUNCTION NEW(
        p_key_value        IN MGMT_POLICY_KEY_COL_COND_ARRAY DEFAULT NULL,
        p_is_exception     IN NUMBER   DEFAULT 0,
        p_prevent_override IN NUMBER   DEFAULT 0,
        p_crit_job_name    IN VARCHAR2 DEFAULT ' ',
        p_warn_job_name    IN VARCHAR2 DEFAULT ' ',
        p_info_job_name    IN VARCHAR2 DEFAULT ' ',
        p_agent_fixit      IN VARCHAR2 DEFAULT ' ',
        p_simult_actions   IN NUMBER   DEFAULT 1,
        p_importance       IN NUMBER   DEFAULT NULL,
        p_num_occurrences  IN NUMBER   DEFAULT 1,
	p_is_push          IN NUMBER   DEFAULT 0,
	p_condition_operator IN NUMBER DEFAULT NULL,
	p_message          IN VARCHAR2 DEFAULT NULL,
	p_message_nlsid    IN VARCHAR2 DEFAULT NULL,
	p_clear_message    IN VARCHAR2 DEFAULT NULL,
	p_clear_message_nlsid IN VARCHAR2 DEFAULT NULL,
        p_param_values     IN MGMT_POLICY_PARAM_VAL_ARRAY DEFAULT NULL
      ) 
    RETURN MGMT_POLICY_KEY_VAL
);
/


CREATE OR REPLACE TYPE MGMT_POLICY_KEY_VAL_ARRAY IS TABLE OF MGMT_POLICY_KEY_VAL;
/


CREATE OR REPLACE TYPE MGMT_VIOL_CTXT_DEF IS OBJECT
(
    metric_column      VARCHAR2(64),
    is_hidden          NUMBER(1),
    url_link_template  VARCHAR2(4000),
    url_link_type      NUMBER,
    STATIC FUNCTION NEW(
        p_metric_column     IN VARCHAR2,
        p_is_hidden         IN NUMBER DEFAULT 0,
        p_url_link_template IN VARCHAR2 DEFAULT NULL,
        p_url_link_type     IN NUMBER DEFAULT 0
      )
    RETURN MGMT_VIOL_CTXT_DEF
);
/


CREATE OR REPLACE TYPE MGMT_VIOL_CTXT_DEF_ARRAY IS TABLE OF MGMT_VIOL_CTXT_DEF;
/

