Rem
Rem $Header: disabled_policies_by_target_reports.sql 20-apr-2005.07:42:32 niramach Exp $
Rem
Rem disabled_policies_by_target_reports.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      disabled_policies_by_target_reports.sql -  Disabled policies out of box report for single target
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    niramach    08/02/05 - Move delta between beta and production to 
Rem                           v102020. 
Rem    lgloyd      06/22/05 - normalize category strings 
Rem    niramach    06/14/05 - Add ORDER BY clause. 
Rem    niramach    04/28/05 - Remove the targettype column,count column and
Rem                           detail table since it is specific to single target  
Rem    niramach    04/28/05 - Fix for bug 4218501. 
Rem    niramach    04/20/05 - niramach_repos_upgrade
Rem    niramach    04/13/05 - UI review comments. 
Rem    niramach    03/01/05 - Add NLS Support. 
Rem    niramach    02/28/05 - niramach_policy_reports_fixes
Rem    niramach    02/23/05 - Created
Rem

SET DEFINE OFF

BEGIN
 
  DECLARE 
    l_param_values  MGMT_IP_PARAM_VALUE_LIST;
    l_target_types  MGMT_IP_TARGET_TYPES;    
    l_report_guid   RAW(16);
    l_element_guid  RAW(16);


  BEGIN
  
   -------------------------------------------------------------------
    -- Target Level Policies
    -------------------------------------------------------------------

    
    l_target_types := MGMT_IP_TARGET_TYPES();
    l_target_types.extend(1);
    l_target_types(1) := 'any_type';


    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                   => 'EMIPID_DISABLED_POLICIES_SINGLETARGET',
      p_description_nlsid             => 'DISABLEDPOLICIESBYTARGET_DESC',
      p_owner                         => 'SYSMAN',
      p_category_nlsid                => 'EMIPID_POLICIES',
      p_sub_category_nlsid            => 'DISABLED_POLICIES_HDR',
      p_late_binding_target_types     =>  l_target_types,
      p_late_binding_multi_targets    =>  0,
      p_show_table_of_contents        =>  0,
      p_system_report                 =>  1,
      p_help_topic_id                 => 'info_pub_gc_cs_pol_disab_sngl_target'
        );
 
 
    --Instruction text element
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(3);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage',
      'DISABLED_POLICIES_BY_TARGET_REP_DESC');
    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle',
      'OraInstructionText');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName',
      'oracle.sysman.eml.ecm.policy.util.PolicyJspMsg');
  
      
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid         => l_report_guid,
      p_element_name_nlsid  => 'IPMSG_STYLED_TEXT',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_header_nlsid        => null,
      p_element_order       => 1,
      p_element_row         => 1,
      p_parameters          => l_param_values,
      p_targets             => null
        );    
     --Summary table
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();

    l_param_values.extend(2);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'SELECT NVL(PM.MESSAGE, NVL(PEM.MESSAGE,R.POLICY_NAME)) AS "LBL_POLICYRULE",
       NVL(CM.MESSAGE, NVL(CEM.MESSAGE, R.CATEGORY)) AS "LBL_CATEGORY",
       COUNT(*) AS "LBL_NO_OF_TARGETS",
       NVL(t.type_display_name,tp.TARGET_TYPE) LBL_TYPE,
       NVL(DM.MESSAGE,NVL(DEM.MESSAGE,R.description)) AS "LBL_DESCRIPTION" 
       FROM mgmt$target_policies tp,mgmt$policies R,mgmt$target t,
       (SELECT MESSAGE, MESSAGE_ID FROM MGMT$MESSAGES
        WHERE SUBSYSTEM = ''POLICY''
            AND LANGUAGE_CODE = ??EMIP_BIND_LOCALE_LANGUAGE??
            AND COUNTRY_CODE = ??EMIP_BIND_LOCALE_COUNTRY??) PM,
        (SELECT MESSAGE, MESSAGE_ID FROM MGMT$MESSAGES
         WHERE SUBSYSTEM = ''POLICY''
            AND LANGUAGE_CODE = ''en''
            AND COUNTRY_CODE = '' '') PEM,
        (SELECT MESSAGE, MESSAGE_ID FROM MGMT$MESSAGES
         WHERE SUBSYSTEM = ''CATEGORY''
            AND LANGUAGE_CODE = ??EMIP_BIND_LOCALE_LANGUAGE??
            AND COUNTRY_CODE = ??EMIP_BIND_LOCALE_COUNTRY??) CM,
        (SELECT MESSAGE, MESSAGE_ID FROM MGMT$MESSAGES
         WHERE SUBSYSTEM = ''CATEGORY''
            AND LANGUAGE_CODE = ''en''
            AND COUNTRY_CODE = '' '') CEM,              
        (SELECT MESSAGE, MESSAGE_ID FROM MGMT$MESSAGES
         WHERE SUBSYSTEM = ''POLICY''
            AND LANGUAGE_CODE = ??EMIP_BIND_LOCALE_LANGUAGE??
            AND COUNTRY_CODE = ??EMIP_BIND_LOCALE_COUNTRY??) DM,
        (SELECT MESSAGE, MESSAGE_ID FROM MGMT$MESSAGES
         WHERE SUBSYSTEM = ''POLICY''
            AND LANGUAGE_CODE = ''en''
            AND COUNTRY_CODE = '' '') DEM              
       WHERE tp.IS_ENABLED=0 
       AND tp.target_guid= ??EMIP_BIND_TARGET_GUID?? 
       AND tp.target_guid = t.target_guid
       AND R.target_type=tp.target_type 
       AND R.policy_guid=tp.policy_guid 
       AND R.POLICY_LABEL_NLSID = PM.MESSAGE_ID (+)
       AND R.POLICY_LABEL_NLSID = PEM.MESSAGE_ID (+)
       AND R.CATEGORY_NLSID = CM.MESSAGE_ID(+)
       AND R.CATEGORY_NLSID = CEM.MESSAGE_ID(+)
       AND R.DESCRIPTION_NLSID = DM.MESSAGE_ID(+)
       AND R.DESCRIPTION_NLSID = DEM.MESSAGE_ID(+)
       group by  R.POLICY_NAME,PEM.MESSAGE,PM.MESSAGE,R.CATEGORY,CEM.MESSAGE,
       CM.MESSAGE,tp.TARGET_TYPE,t.type_display_name,R.description,DEM.MESSAGE,DM.MESSAGE');           

    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.TableRender.resourceBundle', 'oracle.sysman.eml.ecm.policy.util.PolicyJspMsg');

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid         => l_report_guid,
      p_element_name_nlsid  => 'IPMSG_TABLE_FROM_SQL',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_header_nlslid       => 'DISABLED_POLICIES_SUMMARY_HDR',
      p_element_order       => 2,
      p_element_row         => 2,
      p_parameters          => l_param_values,
      p_targets             => null
        );
    
    commit;
    
    --Detail table
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();

    l_param_values.extend(3);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'SELECT NVL(PM.MESSAGE, NVL(PEM.MESSAGE, R.POLICY_NAME)) LBL_POLICYRULE,
      NVL(t.DISPLAY_NAME,t.TARGET_NAME) LBL_TARGET 
      from mgmt$target_policies tp,mgmt$policies R,mgmt$target t,
       (SELECT MESSAGE, MESSAGE_ID FROM MGMT$MESSAGES
        WHERE SUBSYSTEM = ''POLICY''
            AND LANGUAGE_CODE = ??EMIP_BIND_LOCALE_LANGUAGE??
            AND COUNTRY_CODE = ??EMIP_BIND_LOCALE_COUNTRY??) PM,
        (SELECT MESSAGE, MESSAGE_ID FROM MGMT$MESSAGES
         WHERE SUBSYSTEM = ''POLICY''
            AND LANGUAGE_CODE = ''en''
            AND COUNTRY_CODE = '' '') PEM      
      WHERE tp.IS_ENABLED=0 
       AND tp.target_guid = ??EMIP_BIND_TARGET_GUID??
       AND tp.target_guid = t.target_guid
       AND R.target_type=tp.target_type 
       AND R.policy_guid=tp.policy_guid 
       AND R.POLICY_LABEL_NLSID = PM.MESSAGE_ID (+)
       AND R.POLICY_LABEL_NLSID = PEM.MESSAGE_ID (+)
       GROUP BY R.POLICY_NAME,t.TARGET_NAME,t.DISPLAY_NAME,PM.MESSAGE,PEM.MESSAGE');

    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.TableRender.tableSplitColumn', '0');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.TableRender.resourceBundle', 'oracle.sysman.eml.ecm.policy.util.PolicyJspMsg');

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid         => l_report_guid,
      p_element_name_nlsid  => 'IPMSG_TABLE_FROM_SQL',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_header_nlslid       => 'DISABLED_POLICIES_DETAILS_HDR',
      p_element_order       => 3,
      p_element_row         => 3,
      p_parameters          => l_param_values,
      p_targets             => null
        );

    COMMIT;      
  END;
END;
/
SET DEFINE ON