Rem
Rem $Header: suppressed_viol_enterprise_reports.sql 20-apr-2005.07:42:33 niramach Exp $
Rem
Rem suppressed_viol_enterprise_reports.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      suppressed_viol_enterprise_reports.sql - Suppressed violations out of box policy report for enterprise
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    niramach    08/02/05 - Move delta between beta and production to 
Rem                           v102020. 
Rem    lgloyd      06/21/05 - consolidate cat/subcat 
Rem    niramach    06/14/05 - Change the order by to policy rule name. 
Rem    niramach    04/28/05 - Fix for bug 4334353 
Rem    niramach    04/20/05 - niramach_repos_upgrade
Rem    niramach    04/13/05 - Avoid duplication of records. 
Rem    niramach    03/01/05 - add NLS Support. 
Rem    niramach    02/28/05 - niramach_policy_reports_fixes
Rem    niramach    02/23/05 - Created
Rem

SET DEFINE OFF

BEGIN
 
  DECLARE 
    l_param_values  MGMT_IP_PARAM_VALUE_LIST;
    l_target_types  MGMT_IP_TARGET_TYPES;    
    l_report_guid   RAW(16);
    l_element_guid  RAW(16);


  BEGIN


    -------------------------------------------------------------------
    -- Enterprise Policies
    -------------------------------------------------------------------
    l_report_guid := mgmt_ip.create_report_definition (
      p_title_nlsid                   => 'EMIPID_SUPPRESSED_VIOL_GENERAL',
      p_description_nlsid             => 'SUPPRESSEDVIOLATIONS_DESC',
      p_owner                         => 'SYSMAN',
      p_category_nlsid                => 'EMIPID_POLICIES',
      p_sub_category_nlsid            => 'SUPPRESSED_VIOLATIONS_HDR',
      p_late_binding_target_types     =>  null,
      p_late_binding_multi_targets    =>  0,
      p_show_table_of_contents        =>  0,
      p_system_report                 =>  1,
      p_help_topic_id                 => 'info_pub_gc_cs_pol_supp_viol_all_targets'
        ); 
 


    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(3);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage',
      'SUPPRESSED_VIOL_ENTERPRISE_REP_DESC');
    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle',
      'OraInstructionText');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName',
      'oracle.sysman.eml.ecm.policy.util.PolicyJspMsg');
  
     --Instruction text element   
    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid         => l_report_guid,
      p_element_name_nlsid  => 'IPMSG_STYLED_TEXT',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_header_nlsid        => null,
      p_element_order       => 1,
      p_element_row         => 1,
      p_parameters          => l_param_values,
      p_targets             => null
        );    
    
 --table
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();

    l_param_values.extend(5);

    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.sqlStatement',
      'SELECT NVL(PM.MESSAGE, NVL(PEM.MESSAGE, R.POLICY_NAME)) LBL_POLICYRULE,
       NVL(CM.MESSAGE, NVL(CEM.MESSAGE, R.CATEGORY)) LBL_CATEGORY,V.VIOLATION_LEVEL AS LBL_SEVERITY,
       V.MESSAGE AS LBL_MESSAGE,NVL(t.DISPLAY_NAME,V.TARGET_NAME) LBL_TARGET,
       NVL(t.type_display_name,V.TARGET_TYPE) LBL_TYPE,
       NVL(V.SUPPRESS_BY, '' '') AS EXEMPT_BY,   
       DECODE(V.SUPPRESS_CODE, ''1'', ''EXEMPT_MANUAL'',''2'', V.SUPPRESS_UNTIL,
       ''3'', ''EXEMPT_NEXTEVAL'') AS EXEMPT_UNTIL
       FROM mgmt$policy_violation_current V, mgmt$target_policies TP, mgmt$policies R,
       mgmt$target t,
       (SELECT MESSAGE, MESSAGE_ID FROM MGMT$MESSAGES
        WHERE SUBSYSTEM = ''POLICY''
            AND LANGUAGE_CODE = ??EMIP_BIND_LOCALE_LANGUAGE??
            AND COUNTRY_CODE = ??EMIP_BIND_LOCALE_COUNTRY??) PM,
        (SELECT MESSAGE, MESSAGE_ID FROM MGMT$MESSAGES
         WHERE SUBSYSTEM = ''POLICY''
            AND LANGUAGE_CODE = ''en''
            AND COUNTRY_CODE = '' '') PEM,
        (SELECT MESSAGE, MESSAGE_ID FROM MGMT$MESSAGES
         WHERE SUBSYSTEM = ''CATEGORY''
            AND LANGUAGE_CODE = ??EMIP_BIND_LOCALE_LANGUAGE??
            AND COUNTRY_CODE = ??EMIP_BIND_LOCALE_COUNTRY??) CM,
        (SELECT MESSAGE, MESSAGE_ID FROM MGMT$MESSAGES
         WHERE SUBSYSTEM = ''CATEGORY''
            AND LANGUAGE_CODE = ''en''
            AND COUNTRY_CODE = '' '') CEM  
        WHERE TP.POLICY_GUID = V.POLICY_GUID
        AND V.target_guid = t.target_guid
        AND tp.target_guid = t.target_guid
        AND V.SUPPRESS_CODE > 0        
        AND R.POLICY_GUID = TP.POLICY_GUID
        AND R.POLICY_LABEL_NLSID = PM.MESSAGE_ID (+)
        AND R.POLICY_LABEL_NLSID = PEM.MESSAGE_ID (+)
        AND R.CATEGORY_NLSID = CM.MESSAGE_ID(+)
        AND R.CATEGORY_NLSID = CEM.MESSAGE_ID(+)
        order by 2');
    
    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.TableRender.severityColumn', '2');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.TableRender.resourceBundle', 'oracle.sysman.eml.ecm.policy.util.PolicyJspMsg');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.TableRender.translateColumnValueColumns', '7');    
    l_param_values(5) := MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.TableRender.numRowsToShow','25');

    l_element_guid := mgmt_ip.add_element_to_report_def (
      p_report_guid         => l_report_guid,
      p_element_name_nlsid  => 'IPMSG_TABLE_FROM_SQL',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_header_nlslid       => null,
      p_element_order       => 2,
      p_element_row         => 2,
      p_parameters          => l_param_values,
      p_targets             => null
        );

    COMMIT;  
    
    END;

END;
/

SET DEFINE ON

