Rem drv: <migrate type="data_upgrade" version="10.2.0.0" pos="notification_data_upgrade.sql+"/>
Rem
Rem $Header: preferences_data_upgrade.sql 08-aug-2005.18:31:42 jpyang Exp $
Rem
Rem preferences_data_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      preferences_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jpyang      08/08/05 - jpyang_bug-4533214
Rem    jpyang      08/05/05 - Created
Rem

Rem Now add the generic columns that would have been added in 
Rem preferences_post_creation for a regular install and move the old prefs over.

DECLARE
  WILDCARD_USER_NAME_ALIAS        CONSTANT VARCHAR2(2) := '*';
  MGMT_USER_PREF_METRIC_COL_TP    CONSTANT NUMBER(1) := 0;
  MGMT_USER_PREF_PROPERTY_COL_TP  CONSTANT NUMBER(1) := 1;
  MGMT_USER_PREF_GENERIC_COL_TP   CONSTANT NUMBER(1) := 2;

  MGMT_USER_PREF_AVAIL_COL         CONSTANT VARCHAR2(20) := 'availability';
  MGMT_USER_PREF_ALERTS_COL        CONSTANT VARCHAR2(20) := 'alerts';
  MGMT_USER_PREF_POL_VIOL_COL      CONSTANT VARCHAR2(20) := 'policyviolation';
  MGMT_USER_PREF_POL_COMP_COLUMN   CONSTANT VARCHAR2(20) := 'policycompliance';

  PROCEDURE set_default_subtab_preferences(p_user_name     IN VARCHAR2,
                                           p_callback_type IN NUMBER)
  AS

  TYPE guid_list IS TABLE OF RAW(16);

  -- metrics for summary UI
  k_metrics CONSTANT guid_list := guid_list
    (HEXTORAW('0C71A1AFAC2D7199013837DA35522C08'),  -- Cpu Util %
     HEXTORAW('86821B5F0CE858D6E4A7F7390E88B73C'),  -- Memory Util %
     HEXTORAW('B2F6335B27BDD06BE55F69AC5A4FC2E7')); -- Total Disk IO

  BEGIN
    IF p_callback_type = MGMT_USER.USER_CREATED_CALLBACK THEN
      FOR l_metric_guid_i IN 1..k_metrics.COUNT
      LOOP
        INSERT INTO mgmt_user_subtab_col_prefs
          (user_name, subtab_name, column_id_guid, column_type, display_order)
        VALUES
          (p_user_name, mgmt_global.g_host_target_type,
           k_metrics(l_metric_guid_i), 0, 4 + l_metric_guid_i);
      END LOOP;
      -- Hosts default generic columns
      INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name,
                  column_id, column_type, display_order)
           VALUES (p_user_name,
                   mgmt_global.g_host_target_type,
                   mgmt_user_pref_avail_col,
                   mgmt_user_pref_generic_col_tp, 1);
      INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name,
                  column_id, column_type, display_order)
           VALUES (p_user_name,
                   mgmt_global.g_host_target_type,
                   mgmt_user_pref_alerts_col,
                   mgmt_user_pref_generic_col_tp, 2);
      INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name,
                  column_id, column_type, display_order)
           VALUES (p_user_name,
                   mgmt_global.g_host_target_type,
                   mgmt_user_pref_pol_viol_col,
                   mgmt_user_pref_generic_col_tp, 3);
      INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name,
                  column_id, column_type, display_order)
           VALUES (p_user_name,
                   mgmt_global.g_host_target_type,
                   mgmt_user_pref_pol_comp_column,
                   mgmt_user_pref_generic_col_tp, 4);
      COMMIT;
    END IF;
  
  END set_default_subtab_preferences;

BEGIN
  -- Hosts generic default columns
  set_default_subtab_preferences(
    WILDCARD_USER_NAME_ALIAS,
    mgmt_user.user_created_callback);
END;
/
show errors;

