Rem THIS FILE DOES NOT REQUIRE ANY HEADER AS IT IS BEING CALLED BY
Rem preferences_schema_upgrade.sql
Rem
Rem $Header: preferences_post_creation.sql 25-aug-2005.23:21:15 paachary Exp $
Rem
Rem preferences_post_creation.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      preferences_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    paachary    08/25/05 - paachary_upgrdbgs
Rem    paachary    08/24/05 - Created
Rem                           Refer Bug 4567891.
Rem
DECLARE
    -- This file is called from the main (latest) as well as the upgrade path (v102010). 
    -- there was some inconsistency in both the places, so making a common call to insert 
    -- the default columns for the subtabs.
    -- The constants are already a part of EMD_PREF package. But, when upgrading from older version
    -- to 10.2GC, the packaqe gets upgraded and created somewhere afgter this data insert.
    -- So replicating the constants here.
    -- Value for user alias wildcard
    WILDCARD_USER_NAME_ALIAS constant varchar2(1) := '*';

    MGMT_USER_PREF_METRIC_COL_TP    CONSTANT NUMBER(1) := 0;
    MGMT_USER_PREF_PROPERTY_COL_TP  CONSTANT NUMBER(1) := 1;
    MGMT_USER_PREF_GENERIC_COL_TP   CONSTANT NUMBER(1) := 2;

    -- Constants used to store prefs for subtabs
    MGMT_USER_PREF_ALL_TARGETS      CONSTANT VARCHAR2(20) := 'All Targets';
    MGMT_USER_PREF_GROUPS           CONSTANT VARCHAR2(20) := 'Groups';
    MGMT_USER_PREF_DATABASES        CONSTANT VARCHAR2(20) := 'Databases';
    MGMT_USER_PREF_APPSERVER        CONSTANT VARCHAR2(20) := 'applicationServers';
    MGMT_USER_PREF_WEBAPPS          CONSTANT VARCHAR2(20) := 'Web Applications';
    MGMT_USER_PREF_SYSTEMS          CONSTANT VARCHAR2(20) := 'Systems';
    MGMT_USER_PREF_SERVICES         CONSTANT VARCHAR2(20) := 'Services';

    -- Constants used to refer to the generic columns in subtabs (if modifying
    -- these values, please update their java counterparts)
    MGMT_USER_PREF_AVAIL_COL           CONSTANT VARCHAR2(20) := 'availability';
    MGMT_USER_PREF_STATUS_COLUMN       CONSTANT VARCHAR2(20) := 'status';
    MGMT_USER_PREF_ALERTS_COL          CONSTANT VARCHAR2(20) := 'alerts';
    MGMT_USER_PREF_NAME_COL            CONSTANT VARCHAR2(20) := 'targetName';
    MGMT_USER_PREF_TYPE_COL            CONSTANT VARCHAR2(20) := 'typeName';
    MGMT_USER_PREF_POL_VIOL_COL        CONSTANT VARCHAR2(20) := 'policyviolation';
    MGMT_USER_PREF_POL_COMP_COLUMN     CONSTANT VARCHAR2(20) := 'policycompliance';
    MGMT_USER_PREF_PERF_ALRTS_COL      CONSTANT VARCHAR2(20) := 'perfAlertsColumn';
    MGMT_USER_PREF_USAGE_ALRTS_COL     CONSTANT VARCHAR2(20) := 'usageAlertsColumn';
    MGMT_USER_PREF_SYS_KEY_CMP_COL     CONSTANT VARCHAR2(20) := 'systemkeycompnts';
    MGMT_USER_PREF_SYS_TESTS_COL       CONSTANT VARCHAR2(20) := 'systemkeytests';
    MGMT_USER_PREF_MNTRG_BCNS_COL      CONSTANT VARCHAR2(20) := 'monitoringbcns';
    MGMT_USER_PREF_GRP_MEM_COL         CONSTANT VARCHAR2(20) := 'grpMemberTypes';

BEGIN
  -- All Targets generic default columns
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_all_targets,
               mgmt_user_pref_avail_col,
               mgmt_user_pref_generic_col_tp, 1);

  -- Groups generic default columns
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name,
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_groups,
               mgmt_user_pref_alerts_col,
               mgmt_user_pref_generic_col_tp, 1);
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_groups,
               mgmt_user_pref_pol_viol_col,
               mgmt_user_pref_generic_col_tp, 2);
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name,
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_groups,
               mgmt_user_pref_grp_mem_col,
               mgmt_user_pref_generic_col_tp, 3);

  -- Services generic default columns
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_services,
               mgmt_user_pref_status_column,
               mgmt_user_pref_generic_col_tp, 1);
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_services,
               mgmt_user_pref_perf_alrts_col,
               mgmt_user_pref_generic_col_tp, 2);
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_services,
               mgmt_user_pref_usage_alrts_col,
               mgmt_user_pref_generic_col_tp, 3);
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_services,
               mgmt_user_pref_sys_key_cmp_col,
               mgmt_user_pref_generic_col_tp, 4);
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_services,
               mgmt_user_pref_sys_tests_col,
               mgmt_user_pref_generic_col_tp, 5);
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_services,
               mgmt_user_pref_mntrg_bcns_col,
               mgmt_user_pref_generic_col_tp, 6);

  
  -- website folder default columns
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_webapps,
               mgmt_user_pref_status_column,
               mgmt_user_pref_generic_col_tp, 1);
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_webapps,
               mgmt_user_pref_perf_alrts_col,
               mgmt_user_pref_generic_col_tp, 2);
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_webapps,
               mgmt_user_pref_usage_alrts_col,
               mgmt_user_pref_generic_col_tp, 3);
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_webapps,
               mgmt_user_pref_sys_key_cmp_col,
               mgmt_user_pref_generic_col_tp, 4);
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_webapps,
               mgmt_user_pref_sys_tests_col,
               mgmt_user_pref_generic_col_tp, 5);
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_webapps,
               mgmt_user_pref_mntrg_bcns_col,
               mgmt_user_pref_generic_col_tp, 6);
  

  -- Systems generic default columns
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_systems,
               mgmt_user_pref_alerts_col,
               mgmt_user_pref_generic_col_tp, 1);
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name, 
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_systems,
               mgmt_user_pref_pol_viol_col,
               mgmt_user_pref_generic_col_tp, 2);
  INSERT INTO mgmt_user_subtab_col_prefs(user_name, subtab_name,
              column_id, column_type, display_order)
       VALUES (wildcard_user_name_alias,
               mgmt_user_pref_systems,
               mgmt_user_pref_grp_mem_col,
               mgmt_user_pref_generic_col_tp, 3);

  COMMIT;
END;
/
