Rem drv: <migrate type="data_upgrade" version="10.2.0.0" pos="notification_data_upgrade.sql+"/>
Rem
Rem $Header: properties_data_upgrade.sql 02-sep-2005.00:08:29 rkpandey Exp $
Rem
Rem properties_data_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      properties_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem       Update all dynamic properties to instance properties.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rkpandey    09/01/05 - Supress PK violation on upgrade 
Rem    chyu        07/26/05 - modifying the migrate header position 
Rem    chyu        07/18/05 - updating the new rep manager header 
Rem    rkpandey    06/16/05 - add regrister log module 
Rem    jpyang      05/10/05 - add generic type properties 
Rem    asawant     02/15/05 - asawant_bug-4166967
Rem    asawant     02/08/05 - Created
Rem

BEGIN
  MGMT_LOG.REGISTER_LOGGING_MODULE(MGMT_PROPERTIES.PROPERTIES_MODULE,
                                   'Properties API');
  COMMIT;
END;
/

BEGIN
  DELETE 
    FROM mgmt_target_properties d
   WHERE UPPER(property_type) = 'DYNAMICINSTANCE'
     AND EXISTS(SELECT 1 
                  FROM mgmt_target_properties i
                 WHERE d.target_guid = i.target_guid
                   AND d.property_name = i.property_name
                   AND UPPER(i.property_type) = 'INSTANCE');
             
  UPDATE mgmt_target_properties
     SET property_type = 'INSTANCE'
   WHERE UPPER(property_type) = 'DYNAMICINSTANCE';
  COMMIT;
END;
/

BEGIN
  mgmt_properties.add_sys_target_property(
    p_property_name          => 'gtp_deployment_type',
    p_target_type_list       => NULL,
    p_property_display_name  => 'Deployment Type',
    p_property_display_nlsid => mgmt_properties.GTP_DEPLOYMENT_TYPE);

  mgmt_properties.add_sys_target_property(
    p_property_name          => 'gtp_contact',
    p_target_type_list       => NULL,
    p_property_display_name  => 'Contact',
    p_property_display_nlsid => mgmt_properties.GTP_CONTACT);

  mgmt_properties.add_sys_target_property(
    p_property_name          => 'gtp_line_of_bus',
    p_target_type_list       => NULL,
    p_property_display_name  => 'Line of Business',
    p_property_display_nlsid => mgmt_properties.GTP_LINE_OF_BUS);

  mgmt_properties.add_sys_target_property(
    p_property_name          => 'gtp_location',
    p_target_type_list       => NULL,
    p_property_display_name  => 'Location',
    p_property_display_nlsid => mgmt_properties.GTP_LOCATION);

  mgmt_properties.add_sys_target_property(
    p_property_name          => 'gtp_comment',
    p_target_type_list       => NULL,
    p_property_display_name  => 'Comment',
    p_property_display_nlsid => mgmt_properties.GTP_COMMENT);
  COMMIT;
END;
/

--
-- Add a target type addition callback.
--
BEGIN
  mgmt_target.add_tgttype_addition_callback(
    p_callback_name => 'mgmt_properties.propagate_target_properties');
  COMMIT;
END;
/

--
-- Add PL/SQL handler for data upload from older agents. This handler takes
-- care of converting DYNAMICINSTANCE props to INSTANCE.
--
BEGIN
  emd_loader.add_plsql_handler_for_rowset(
      p_rowset_name => 'MGMT_TARGET_PROPERTIES',
      p_proc_name => 'mgmt_properties.handle_mgmt_tgt_props');
  COMMIT;
END;
/

